/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.License;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class RegisterDonatorVersionDialog
extends TmmDialog {
    private static final long serialVersionUID = 9111695923659250520L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterDonatorVersionDialog.class);
    private JTextField tfName;
    private JTextField tfEmailAddress;

    public RegisterDonatorVersionDialog() {
        super(BUNDLE.getString("tmm.registerdonator"), "registerDonator");
        this.setBounds(166, 5, 400, 300);
        boolean isDonator = Globals.isDonator();
        Properties props = null;
        if (isDonator) {
            props = License.decrypt();
        }
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"250px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC}));
        JTextArea textArea = new JTextArea();
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        panelContent.add((Component)textArea, "2, 2, 3, 1, default, center");
        if (isDonator) {
            textArea.setText(BUNDLE.getString("tmm.registerdonator.thanks"));
        } else {
            textArea.setText(BUNDLE.getString("tmm.registerdonator.hint"));
        }
        JLabel lblName = new JLabel(BUNDLE.getString("tmm.registerdonator.name"));
        panelContent.add((Component)lblName, "2, 4, right, default");
        this.tfName = new JTextField("");
        lblName.setLabelFor(this.tfName);
        panelContent.add((Component)this.tfName, "4, 4, fill, default");
        this.tfName.setColumns(10);
        if (isDonator) {
            this.tfName.setText(props.getProperty("user"));
            this.tfName.setEnabled(false);
        }
        JLabel lblEmailAddress = new JLabel(BUNDLE.getString("tmm.registerdonator.email"));
        panelContent.add((Component)lblEmailAddress, "2, 6, right, default");
        this.tfEmailAddress = new JTextField("");
        lblEmailAddress.setLabelFor(this.tfEmailAddress);
        panelContent.add((Component)this.tfEmailAddress, "4, 6, fill, default");
        this.tfEmailAddress.setColumns(10);
        if (isDonator) {
            this.tfEmailAddress.setText(props.getProperty("email"));
            this.tfEmailAddress.setEnabled(false);
        }
        JPanel panelButtons = new JPanel();
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.getContentPane().add((Component)panelButtons, "South");
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        JButton btnRegister = new JButton(BUNDLE.getString("Button.register"));
        btnRegister.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegisterDonatorVersionDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    LOGGER.debug("registering for donator version: ", (Object)RegisterDonatorVersionDialog.this.tfEmailAddress.getText());
                    Properties p = new Properties();
                    p.setProperty("user", RegisterDonatorVersionDialog.this.tfName.getText());
                    p.setProperty("email", RegisterDonatorVersionDialog.this.tfEmailAddress.getText());
                    p.setProperty("generated", String.valueOf(new Date().getTime()));
                    p.setProperty("uuid", FileUtils.readFileToString((File)new File("tmm.uuid")));
                    if (License.encrypt(p) && License.isValid()) {
                        JOptionPane.showMessageDialog(RegisterDonatorVersionDialog.this, BUNDLE.getString("tmm.registerdonator.success"));
                        RegisterDonatorVersionDialog.this.setVisible(false);
                    } else {
                        JOptionPane.showMessageDialog(RegisterDonatorVersionDialog.this, BUNDLE.getString("tmm.registerdonator.error"));
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error registering donator version: " + ex.getMessage());
                }
                RegisterDonatorVersionDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        if (isDonator) {
            btnRegister.setEnabled(false);
        }
        panelButtons.add(btnRegister);
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RegisterDonatorVersionDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                RegisterDonatorVersionDialog.this.tfName.requestFocus();
            }
        });
    }

    @Override
    public void pack() {
    }
}

