/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.a.c.r;
import com.a.c.s;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.launcher.Getdown;
import com.threerings.getdown.launcher.ImageLoader;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.util.ConfigUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetdownAppletConfig {
    public static final String APPBASE = "appbase";
    public static final String APPNAME = "appname";
    public static final String BGIMAGE = "bgimage";
    public static final String ERRORBGIMAGE = "errorbgimage";
    public static final String PARAM_DELIMITER = ".";
    public static final String DIRECT = "direct";
    public static final String CONNECT = "connect";
    public static final String REDIRECT_ON_FINISH = "redirect_on_finish";
    public static final String REDIRECT_ON_FINISH_TARGET = "redirect_on_finish_target";
    public static final String JVMARG_PREFIX = "jvmargs";
    public static final String APPARG_PREFIX = "appargs";
    public String appbase;
    public String appname;
    public String imgpath;
    public String errorimgpath;
    public File appdir;
    public String[] jvmargs;
    public String[] appargs;
    public URL redirectUrl;
    public String redirectTarget;
    public String installerFileContents;
    public boolean invokeDirect;
    public boolean allowConnect;
    public Rectangle statusBounds;
    public Color statusColor;
    protected JApplet _applet;
    protected String _prefix;
    protected RotatingBackgrounds bgimages;
    protected Properties _properties = new Properties();

    public GetdownAppletConfig(JApplet jApplet) {
        this(jApplet, null);
    }

    public GetdownAppletConfig(JApplet stringArray, String object) {
        Object object2;
        String string5;
        this._applet = stringArray;
        this._prefix = object;
        this.appbase = this.getParameter(APPBASE, "");
        this.appname = this.getParameter(APPNAME, "");
        Log.log.a("App Base: " + this.appbase, new Object[0]);
        Log.log.a("App Name: " + this.appname, new Object[0]);
        this.imgpath = this.getParameter(BGIMAGE);
        this.errorimgpath = this.getParameter(ERRORBGIMAGE);
        stringArray = this.getParameter("properties");
        if (stringArray != null) {
            stringArray = stringArray.split(" ");
            object = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = object[i2];
                String string3 = string2.substring(string2.indexOf("-D") + 2, string2.indexOf("="));
                string5 = string2.substring(string2.indexOf("=") + 1);
                this._properties.setProperty(string3, string5);
            }
        }
        if (r.a()) {
            object2 = "Application Data";
            object = System.getProperty("os.version");
            try {
                if (Float.parseFloat((String)object) >= 6.0f) {
                    object2 = "AppData" + File.separator + "LocalLow";
                }
            }
            catch (Exception exception) {
                Log.log.b("Couldn't parse OS version", "vers", object, "error", exception);
            }
        } else {
            object2 = r.b() ? "Library" + File.separator + "Application Support" : ".getdown";
        }
        this.appdir = new File(System.getProperty("user.home") + File.separator + (String)object2 + File.separator + this.appname);
        this.installerFileContents = this.getParameter("installer");
        object = this.parseArgList(JVMARG_PREFIX);
        String string4 = this.getParameter("app_properties");
        if (string4 != null) {
            for (String string5 : string4.split(",")) {
                object.add("-D" + string5);
            }
        }
        this.jvmargs = object.toArray(new String[object.size()]);
        object2 = this.parseArgList(APPARG_PREFIX);
        this.appargs = object2.toArray(new String[object2.size()]);
        String string6 = this.getParameter(DIRECT, "false");
        this.invokeDirect = Boolean.valueOf(string6);
        String string7 = this.getParameter(CONNECT, "false");
        this.allowConnect = Boolean.valueOf(string7);
        string5 = this.getParameter(REDIRECT_ON_FINISH);
        if (string5 != null) {
            try {
                this.redirectUrl = new URL(string5);
                this.redirectTarget = this.getParameter(REDIRECT_ON_FINISH_TARGET);
            }
            catch (MalformedURLException malformedURLException) {
                Log.log.b("URL in redirect_on_finish param is malformed: " + malformedURLException, new Object[0]);
            }
        }
        this.statusBounds = Application.parseRect("ui.status", this.getParameter("ui.status"));
        this.statusColor = Application.parseColor(this.getParameter("ui.status_text"));
    }

    public void init() throws Exception {
        this.securityCheck();
        this.setSystemProperties();
        this.ensureAppdirExists();
        this.createFiles();
        Log.log.a("------------------ VM Info ------------------", new Object[0]);
        Log.log.a("-- OS Name: " + System.getProperty("os.name"), new Object[0]);
        Log.log.a("-- OS Arch: " + System.getProperty("os.arch"), new Object[0]);
        Log.log.a("-- OS Vers: " + System.getProperty("os.version"), new Object[0]);
        Log.log.a("-- Java Vers: " + System.getProperty("java.version"), new Object[0]);
        Log.log.a("-- Java Home: " + System.getProperty("java.home"), new Object[0]);
        Log.log.a("-- User Name: " + System.getProperty("user.name"), new Object[0]);
        Log.log.a("-- User Home: " + System.getProperty("user.home"), new Object[0]);
        Log.log.a("-- Cur dir: " + System.getProperty("user.dir"), new Object[0]);
        Log.log.a("---------------------------------------------", new Object[0]);
    }

    public void config(Getdown getdown) {
        if (this.statusBounds != null) {
            getdown._ifc.status = this.statusBounds;
        }
        if (this.statusColor != null) {
            getdown._ifc.statusText = this.statusColor;
        }
    }

    public String getParameter(String string) {
        if (this._prefix == null) {
            return this._applet.getParameter(string);
        }
        return this._applet.getParameter(this._prefix + PARAM_DELIMITER + string);
    }

    public String getParameter(String string, String string2) {
        if ((string = this.getParameter(string)) == null) {
            return string2;
        }
        return string;
    }

    public void redirect() {
        if (this.redirectUrl != null) {
            if (this.redirectTarget == null) {
                this._applet.getAppletContext().showDocument(this.redirectUrl);
                return;
            }
            this._applet.getAppletContext().showDocument(this.redirectUrl, this.redirectTarget);
        }
    }

    public RotatingBackgrounds getBackgroundImages(ImageLoader imageLoader) {
        if (this.bgimages == null) {
            this.bgimages = GetdownAppletConfig.getBackgroundImages(this.imgpath, this.errorimgpath, imageLoader);
        }
        return this.bgimages;
    }

    public static RotatingBackgrounds getBackgroundImages(String object, String string, ImageLoader imageLoader) {
        object = object == null ? new RotatingBackgrounds() : (((String)object).indexOf(",") >= 0 ? new RotatingBackgrounds(((String)object).split(","), string, imageLoader) : new RotatingBackgrounds(imageLoader.loadImage((String)object)));
        return object;
    }

    protected List<String> parseArgList(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((string2 = this.getParameter(string + n2)) != null) {
            arrayList.add(string2);
            ++n2;
        }
        return arrayList;
    }

    protected void securityCheck() throws Exception {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPropertiesAccess();
                securityManager.checkWrite("getdown");
                return;
            }
            catch (SecurityException securityException) {
                Log.log.b("Signed applet rejected by user", "se", securityException);
                throw new Exception("m.insufficient_permissions_error");
            }
        }
    }

    protected void setSystemProperties() {
        System.getProperties().putAll((Map<?, ?>)this._properties);
    }

    protected void ensureAppdirExists() throws Exception {
        if (!(this.appdir.exists() && this.appdir.isDirectory() || this.appdir.mkdirs())) {
            throw new Exception("m.create_appdir_failed");
        }
    }

    protected void createFiles() throws Exception {
        boolean bl;
        File file;
        if (!s.a(this.installerFileContents) && !(file = new File(this.appdir, "installer.txt")).exists()) {
            this.writeToFile(file, this.installerFileContents);
        }
        if (!(bl = !(file = new File(this.appdir, "getdown.txt")).exists())) {
            try {
                Map<String, Object> map = ConfigUtil.parseConfig(file, false);
                String string = s.b((String)map.get(APPBASE));
                bl = this.appbase != null && !this.appbase.trim().equals(string);
                if (bl) {
                    Log.log.b("Recreating getdown.txt due to appbase mismatch", "nappbase", this.appbase, "oappbase", string);
                }
            }
            catch (Exception exception) {
                Log.log.b("Failure checking validity of getdown.txt, forcing recreate.", "error", exception);
                bl = true;
            }
        }
        if (bl) {
            if (s.a(this.appbase)) {
                throw new Exception("m.missing_appbase");
            }
            if (!this.writeToFile(file, "appbase = " + this.appbase)) {
                throw new Exception("m.create_getdown_failed");
            }
        }
    }

    protected boolean writeToFile(File file, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println(string);
            printStream.close();
            return true;
        }
        catch (IOException iOException) {
            Log.log.b("Failed to create '" + file + "'.", iOException);
            return false;
        }
    }
}

