/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.panels.MediaFilesPanel;
import org.tinymediamanager.ui.tvshows.TvShowSeasonSelectionModel;

public class TvShowSeasonInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1911808562993073590L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private EventList<TvShowEpisode> episodeEventList;
    private EventList<MediaFile> mediaFileEventList;
    private DefaultEventTableModel<TvShowEpisode> episodeTableModel = null;
    private TvShowSeasonSelectionModel tvShowSeasonSelectionModel;
    private JSplitPane splitPaneVertical;
    private JPanel panelTop;
    private ImageLabel lblTvShowPoster;
    private JLabel lblPosterSize;
    private JPanel panelRight;
    private JPanel panelLeft;
    private JLabel lblTvshowTitle;
    private JLabel lblSeasonT;
    private JLabel lblSeason;
    private JSeparator separator;
    private JLabel lblEpisodelistT;
    private JScrollPane scrollPaneEpisodes;
    private JTable tableEpisodes;
    private JPanel panelBottom;
    private JLabel lblMediaFiles;
    private MediaFilesPanel panelMediaFiles;

    public TvShowSeasonInformationPanel(TvShowSeasonSelectionModel tvShowSeasonSelectionModel) {
        this.tvShowSeasonSelectionModel = tvShowSeasonSelectionModel;
        this.episodeEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShowEpisode.class));
        this.mediaFileEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFile.class));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow(4)")}, new RowSpec[]{RowSpec.decode((String)"fill:default:grow")}));
        this.panelLeft = new JPanel();
        this.add((Component)this.panelLeft, "1, 1, fill, fill");
        this.panelLeft.setLayout(new ColumnLayout());
        this.lblTvShowPoster = new ImageLabel(false){
            private static final long serialVersionUID = -4774846565578766742L;

            @Override
            public Dimension getPreferredSize() {
                if (this.scaledImage != null && this.scaledImage.getWidth() > 10) {
                    return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.scaledImage.getWidth() * (float)this.scaledImage.getHeight()));
                }
                return new Dimension(this.getParent().getWidth(), (int)((double)this.getParent().getWidth() / 2.0 * 3.0) + 1);
            }
        };
        this.lblTvShowPoster.setDesiredAspectRatio(0.6666667f);
        this.panelLeft.add(this.lblTvShowPoster);
        this.lblTvShowPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblTvShowPoster.enableLightbox();
        this.lblPosterSize = new JLabel(BUNDLE.getString("mediafiletype.poster"));
        this.panelLeft.add(this.lblPosterSize);
        this.panelRight = new JPanel();
        this.add((Component)this.panelRight, "3, 1, fill, fill");
        this.panelRight.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"200px:grow")}, new RowSpec[]{RowSpec.decode((String)"fill:default:grow")}));
        this.splitPaneVertical = new JSplitPane();
        this.panelRight.add((Component)this.splitPaneVertical, "1, 1, fill, fill");
        this.splitPaneVertical.setBorder(null);
        this.splitPaneVertical.setResizeWeight(0.5);
        this.splitPaneVertical.setContinuousLayout(true);
        this.splitPaneVertical.setOneTouchExpandable(true);
        this.splitPaneVertical.setOrientation(0);
        this.panelTop = new JPanel();
        this.panelTop.setBorder(null);
        this.splitPaneVertical.setTopComponent(this.panelTop);
        this.panelTop.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{RowSpec.decode((String)"fill:default"), FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"top:default:grow")}));
        this.lblTvshowTitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTvshowTitle, 1.33, 1);
        this.panelTop.add((Component)this.lblTvshowTitle, "2, 1, 3, 1");
        this.lblSeasonT = new JLabel(BUNDLE.getString("metatag.season"));
        TmmFontHelper.changeFont(this.lblSeasonT, 1.166, 1);
        this.panelTop.add((Component)this.lblSeasonT, "2, 3");
        this.lblSeason = new JLabel("");
        TmmFontHelper.changeFont(this.lblSeason, 1.166, 1);
        this.panelTop.add((Component)this.lblSeason, "4, 3");
        this.separator = new JSeparator();
        this.panelTop.add((Component)this.separator, "2, 5, 3, 1");
        this.lblEpisodelistT = new JLabel(BUNDLE.getString("metatag.episodes"));
        this.panelTop.add((Component)this.lblEpisodelistT, "2, 7, 3, 1");
        this.episodeTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.episodeEventList), (TableFormat)new EpisodeTableFormat());
        this.tableEpisodes = new ZebraJTable((TableModel)this.episodeTableModel);
        this.scrollPaneEpisodes = ZebraJTable.createStripedJScrollPane(this.tableEpisodes);
        this.panelTop.add((Component)this.scrollPaneEpisodes, "2, 9, 3, 1, fill, fill");
        this.panelBottom = new JPanel();
        this.splitPaneVertical.setRightComponent(this.panelBottom);
        this.panelBottom.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.lblMediaFiles = new JLabel(BUNDLE.getString("metatag.mediafiles"));
        this.panelBottom.add((Component)this.lblMediaFiles, "2, 2");
        this.panelMediaFiles = new MediaFilesPanel(this.mediaFileEventList){

            @Override
            public MediaEntity getMediaEntity() {
                return null;
            }
        };
        this.panelBottom.add((Component)this.panelMediaFiles, "2, 4, fill, fill");
        this.scrollPaneEpisodes.setViewportView(this.tableEpisodes);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source instanceof TvShowSeasonSelectionModel || source instanceof TvShowSeason && ("mediaFiles".equals(propertyChangeEvent.getPropertyName()) || "addedEpisode".equals(propertyChangeEvent.getPropertyName()) || "removedEpisode".equals(propertyChangeEvent.getPropertyName()))) {
                    TvShowSeason selectedSeason;
                    if (source instanceof TvShowSeasonSelectionModel) {
                        TvShowSeasonSelectionModel model = (TvShowSeasonSelectionModel)source;
                        selectedSeason = model.getSelectedTvShowSeason();
                    } else {
                        selectedSeason = (TvShowSeason)source;
                    }
                    TvShowSeasonInformationPanel.this.setPoster(selectedSeason);
                    try {
                        TvShowSeasonInformationPanel.this.episodeEventList.getReadWriteLock().writeLock().lock();
                        TvShowSeasonInformationPanel.this.episodeEventList.clear();
                        TvShowSeasonInformationPanel.this.episodeEventList.addAll(selectedSeason.getEpisodes());
                    }
                    catch (Exception e) {
                    }
                    finally {
                        TvShowSeasonInformationPanel.this.episodeEventList.getReadWriteLock().writeLock().unlock();
                    }
                    try {
                        TvShowSeasonInformationPanel.this.mediaFileEventList.getReadWriteLock().writeLock().lock();
                        TvShowSeasonInformationPanel.this.mediaFileEventList.clear();
                        TvShowSeasonInformationPanel.this.mediaFileEventList.addAll(selectedSeason.getMediaFiles());
                    }
                    catch (Exception e) {
                    }
                    finally {
                        TvShowSeasonInformationPanel.this.mediaFileEventList.getReadWriteLock().writeLock().unlock();
                    }
                    try {
                        TvShowSeasonInformationPanel.this.panelMediaFiles.adjustColumns();
                        TableColumnResizer.adjustColumnPreferredWidths(TvShowSeasonInformationPanel.this.tableEpisodes, 6);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (source.getClass() == TvShowSeason.class && "poster".equals(property)) {
                    TvShowSeason season = (TvShowSeason)source;
                    TvShowSeasonInformationPanel.this.setPoster(season);
                }
            }
        };
        this.initDataBindings();
        tvShowSeasonSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void setPoster(TvShowSeason season) {
        this.lblTvShowPoster.clearImage();
        this.lblTvShowPoster.setImagePath(season.getPoster());
        Dimension posterSize = season.getPosterSize();
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSeasonSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowSeason.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty, (Object)this.lblTvshowTitle, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSeasonSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowSeason.season");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty_1, (Object)this.lblSeason, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }

    private static class EpisodeTableFormat
    implements AdvancedTableFormat<TvShowEpisode> {
        private EpisodeTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.episode");
                }
                case 1: {
                    return BUNDLE.getString("metatag.title");
                }
                case 2: {
                    return BUNDLE.getString("metatag.aired");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(TvShowEpisode episode, int column) {
            switch (column) {
                case 0: {
                    return episode.getEpisode();
                }
                case 1: {
                    return episode.getTitle();
                }
                case 2: {
                    return episode.getFirstAiredAsString();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }
    }
}

