/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ImageCacheTask;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.UTF8Control;

public class RebuildImageCacheAction
extends AbstractAction {
    private static final long serialVersionUID = -9178351750617647813L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public RebuildImageCacheAction() {
        this.putValue("Name", BUNDLE.getString("tmm.rebuildimagecache"));
        this.putValue("ShortDescription", BUNDLE.getString("tmm.rebuildimagecache"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (!Globals.settings.isImageCache()) {
            JOptionPane.showMessageDialog(null, "Image cache is not activated!");
            return;
        }
        ArrayList<Path> imageFiles = new ArrayList<Path>();
        ArrayList<Movie> movies = new ArrayList<Movie>(MovieList.getInstance().getMovies());
        for (Movie movie : movies) {
            imageFiles.addAll(movie.getImagesToCache());
        }
        ArrayList<MovieSet> movieSets = new ArrayList<MovieSet>(MovieList.getInstance().getMovieSetList());
        for (MovieSet movieSet : movieSets) {
            imageFiles.addAll(movieSet.getImagesToCache());
        }
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(TvShowList.getInstance().getTvShows());
        for (TvShow tvShow : tvShows) {
            imageFiles.addAll(tvShow.getImagesToCache());
        }
        ImageCacheTask task = new ImageCacheTask(imageFiles);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

