/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ParserUtils;

@XmlRootElement(name="episodedetails")
@XmlType(propOrder={"title", "showtitle", "rating", "votes", "season", "episode", "uniqueid", "displayseason", "displayepisode", "plot", "thumb", "mpaa", "tags", "playcount", "lastplayed", "watched", "credits", "director", "aired", "premiered", "studio", "source", "actors", "fileinfo", "unsupportedElements"})
public class TvShowEpisodeToXbmcNfoConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeToXbmcNfoConnector.class);
    private static JAXBContext context = TvShowEpisodeToXbmcNfoConnector.initContext();
    private String season = "";
    private String episode = "";
    private String displayseason = "";
    private String displayepisode = "";
    private String uniqueid = "";
    private String title = "";
    private String showtitle = "";
    private float rating = 0.0f;
    private int votes = 0;
    private String plot = "";
    @XmlElement(name="studio")
    private List<String> studio = null;
    private String mpaa = "";
    private String aired = "";
    private String premiered = "";
    private String source;
    @XmlElement
    private int playcount = 0;
    @XmlElement
    private boolean watched = false;
    @XmlAnyElement(lax=true)
    private List<Object> actors = new ArrayList<Object>();
    @XmlElement
    private Fileinfo fileinfo;
    @XmlElement(name="credits")
    private List<String> credits;
    @XmlElement(name="director")
    private List<String> director = new ArrayList<String>();
    @XmlElement(name="tag")
    private List<String> tags;
    @XmlAnyElement(lax=true)
    private List<Object> unsupportedElements;
    @XmlElement
    String thumb;
    @XmlElement
    String lastplayed;

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{TvShowEpisodeToXbmcNfoConnector.class, Actor.class});
        }
        catch (JAXBException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public TvShowEpisodeToXbmcNfoConnector() {
        this.credits = new ArrayList<String>();
        this.tags = new ArrayList<String>();
        this.unsupportedElements = new ArrayList<Object>();
    }

    public static void setData(List<TvShowEpisode> tvShowEpisodes) {
        boolean multiEpisode;
        boolean bl = multiEpisode = tvShowEpisodes.size() > 1;
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShowEpisodes.get(0), "message.nfo.writeerror", new String[]{":", "Context is null"}));
            return;
        }
        if (tvShowEpisodes.size() == 0) {
            return;
        }
        TvShowEpisode episode = tvShowEpisodes.get(0);
        MediaFile mf = episode.getBiggestMediaFile(MediaFileType.VIDEO);
        if (mf == null) {
            return;
        }
        String nfoFilename = mf.getBasename() + ".nfo";
        if (episode.isDisc()) {
            if (mf.isBlurayFile()) {
                nfoFilename = "BDMV.nfo";
            }
            if (mf.isDVDFile()) {
                nfoFilename = "VIDEO_TS.nfo";
            }
        }
        File nfoFile = new File(episode.getPath(), nfoFilename);
        List<TvShowEpisodeToXbmcNfoConnector> xbmcConnectors = TvShowEpisodeToXbmcNfoConnector.parseNfo(nfoFile);
        StringBuilder outputXml = new StringBuilder();
        for (int i = 0; i < tvShowEpisodes.size(); ++i) {
            Subtitle sub;
            MediaFile mediaFile;
            episode = tvShowEpisodes.get(i);
            ArrayList<Object> unsupportedTags = new ArrayList<Object>();
            TvShowEpisodeToXbmcNfoConnector xbmc = null;
            for (TvShowEpisodeToXbmcNfoConnector con : xbmcConnectors) {
                if (!String.valueOf(episode.getEpisode()).equals(con.episode) || !String.valueOf(episode.getSeason()).equals(con.season)) continue;
                xbmc = con;
                break;
            }
            if (xbmc == null) {
                xbmc = new TvShowEpisodeToXbmcNfoConnector();
            } else {
                for (Object obj : xbmc.actors) {
                    if (obj instanceof Actor) continue;
                    unsupportedTags.add(obj);
                }
            }
            xbmc.setTitle(episode.getTitle());
            xbmc.setShowtitle(episode.getTvShow().getTitle());
            xbmc.setRating(episode.getRating());
            xbmc.setVotes(episode.getVotes());
            xbmc.setSeason(String.valueOf(episode.getSeason()));
            xbmc.setEpisode(String.valueOf(episode.getEpisode()));
            xbmc.setDisplayseason(String.valueOf(episode.getDisplaySeason()));
            xbmc.setDisplayepisode(String.valueOf(episode.getDisplayEpisode()));
            xbmc.setPlot(episode.getPlot());
            xbmc.setAired(episode.getFirstAiredFormatted());
            xbmc.setPremiered(episode.getFirstAiredFormatted());
            xbmc.setSource(episode.getMediaSource().name());
            if (StringUtils.isNotEmpty((CharSequence)episode.getTvShow().getProductionCompany())) {
                xbmc.studio = Arrays.asList(episode.getTvShow().getProductionCompany().split("\\s*[,\\/]\\s*"));
            }
            if (episode.getTvdbId() != null) {
                xbmc.setUniqueid(episode.getTvdbId().toString());
            }
            xbmc.setMpaa(episode.getTvShow().getCertification().getName());
            xbmc.watched = episode.isWatched();
            if (xbmc.watched) {
                xbmc.playcount = 1;
            }
            xbmc.actors.clear();
            for (TvShowActor actor : episode.getGuests()) {
                xbmc.addActor(actor.getName(), actor.getCharacter(), actor.getThumbUrl());
            }
            xbmc.thumb = multiEpisode && StringUtils.isNotBlank((CharSequence)episode.getArtworkUrl(MediaFileType.THUMB)) ? episode.getArtworkUrl(MediaFileType.THUMB) : "";
            xbmc.director.clear();
            if (StringUtils.isNotEmpty((CharSequence)episode.getDirector())) {
                String[] directors;
                for (String director : directors = episode.getDirector().split(", ")) {
                    xbmc.addDirector(director);
                }
            }
            xbmc.credits.clear();
            if (StringUtils.isNotEmpty((CharSequence)episode.getWriter())) {
                String[] writers;
                for (String writer : writers = episode.getWriter().split(", ")) {
                    xbmc.addCredits(writer);
                }
            }
            xbmc.tags.clear();
            for (String tag : episode.getTags()) {
                xbmc.tags.add(tag);
            }
            Fileinfo info = new Fileinfo();
            Iterator<MediaFile> i$ = episode.getMediaFiles(MediaFileType.VIDEO).iterator();
            if (i$.hasNext() && !StringUtils.isEmpty((CharSequence)(mediaFile = i$.next()).getVideoCodec())) {
                info.streamdetails.video.codec = mediaFile.getVideoCodec();
                info.streamdetails.video.aspect = String.valueOf(mediaFile.getAspectRatio());
                info.streamdetails.video.width = mediaFile.getVideoWidth();
                info.streamdetails.video.height = mediaFile.getVideoHeight();
                info.streamdetails.video.durationinseconds = mediaFile.getDuration();
                if (mediaFile.getVideo3DFormat().equals("3D SBS") || mediaFile.getVideo3DFormat().equals("3D HSBS")) {
                    info.streamdetails.video.stereomode = "left_right";
                } else if (mediaFile.getVideo3DFormat().equals("3D TAB") || mediaFile.getVideo3DFormat().equals("3D HTAB")) {
                    info.streamdetails.video.stereomode = "top_bottom";
                }
                for (MediaFileAudioStream as : mediaFile.getAudioStreams()) {
                    Audio audio = new Audio();
                    if (StringUtils.isNotBlank((CharSequence)as.getCodec())) {
                        audio.codec = as.getCodec().replaceAll("-", "_");
                    } else {
                        audio.codec = as.getCodec();
                    }
                    audio.language = as.getLanguage();
                    audio.channels = String.valueOf(as.getChannelsAsInt());
                    info.streamdetails.audio.add(audio);
                }
                for (MediaFileSubtitle ss : mediaFile.getSubtitles()) {
                    sub = new Subtitle();
                    sub.language = ss.getLanguage();
                    info.streamdetails.subtitle.add(sub);
                }
            }
            for (MediaFile mediaFile2 : episode.getMediaFiles(MediaFileType.SUBTITLE)) {
                for (MediaFileSubtitle ss : mediaFile2.getSubtitles()) {
                    sub = new Subtitle();
                    sub.language = ss.getLanguage();
                    info.streamdetails.subtitle.add(sub);
                }
            }
            xbmc.fileinfo = info;
            xbmc.unsupportedElements.addAll(unsupportedTags);
            try {
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.encoding", (Object)"UTF-8");
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                String comment = "<!-- created on " + dat + " - tinyMediaManager " + Globals.settings.getVersion() + " -->\n";
                m.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)comment);
                StringWriter w = new StringWriter();
                m.marshal((Object)xbmc, (Writer)w);
                StringBuilder sb = new StringBuilder(((Object)w).toString());
                ((Writer)w).close();
                if (i > 0) {
                    sb = new StringBuilder(sb.toString().replaceAll("<\\?xml.*\\?>", ""));
                }
                if (SystemUtils.IS_OS_WINDOWS) {
                    sb = new StringBuilder(sb.toString().replaceAll("(?<!\r)\n", "\r\n"));
                }
                outputXml.append((CharSequence)sb);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("setData " + nfoFile.getAbsolutePath(), (Object)e.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShowEpisodes.get(0), "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        try {
            FileUtils.write((File)nfoFile, (CharSequence)outputXml, (String)"UTF-8");
            for (TvShowEpisode e : tvShowEpisodes) {
                e.removeAllMediaFiles(MediaFileType.NFO);
                e.addToMediaFiles(new MediaFile(nfoFile));
            }
        }
        catch (Exception e) {
            LOGGER.error("setData " + nfoFile.getAbsolutePath(), (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShowEpisodes.get(0), "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public static List<TvShowEpisode> getData(File nfo) {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(1);
        if (context == null) {
            return episodes;
        }
        List<TvShowEpisodeToXbmcNfoConnector> xbmcConnectors = TvShowEpisodeToXbmcNfoConnector.parseNfo(nfo);
        for (TvShowEpisodeToXbmcNfoConnector xbmc : xbmcConnectors) {
            if (StringUtils.isEmpty((CharSequence)xbmc.getTitle())) continue;
            TvShowEpisode episode = new TvShowEpisode();
            episode.setTitle(xbmc.getTitle());
            episode.setPlot(xbmc.getPlot());
            episode.setRating(xbmc.getRating());
            episode.setVotes(xbmc.getVotes());
            try {
                episode.setEpisode(Integer.parseInt(xbmc.getEpisode()));
                episode.setSeason(Integer.parseInt(xbmc.getSeason()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                episode.setDisplayEpisode(Integer.parseInt(xbmc.getDisplayepisode()));
                episode.setDisplaySeason(Integer.parseInt(xbmc.getDisplayseason()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            episode.setVotes(xbmc.getVotes());
            episode.setWatched(xbmc.watched);
            if (xbmc.playcount > 0) {
                episode.setWatched(true);
            }
            String director = "";
            for (String dir : xbmc.getDirector()) {
                if (!StringUtils.isEmpty((CharSequence)director)) {
                    director = director + ", ";
                }
                director = director + dir;
            }
            episode.setDirector(director);
            String writer = "";
            for (String wri : xbmc.getCredits()) {
                if (StringUtils.isNotEmpty((CharSequence)writer)) {
                    writer = writer + ", ";
                }
                writer = writer + wri;
            }
            episode.setWriter(writer);
            episode.setFirstAired(xbmc.getAired());
            for (Actor actor : xbmc.getActors()) {
                TvShowActor cast = new TvShowActor(actor.getName(), actor.getRole());
                cast.setThumbUrl(actor.getThumb());
                episode.addActor(cast);
            }
            for (String tag : xbmc.tags) {
                episode.addToTags(tag);
            }
            if (StringUtils.isNotBlank((CharSequence)xbmc.getSource())) {
                try {
                    MediaSource source = MediaSource.valueOf(xbmc.getSource());
                    if (source != null) {
                        episode.setMediaSource(source);
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            episode.addToMediaFiles(new MediaFile(nfo, MediaFileType.NFO));
            episodes.add(episode);
        }
        return episodes;
    }

    @XmlElement(name="title")
    public String getTitle() {
        return this.title;
    }

    @XmlElement(name="uniqueid")
    public String getUniqueid() {
        return this.uniqueid;
    }

    public void setUniqueid(String uniqueid) {
        this.uniqueid = uniqueid;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlElement(name="season")
    public String getSeason() {
        return this.season;
    }

    @XmlElement(name="episode")
    public String getEpisode() {
        return this.episode;
    }

    @XmlElement(name="showtitle")
    public String getShowtitle() {
        return this.showtitle;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public void setEpisode(String episode) {
        this.episode = episode;
    }

    @XmlElement(name="displayseason")
    public String getDisplayseason() {
        return this.displayseason;
    }

    @XmlElement(name="displayepisode")
    public String getDisplayepisode() {
        return this.displayepisode;
    }

    public void setDisplayseason(String displayseason) {
        this.displayseason = displayseason;
    }

    public void setDisplayepisode(String displayepisode) {
        this.displayepisode = displayepisode;
    }

    @XmlElement(name="mpaa")
    public String getMpaa() {
        return this.mpaa;
    }

    public void setMpaa(String mpaa) {
        this.mpaa = mpaa;
    }

    public void setShowtitle(String showtitle) {
        this.showtitle = showtitle;
    }

    @XmlElement(name="rating")
    public float getRating() {
        return this.rating;
    }

    @XmlElement(name="votes")
    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    @XmlElement(name="aired")
    public String getAired() {
        return this.aired;
    }

    public void setAired(String aired) {
        this.aired = aired;
    }

    @XmlElement(name="premiered")
    public String getPremiered() {
        return this.premiered;
    }

    public void setPremiered(String premiered) {
        this.premiered = premiered;
    }

    @XmlElement(name="plot")
    public String getPlot() {
        return this.plot;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public void setPlot(String plot) {
        this.plot = plot;
    }

    public void addActor(String name, String role, String thumb) {
        Actor actor = new Actor(name, role, thumb);
        this.actors.add(actor);
    }

    public List<Actor> getActors() {
        ArrayList<Actor> pureActors = new ArrayList<Actor>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Actor)) continue;
            Actor actor = (Actor)obj;
            pureActors.add(actor);
        }
        return pureActors;
    }

    public List<String> getDirector() {
        return this.director;
    }

    public void addDirector(String director) {
        this.director.add(director);
    }

    public List<String> getCredits() {
        return this.credits;
    }

    public void addCredits(String credits) {
        this.credits.add(credits);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    private static List<TvShowEpisodeToXbmcNfoConnector> parseNfo(File nfoFile) {
        ArrayList<TvShowEpisodeToXbmcNfoConnector> xbmcConnectors = new ArrayList<TvShowEpisodeToXbmcNfoConnector>(1);
        if (nfoFile.exists()) {
            try {
                String completeNFO = FileUtils.readFileToString((File)nfoFile, (String)"UTF-8");
                Pattern pattern = Pattern.compile("<\\?xml.*\\?>");
                Matcher matcher = pattern.matcher(completeNFO);
                String xmlHeader = "";
                if (matcher.find()) {
                    xmlHeader = matcher.group();
                }
                pattern = Pattern.compile("<episodedetails>.+?<\\/episodedetails>", 32);
                matcher = pattern.matcher(completeNFO);
                while (matcher.find()) {
                    StringBuilder sb = new StringBuilder(xmlHeader);
                    sb.append(matcher.group());
                    try {
                        TvShowEpisodeToXbmcNfoConnector xbmc = TvShowEpisodeToXbmcNfoConnector.parseNfoPart(sb.toString());
                        xbmcConnectors.add(xbmc);
                    }
                    catch (Exception e) {
                        LOGGER.error("failed to parse " + nfoFile.getAbsolutePath(), (Throwable)e);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return xbmcConnectors;
    }

    private static TvShowEpisodeToXbmcNfoConnector parseNfoPart(String part) throws Exception {
        Unmarshaller um = context.createUnmarshaller();
        if (um == null) {
            throw new Exception("could not create unmarshaller");
        }
        try {
            StringReader in = new StringReader(part);
            return (TvShowEpisodeToXbmcNfoConnector)um.unmarshal((Reader)in);
        }
        catch (UnmarshalException e) {
            LOGGER.error("tried to unmarshal; now trying to clean xml stream");
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("tried to unmarshal; now trying to clean xml stream");
        }
        StringReader in = new StringReader(ParserUtils.cleanNfo(part));
        return (TvShowEpisodeToXbmcNfoConnector)um.unmarshal((Reader)in);
    }

    static class Subtitle {
        @XmlElement
        private String language;

        Subtitle() {
        }
    }

    static class Audio {
        @XmlElement
        private String codec;
        @XmlElement
        private String language;
        @XmlElement
        private String channels;

        Audio() {
        }
    }

    static class Video {
        @XmlElement
        private String codec;
        @XmlElement
        private String aspect;
        @XmlElement
        private int width;
        @XmlElement
        private int height;
        @XmlElement
        private int durationinseconds;
        @XmlElement
        private String stereomode;

        Video() {
        }
    }

    static class Streamdetails {
        @XmlElement
        private Video video = new Video();
        @XmlElement
        private List<Audio> audio = new ArrayList<Audio>();
        @XmlElement
        private List<Subtitle> subtitle = new ArrayList<Subtitle>();
    }

    static class Fileinfo {
        @XmlElement
        Streamdetails streamdetails = new Streamdetails();
    }

    @XmlRootElement(name="actor")
    public static class Actor {
        private String name;
        private String role;
        private String thumb;

        public Actor() {
        }

        public Actor(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }

        @XmlElement(name="name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement(name="role")
        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @XmlElement(name="thumb")
        public String getThumb() {
            return this.thumb;
        }

        public void setThumb(String thumb) {
            this.thumb = thumb;
        }
    }
}

