/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;

public class TvShowList
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowList.class);
    private static TvShowList instance = null;
    private final List<TvShow> tvShowList = ObservableCollections.observableList(Collections.synchronizedList(new ArrayList()));
    private final List<String> tvShowTagsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
    private final List<String> episodeTagsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
    private final List<String> videoCodecsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
    private final List<String> audioCodecsObservable = ObservableCollections.observableList(new CopyOnWriteArrayList());
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TvShowEpisode episode;
            if ("tag".equals(evt.getPropertyName()) && evt.getSource() instanceof TvShow) {
                TvShow tvShow = (TvShow)evt.getSource();
                TvShowList.this.updateTvShowTags(tvShow);
            }
            if ("tag".equals(evt.getPropertyName()) && evt.getSource() instanceof TvShowEpisode) {
                episode = (TvShowEpisode)evt.getSource();
                TvShowList.this.updateEpisodeTags(episode);
            }
            if (("mediaFiles".equals(evt.getPropertyName()) || "mediaInformation".equals(evt.getPropertyName())) && evt.getSource() instanceof TvShowEpisode) {
                episode = (TvShowEpisode)evt.getSource();
                TvShowList.this.updateMediaInformationLists(episode);
            }
            if ("episodeCount".equals(evt.getPropertyName())) {
                TvShowList.this.firePropertyChange("episodeCount", 0, 1);
            }
        }
    };

    private TvShowList() {
    }

    public static TvShowList getInstance() {
        if (instance == null) {
            instance = new TvShowList();
        }
        return instance;
    }

    public List<TvShow> getTvShows() {
        return this.tvShowList;
    }

    public List<TvShow> getUnscrapedTvShows() {
        ArrayList<TvShow> unscrapedShows = new ArrayList<TvShow>();
        for (TvShow show : this.tvShowList) {
            if (show.isScraped()) continue;
            unscrapedShows.add(show);
        }
        return unscrapedShows;
    }

    public void addTvShow(TvShow newValue) {
        int oldValue = this.tvShowList.size();
        this.tvShowList.add(newValue);
        newValue.addPropertyChangeListener(this.propertyChangeListener);
        this.firePropertyChange("tvShows", null, this.tvShowList);
        this.firePropertyChange("addedTvShow", null, newValue);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShowList.size());
    }

    public void removeDatasource(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return;
        }
        for (int i = this.tvShowList.size() - 1; i >= 0; --i) {
            TvShow tvShow = this.tvShowList.get(i);
            if (!new File(path).equals(new File(tvShow.getDataSource()))) continue;
            this.removeTvShow(tvShow);
        }
    }

    public void removeTvShow(TvShow tvShow) {
        int oldValue = this.tvShowList.size();
        tvShow.removeAllEpisodes();
        this.tvShowList.remove(tvShow);
        try {
            TvShowModuleManager.getInstance().removeTvShowFromDb(tvShow);
        }
        catch (Exception e) {
            LOGGER.error("problem removing TV show from DB: " + e.getMessage());
        }
        this.firePropertyChange("tvShows", null, this.tvShowList);
        this.firePropertyChange("removedTvShow", null, tvShow);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShowList.size());
    }

    public void deleteTvShow(TvShow tvShow) {
        int oldValue = this.tvShowList.size();
        tvShow.deleteFilesSafely();
        tvShow.removeAllEpisodes();
        this.tvShowList.remove(tvShow);
        try {
            TvShowModuleManager.getInstance().removeTvShowFromDb(tvShow);
        }
        catch (Exception e) {
            LOGGER.error("problem removing TV show from DB: " + e.getMessage());
        }
        this.firePropertyChange("tvShows", null, this.tvShowList);
        this.firePropertyChange("removedTvShow", null, tvShow);
        this.firePropertyChange("tvShowCount", oldValue, this.tvShowList.size());
    }

    public int getTvShowCount() {
        return this.tvShowList.size();
    }

    public int getEpisodeCount() {
        int count = 0;
        for (int i = 0; i < this.tvShowList.size(); ++i) {
            TvShow tvShow = this.tvShowList.get(i);
            count += tvShow.getEpisodeCount();
        }
        return count;
    }

    public TvShow lookupTvShow(UUID uuid) {
        for (TvShow tvShow : this.tvShowList) {
            if (!tvShow.getDbId().equals(uuid)) continue;
            return tvShow;
        }
        return null;
    }

    void loadTvShowsFromDatabase(MVMap<UUID, String> tvShowMap, ObjectMapper objectMapper) {
        ObjectReader tvShowObjectReader = objectMapper.readerFor(TvShow.class);
        for (UUID uuid : new ArrayList(tvShowMap.keyList())) {
            try {
                TvShow tvShow = (TvShow)tvShowObjectReader.readValue((String)tvShowMap.get((Object)uuid));
                tvShow.setDbId(uuid);
                this.tvShowList.add(tvShow);
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding TV show json string: " + e.getMessage());
                LOGGER.info("dropping corrupt TV show");
                tvShowMap.remove((Object)uuid);
            }
        }
        LOGGER.info("found " + this.tvShowList.size() + " TV shows in database");
    }

    void loadEpisodesFromDatabase(MVMap<UUID, String> episodesMap, ObjectMapper objectMapper) {
        ObjectReader episodeObjectReader = objectMapper.readerFor(TvShowEpisode.class);
        int episodeCount = 0;
        for (UUID uuid : new ArrayList(episodesMap.keyList())) {
            try {
                ++episodeCount;
                TvShowEpisode episode = (TvShowEpisode)episodeObjectReader.readValue((String)episodesMap.get((Object)uuid));
                episode.setDbId(uuid);
                for (TvShow tvShow : this.tvShowList) {
                    if (!tvShow.getDbId().equals(episode.getTvShowDbId())) continue;
                    episode.setTvShow(tvShow);
                    tvShow.addEpisode(episode);
                }
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding episode json string: " + e.getMessage());
                LOGGER.info("dropping corrupt episode");
                episodesMap.remove((Object)uuid);
            }
        }
        LOGGER.info("found " + episodeCount + " episodes in database");
    }

    void initDataAfterLoading() {
        this.checkAndCleanupMediaFiles();
        for (TvShow tvShow : this.tvShowList) {
            tvShow.initializeAfterLoading();
            this.updateTvShowTags(tvShow);
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.initializeAfterLoading();
                this.updateEpisodeTags(episode);
                this.updateMediaInformationLists(episode);
            }
            tvShow.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void persistTvShow(TvShow tvShow) {
        try {
            TvShowModuleManager.getInstance().persistTvShow(tvShow);
        }
        catch (Exception e) {
            LOGGER.error("failed to persist episode: " + tvShow.getTitle() + "; " + e.getMessage());
        }
    }

    public void removeTvShowFromDb(TvShow tvShow) {
        try {
            TvShowModuleManager.getInstance().removeTvShowFromDb(tvShow);
        }
        catch (Exception e) {
            LOGGER.error("failed to remove episode: " + tvShow.getTitle() + "; " + e.getMessage());
        }
    }

    public void persistEpisode(TvShowEpisode episode) {
        try {
            TvShowModuleManager.getInstance().persistEpisode(episode);
        }
        catch (Exception e) {
            LOGGER.error("failed to persist episode: " + episode.getTvShow().getTitle() + " - S" + episode.getSeason() + "E" + episode.getEpisode() + " - " + episode.getTitle() + "; " + e.getMessage());
        }
    }

    public void removeEpisodeFromDb(TvShowEpisode episode) {
        try {
            TvShowModuleManager.getInstance().removeEpisodeFromDb(episode);
        }
        catch (Exception e) {
            LOGGER.error("failed to remove episode: " + episode.getTvShow().getTitle() + " - S" + episode.getSeason() + "E" + episode.getEpisode() + " - " + episode.getTitle() + "; " + e.getMessage());
        }
    }

    public MediaScraper getDefaultMediaScraper() {
        MediaScraper scraper = MediaScraper.getMediaScraperById(TvShowModuleManager.SETTINGS.getTvShowScraper(), ScraperType.TV_SHOW);
        if (scraper == null) {
            scraper = MediaScraper.getMediaScraperById("tvdb", ScraperType.TV_SHOW);
        }
        return scraper;
    }

    public MediaScraper getMediaScraperById(String providerId) {
        return MediaScraper.getMediaScraperById(providerId, ScraperType.TV_SHOW);
    }

    public List<MediaScraper> getAvailableMediaScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TV_SHOW);
        Collections.sort(availableScrapers, new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getAvailableArtworkScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.TV_SHOW_ARTWORK);
        Collections.sort(availableScrapers, new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getArtworkScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper artworkScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (artworkScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.TV_SHOW_ARTWORK)) == null) continue;
            artworkScrapers.add(artworkScraper);
        }
        return artworkScrapers;
    }

    public List<MediaScraper> getDefaultArtworkScrapers() {
        return this.getArtworkScrapers(TvShowModuleManager.SETTINGS.getTvShowArtworkScrapers());
    }

    public List<MediaSearchResult> searchTvShow(String searchTerm, MediaScraper mediaScraper) {
        return this.searchTvShow(searchTerm, mediaScraper, TvShowModuleManager.SETTINGS.getScraperLanguage());
    }

    public List<MediaSearchResult> searchTvShow(String searchTerm, MediaScraper mediaScraper, MediaLanguages language) {
        List searchResult = null;
        try {
            ITvShowMetadataProvider provider = mediaScraper == null ? (ITvShowMetadataProvider)this.getDefaultMediaScraper().getMediaProvider() : (ITvShowMetadataProvider)mediaScraper.getMediaProvider();
            MediaSearchOptions options = new MediaSearchOptions(MediaType.TV_SHOW, searchTerm);
            options.setLanguage(LocaleUtils.toLocale((String)language.name()));
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            LOGGER.info("=====================================================");
            LOGGER.info("Searching with scraper: " + provider.getProviderInfo().getId() + ", " + provider.getProviderInfo().getVersion());
            LOGGER.info(options.toString());
            LOGGER.info("=====================================================");
            searchResult = provider.search(options);
        }
        catch (Exception e) {
            LOGGER.error("searchTvShow", (Throwable)e);
        }
        return searchResult;
    }

    private void updateTvShowTags(TvShow tvShow) {
        ArrayList<String> availableTags = new ArrayList<String>(this.tvShowTagsObservable);
        for (String tagInTvShow : new ArrayList<String>(tvShow.getTags())) {
            boolean tagFound = false;
            for (String tag : availableTags) {
                if (!tagInTvShow.equals(tag)) continue;
                tagFound = true;
                break;
            }
            if (tagFound) continue;
            this.addTvShowTag(tagInTvShow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTvShowTag(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        List<String> list = this.tvShowTagsObservable;
        synchronized (list) {
            if (this.tvShowTagsObservable.contains(newTag)) {
                return;
            }
            this.tvShowTagsObservable.add(newTag);
        }
        this.firePropertyChange("tag", null, this.tvShowTagsObservable);
    }

    public List<String> getTagsInTvShows() {
        return this.tvShowTagsObservable;
    }

    private void updateEpisodeTags(TvShowEpisode episode) {
        ArrayList<String> availableTags = new ArrayList<String>(this.episodeTagsObservable);
        for (String tagEpisode : new ArrayList<String>(episode.getTags())) {
            boolean tagFound = false;
            for (String tag : availableTags) {
                if (!tagEpisode.equals(tag)) continue;
                tagFound = true;
                break;
            }
            if (tagFound) continue;
            this.addEpisodeTag(tagEpisode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEpisodeTag(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        List<String> list = this.episodeTagsObservable;
        synchronized (list) {
            if (this.episodeTagsObservable.contains(newTag)) {
                return;
            }
            this.episodeTagsObservable.add(newTag);
        }
        this.firePropertyChange("tag", null, this.episodeTagsObservable);
    }

    public List<String> getTagsInEpisodes() {
        return this.episodeTagsObservable;
    }

    private void updateMediaInformationLists(TvShowEpisode episode) {
        ArrayList<String> availableCodecs = new ArrayList<String>(this.videoCodecsObservable);
        for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO)) {
            String codec = mf.getVideoCodec();
            boolean codecFound = false;
            for (String mfCodec : availableCodecs) {
                if (!mfCodec.equals(codec)) continue;
                codecFound = true;
                break;
            }
            if (codecFound) continue;
            this.addVideoCodec(codec);
        }
        availableCodecs = new ArrayList<String>(this.audioCodecsObservable);
        for (MediaFile mf : episode.getMediaFiles(MediaFileType.VIDEO)) {
            for (MediaFileAudioStream audio : mf.getAudioStreams()) {
                String codec = audio.getCodec();
                boolean codecFound = false;
                for (String mfCodec : availableCodecs) {
                    if (!mfCodec.equals(codec)) continue;
                    codecFound = true;
                    break;
                }
                if (codecFound) continue;
                this.addAudioCodec(codec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVideoCodec(String newCodec) {
        if (StringUtils.isBlank((CharSequence)newCodec)) {
            return;
        }
        List<String> list = this.videoCodecsObservable;
        synchronized (list) {
            if (this.videoCodecsObservable.contains(newCodec)) {
                return;
            }
            this.videoCodecsObservable.add(newCodec);
        }
        this.firePropertyChange("videoCodec", null, this.videoCodecsObservable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAudioCodec(String newCodec) {
        if (StringUtils.isBlank((CharSequence)newCodec)) {
            return;
        }
        List<String> list = this.audioCodecsObservable;
        synchronized (list) {
            if (this.audioCodecsObservable.contains(newCodec)) {
                return;
            }
            this.audioCodecsObservable.add(newCodec);
        }
        this.firePropertyChange("audioCodec", null, this.audioCodecsObservable);
    }

    public List<String> getVideoCodecsInEpisodes() {
        return this.videoCodecsObservable;
    }

    public List<String> getAudioCodecsInEpisodes() {
        return this.audioCodecsObservable;
    }

    @Deprecated
    public TvShow getTvShowByPath(File path) {
        return this.getTvShowByPath(path.toPath());
    }

    public TvShow getTvShowByPath(Path path) {
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(this.tvShowList);
        for (TvShow tvShow : tvShows) {
            if (tvShow.getPathNIO().compareTo(path.toAbsolutePath()) != 0) continue;
            return tvShow;
        }
        return null;
    }

    public List<TvShowEpisode> getTvEpisodesByFile(TvShow tvShow, File file) {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(1);
        if (file == null) {
            return episodes;
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            for (MediaFile mediaFile : new ArrayList<MediaFile>(episode.getMediaFiles())) {
                if (!file.equals(mediaFile.getFile())) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public void invalidateTitleSortable() {
        for (TvShow tvShow : new ArrayList<TvShow>(this.tvShowList)) {
            tvShow.clearTitleSortable();
        }
    }

    public List<TvShow> getNewTvShows() {
        ArrayList<TvShow> newShows = new ArrayList<TvShow>();
        for (TvShow show : this.tvShowList) {
            if (!show.isNewlyAdded()) continue;
            newShows.add(show);
        }
        return newShows;
    }

    public List<TvShowEpisode> getNewEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShowList) {
            for (TvShowEpisode ep : show.getEpisodes()) {
                if (!ep.isNewlyAdded()) continue;
                newEp.add(ep);
            }
        }
        return newEp;
    }

    public List<TvShowEpisode> getUnscrapedEpisodes() {
        ArrayList<TvShowEpisode> newEp = new ArrayList<TvShowEpisode>();
        for (TvShow show : this.tvShowList) {
            for (TvShowEpisode ep : show.getEpisodes()) {
                if (ep.isScraped()) continue;
                newEp.add(ep);
            }
        }
        return newEp;
    }

    private void checkAndCleanupMediaFiles() {
        boolean problemsDetected = false;
        for (TvShow tvShow : this.tvShowList) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (!mfs.isEmpty()) continue;
                tvShow.removeEpisode(episode);
                problemsDetected = true;
            }
        }
        if (problemsDetected) {
            LOGGER.warn("episodes without VIDEOs detected");
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    Message message = new Message(Message.MessageLevel.SEVERE, "tmm.tvshows", "message.database.corrupteddata");
                    MessageManager.instance.pushMessage(message);
                }
            });
            thread.start();
        }
    }

    public List<MediaScraper> getAvailableSubtitleScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.SUBTITLE);
        Collections.sort(availableScrapers, new TvShowMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultSubtitleScrapers() {
        return this.getSubtitleScrapers(MovieModuleManager.MOVIE_SETTINGS.getMovieSubtitleScrapers());
    }

    public List<MediaScraper> getSubtitleScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> subtitleScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper subtitleScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (subtitleScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.SUBTITLE)) == null) continue;
            subtitleScrapers.add(subtitleScraper);
        }
        return subtitleScrapers;
    }

    private class TvShowMediaScraperComparator
    implements Comparator<MediaScraper> {
        private TvShowMediaScraperComparator() {
        }

        @Override
        public int compare(MediaScraper o1, MediaScraper o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

