/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.info;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class InfoNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String name;
    private String value;
    private Collection<InfoNode> childrenNodes;

    public InfoNode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public InfoNode(String identifier, String name, String value) {
        this.name = name;
        this.identifier = identifier;
        this.value = value;
    }

    public InfoNode(String name, Collection<InfoNode> childrenNodes) {
        this.name = name;
        if (childrenNodes == null) {
            childrenNodes = new ArrayList<InfoNode>();
        }
        this.childrenNodes = childrenNodes;
    }

    public InfoNode(String identifier, String name, Collection<InfoNode> childrenNodes) {
        this.name = name;
        this.identifier = identifier;
        if (childrenNodes == null) {
            childrenNodes = new ArrayList<InfoNode>();
        }
        this.childrenNodes = childrenNodes;
    }

    public boolean isLeaf() {
        return this.childrenNodes == null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Collection<InfoNode> getChildren() {
        if (this.childrenNodes == null) {
            return new ArrayList<InfoNode>();
        }
        return Collections.unmodifiableCollection(this.childrenNodes);
    }
}

