/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.util.Pair;
import org.tinymediamanager.scraper.util.UrlUtil;

public class Url {
    private static final Logger LOGGER = LoggerFactory.getLogger(Url.class);
    protected static OkHttpClient client;
    protected static final String USER_AGENT = "User-Agent";
    protected int responseCode = 0;
    protected String responseMessage = "";
    protected Charset responseCharset = null;
    protected String responseContentType = "";
    protected long responseContentLength = -1L;
    protected String url = null;
    protected Headers headersResponse = null;
    protected List<Pair<String, String>> headersRequest = new ArrayList<Pair<String, String>>();
    protected URI uri = null;
    protected Call call = null;
    protected Request request = null;
    protected Response response = null;

    public String getHeader(String header) {
        if (this.headersResponse == null) {
            return "";
        }
        String h = this.headersResponse.get(header);
        if (StringUtils.isBlank((CharSequence)h)) {
            return "";
        }
        return h;
    }

    public Headers getHeadersResponse() {
        return this.headersResponse;
    }

    public Url(String url) throws MalformedURLException {
        if (client == null) {
            client = TmmHttpClient.getHttpClient();
        }
        this.url = url;
        try {
            this.uri = this.morphStringToUri(url);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(url);
        }
        this.addHeader(USER_AGENT, UrlUtil.generateUA());
    }

    protected Url() {
    }

    protected URI morphStringToUri(String urlToMorph) throws MalformedURLException, URISyntaxException {
        URL url = new URL(urlToMorph);
        return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
    }

    public void setUserAgent(String userAgent) {
        this.addHeader(USER_AGENT, userAgent);
    }

    public URL getUrl() throws IOException, InterruptedException {
        return new URL(this.url);
    }

    public void addHeader(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        LOGGER.trace("add HTTP header: " + key + "=" + value);
        for (int i = this.headersRequest.size() - 1; i >= 0; --i) {
            Pair<String, String> header = this.headersRequest.get(i);
            if (!key.equals(header.first())) continue;
            this.headersRequest.remove(i);
        }
        this.headersRequest.add(new Pair<String, String>(key, value));
    }

    public void addHeader(Pair<String, String> header) {
        this.headersRequest.add(header);
    }

    public void addHeaders(List<Pair<String, String>> headers) {
        this.headersRequest.addAll(headers);
    }

    public InputStream getInputStream() throws IOException, InterruptedException {
        if (this.url.startsWith("file:")) {
            String newUrl = this.url.replace("file:/", "");
            File file = new File(newUrl);
            return new FileInputStream(file);
        }
        InputStream is = null;
        String logUrl = this.url.replaceAll("api_key=\\w+", "api_key=<API_KEY>").replaceAll("api/\\d+\\w+", "api/<API_KEY>");
        LOGGER.debug("getting " + logUrl);
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(this.url);
        for (Pair<String, String> header : this.headersRequest) {
            requestBuilder.addHeader(header.first().toString(), header.second().toString());
        }
        this.request = requestBuilder.build();
        try {
            this.call = client.newCall(this.request);
            this.response = this.call.execute();
            this.headersResponse = this.response.headers();
            this.responseCode = this.response.code();
            this.responseMessage = this.response.message();
            if (this.responseCode < 200 || this.responseCode >= 400) {
                this.cleanup();
                LOGGER.error("bad http response: " + this.responseCode + " ; " + this.responseMessage);
                return null;
            }
            if (this.response.body().contentType() != null) {
                this.responseCharset = this.response.body().contentType().charset();
                this.responseContentType = this.response.body().contentType().toString();
            }
            is = this.response.body().byteStream();
        }
        catch (InterruptedIOException | IllegalStateException e) {
            LOGGER.info("aborted request: " + logUrl + " ; " + e.getMessage());
            this.cleanup();
            throw new InterruptedException();
        }
        catch (UnknownHostException e) {
            LOGGER.error("proxy or host not found/reachable; " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Exception getting url " + logUrl + " ; " + e.getMessage(), (Throwable)e);
        }
        return is;
    }

    protected void cleanup() {
        if (this.call != null) {
            this.call.cancel();
        }
        if (this.response != null) {
            this.response.close();
        }
    }

    public boolean isFault() {
        return this.responseCode >= 400;
    }

    public int getStatusCode() {
        return this.responseCode;
    }

    public String getStatusLine() {
        return this.responseMessage;
    }

    public byte[] getBytes() throws IOException, InterruptedException {
        InputStream is = this.getInputStream();
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        is.close();
        return bytes;
    }

    public boolean download(File file) {
        block4: {
            try {
                InputStream is = this.getInputStream();
                if (is == null) {
                    return false;
                }
                ReadableByteChannel rbc = Channels.newChannel(is);
                FileOutputStream fos = new FileOutputStream(file);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
                return true;
            }
            catch (IOException e) {
                LOGGER.error("Error downloading " + this.url);
            }
            catch (InterruptedException ignored) {
                if (this.call == null) break block4;
                this.call.cancel();
            }
        }
        return false;
    }

    public boolean download(Path file) {
        return this.download(file.toFile());
    }

    public Charset getCharset() {
        if (this.responseCharset == null) {
            return Charset.defaultCharset();
        }
        return this.responseCharset;
    }

    public String getContentEncoding() {
        return this.responseContentType;
    }

    public long getContentLength() {
        return this.responseContentLength;
    }

    public String toString() {
        return this.url;
    }
}

