/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.common.parameters;

import java.util.Map;
import org.apache.oltu.oauth2.common.message.OAuthMessage;
import org.apache.oltu.oauth2.common.parameters.OAuthParametersApplier;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;

public class QueryParameterApplier
implements OAuthParametersApplier {
    @Override
    public OAuthMessage applyOAuthParameters(OAuthMessage message, Map<String, Object> params) {
        String messageUrl = message.getLocationUri();
        if (messageUrl != null) {
            boolean containsQuestionMark = messageUrl.contains("?");
            StringBuffer url = new StringBuffer(messageUrl);
            StringBuffer query = new StringBuffer(OAuthUtils.format(params.entrySet(), "UTF-8"));
            if (!OAuthUtils.isEmpty(query.toString())) {
                if (containsQuestionMark) {
                    url.append("&").append(query);
                } else {
                    url.append("?").append(query);
                }
            }
            message.setLocationUri(url.toString());
        }
        return message;
    }
}

