/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieCrewPanel
extends JPanel {
    private static final long serialVersionUID = 2972207353452870494L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSelectionModel selectionModel;
    private EventList<MovieProducer> producerEventList = null;
    private DefaultEventTableModel<MovieProducer> ProducerTableModel = null;
    private JLabel lblDirectorT;
    private JLabel lblWriterT;
    private JLabel lblProducer;
    private JTable tableProducer;
    private JLabel lblDirector;
    private JLabel lblWriter;

    public MovieCrewPanel(MovieSelectionModel model) {
        this.selectionModel = model;
        this.producerEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieProducer.class)));
        this.ProducerTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.producerEventList), (TableFormat)new ProducerTableFormat());
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"80px"), RowSpec.decode((String)"default:grow"), FormFactory.NARROW_LINE_GAP_ROWSPEC}));
        this.lblDirectorT = new JLabel(BUNDLE.getString("metatag.director"));
        this.add((Component)this.lblDirectorT, "2, 2");
        this.lblDirector = new JLabel("");
        this.add((Component)this.lblDirector, "4, 2");
        this.lblWriterT = new JLabel(BUNDLE.getString("metatag.writer"));
        this.add((Component)this.lblWriterT, "2, 4");
        this.lblWriter = new JLabel("");
        this.add((Component)this.lblWriter, "4, 4");
        this.lblProducer = new JLabel(BUNDLE.getString("metatag.producers"));
        this.add((Component)this.lblProducer, "2, 6, default, top");
        this.tableProducer = new ZebraJTable((TableModel)this.ProducerTableModel);
        this.tableProducer.setTableHeader(null);
        JScrollPane scrollPaneMovieCast = ZebraJTable.createStripedJScrollPane(this.tableProducer);
        this.lblProducer.setLabelFor(scrollPaneMovieCast);
        this.add((Component)scrollPaneMovieCast, "4, 6, 1, 2");
        scrollPaneMovieCast.setViewportView(this.tableProducer);
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == MovieSelectionModel.class && "selectedMovie".equals(property) || source.getClass() == Movie.class && "producers".equals(property)) {
                    MovieCrewPanel.this.producerEventList.clear();
                    MovieCrewPanel.this.producerEventList.addAll(MovieCrewPanel.this.selectionModel.getSelectedMovie().getProducers());
                    if (MovieCrewPanel.this.producerEventList.size() > 0) {
                        MovieCrewPanel.this.tableProducer.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.director");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblDirector, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovie.writer");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.lblWriter, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }

    private static class ProducerTableFormat
    implements AdvancedTableFormat<MovieProducer> {
        private ProducerTableFormat() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return "";
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MovieProducer producer, int column) {
            switch (column) {
                case 0: {
                    return producer.getName();
                }
                case 1: {
                    return producer.getRole();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int column) {
            return null;
        }
    }
}

