/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieTrailerProvider;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.dialogs.MovieChooserDialog;

public class MovieScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieScrapeTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToScrape;
    private boolean doSearch;
    private MovieSearchAndScrapeOptions options;
    private List<Movie> smartScrapeList;

    public MovieScrapeTask(List<Movie> moviesToScrape, boolean doSearch, MovieSearchAndScrapeOptions options) {
        super(BUNDLE.getString("movie.scraping"));
        this.moviesToScrape = moviesToScrape;
        this.doSearch = doSearch;
        this.options = options;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(3, "scrape");
        this.start();
        this.smartScrapeList = new ArrayList<Movie>(0);
        for (int i = 0; i < this.moviesToScrape.size(); ++i) {
            Movie movie = this.moviesToScrape.get(i);
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        if (!this.smartScrapeList.isEmpty() && !GraphicsEnvironment.isHeadless()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Movie movie;
                        MovieChooserDialog dialogMovieChooser;
                        Iterator i$ = MovieScrapeTask.this.smartScrapeList.iterator();
                        while (i$.hasNext() && (dialogMovieChooser = new MovieChooserDialog(movie = (Movie)i$.next(), MovieScrapeTask.this.smartScrapeList.size() > 1)).showDialog()) {
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("SmartScrape crashed " + e.getMessage());
            }
        }
        if (MovieModuleManager.MOVIE_SETTINGS.getSyncTrakt()) {
            SyncTraktTvTask task = new SyncTraktTvTask(this.moviesToScrape, null);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        LOGGER.info("Done scraping movies)");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private MovieList movieList;
        private Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                try {
                    this.movieList = MovieList.getInstance();
                    MovieScraperMetadataConfig scraperMetadataConfig = MovieScrapeTask.this.options.getScraperMetadataConfig();
                    MediaScraper mediaMetadataScraper = MovieScrapeTask.this.options.getMetadataScraper();
                    List<MediaScraper> artworkScrapers = MovieScrapeTask.this.options.getArtworkScrapers();
                    List<MediaScraper> trailerScrapers = MovieScrapeTask.this.options.getTrailerScrapers();
                    MediaSearchResult result1 = null;
                    if (MovieScrapeTask.this.doSearch && (result1 = this.searchForMovie(mediaMetadataScraper)) == null) {
                        List list = MovieScrapeTask.this.smartScrapeList;
                        synchronized (list) {
                            MovieScrapeTask.this.smartScrapeList.add(this.movie);
                            return;
                        }
                    }
                    if ((!MovieScrapeTask.this.doSearch || result1 == null) && MovieScrapeTask.this.doSearch) break block15;
                    try {
                        MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
                        options.setResult(result1);
                        options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                        options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
                        options.setFanartSize(MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize());
                        options.setPosterSize(MovieModuleManager.MOVIE_SETTINGS.getImagePosterSize());
                        if (!MovieScrapeTask.this.doSearch) {
                            for (Map.Entry<String, Object> entry : this.movie.getIds().entrySet()) {
                                options.setId(entry.getKey(), entry.getValue().toString());
                            }
                        } else {
                            mediaMetadataScraper = this.movieList.getMediaScraperById(result1.getProviderId());
                        }
                        MediaMetadata md = null;
                        if (mediaMetadataScraper != null && mediaMetadataScraper.getMediaProvider() != null) {
                            LOGGER.info("=====================================================");
                            LOGGER.info("Scraper metadata with scraper: " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getId() + ", " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getVersion());
                            LOGGER.info(options.toString());
                            LOGGER.info("=====================================================");
                            md = ((IMovieMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                            if (scraperMetadataConfig.isMetadata()) {
                                this.movie.setMetadata(md, scraperMetadataConfig);
                            }
                            if (scraperMetadataConfig.isArtwork()) {
                                this.movie.setArtwork(this.getArtwork(this.movie, md, artworkScrapers), scraperMetadataConfig);
                            }
                            if (scraperMetadataConfig.isTrailer()) {
                                this.movie.setTrailers(this.getTrailers(this.movie, md, trailerScrapers));
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("movie.setMetadata", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "message.scrape.metadatamoviefailed"));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Thread crashed", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieScraper", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }

        private MediaSearchResult searchForMovie(MediaScraper mediaMetadataProvider) {
            List<MediaSearchResult> results = this.movieList.searchMovie(this.movie.getTitle(), this.movie, mediaMetadataProvider);
            MediaSearchResult result = null;
            if (results != null && !results.isEmpty()) {
                result = results.get(0);
                if (results.size() > 1) {
                    MediaSearchResult result2 = results.get(1);
                    if (result.getScore() == 1.0f && result2.getScore() == 1.0f) {
                        LOGGER.info("two 100% results, can't decide whitch to take - ignore result");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.toosimilar"));
                        return null;
                    }
                }
                double scraperTreshold = MovieModuleManager.MOVIE_SETTINGS.getScraperThreshold();
                LOGGER.info("using treshold from settings of {}", (Object)scraperTreshold);
                if ((double)result.getScore() < scraperTreshold) {
                    LOGGER.info("score is lower than " + scraperTreshold + " (" + result.getScore() + ") - ignore result");
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "movie.scrape.toolowscore", new String[]{String.format("%.2f", scraperTreshold)}));
                    return null;
                }
            } else {
                LOGGER.info("no result found for " + this.movie.getTitle());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.nomatchfound"));
            }
            return result;
        }

        private List<MediaArtwork> getArtwork(Movie movie, MediaMetadata metadata, List<MediaScraper> artworkScrapers) {
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(metadata);
            options.setImdbId(movie.getImdbId());
            options.setTmdbId(movie.getTmdbId());
            options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
            options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
            options.setFanartSize(MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize());
            options.setPosterSize(MovieModuleManager.MOVIE_SETTINGS.getImagePosterSize());
            for (MediaScraper scraper : artworkScrapers) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (Exception e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, movie, "message.scrape.movieartworkfailed"));
                }
            }
            return artwork;
        }

        private List<MovieTrailer> getTrailers(Movie movie, MediaMetadata metadata, List<MediaScraper> trailerScrapers) {
            ArrayList<MovieTrailer> trailers = new ArrayList<MovieTrailer>();
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.TRAILER)) {
                LOGGER.debug("adding local trailer " + mf.getFilename());
                MovieTrailer mt = new MovieTrailer();
                mt.setName(mf.getFilename());
                mt.setProvider("downloaded");
                mt.setQuality(mf.getVideoFormat());
                mt.setInNfo(false);
                mt.setUrl(mf.getFile().toURI().toString());
                trailers.add(mt);
            }
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setMetadata(metadata);
            options.setImdbId(movie.getImdbId());
            options.setTmdbId(movie.getTmdbId());
            options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
            options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
            for (MediaScraper trailerScraper : trailerScrapers) {
                try {
                    IMovieTrailerProvider trailerProvider = (IMovieTrailerProvider)trailerScraper.getMediaProvider();
                    List foundTrailers = trailerProvider.getTrailers(options);
                    for (MediaTrailer mediaTrailer : foundTrailers) {
                        MovieTrailer movieTrailer = new MovieTrailer(mediaTrailer);
                        trailers.add(movieTrailer);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("getTrailers", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, movie, "message.scrape.movietrailerfailed"));
                }
            }
            return trailers;
        }
    }
}

