/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.util.ParserUtils;

@XmlRootElement(name="movie")
@XmlSeeAlso(value={Actor.class, Producer.class})
@XmlType(propOrder={"title", "originaltitle", "set", "sorttitle", "rating", "epbookmark", "year", "top250", "votes", "outline", "plot", "tagline", "runtime", "thumb", "fanart", "mpaa", "certification", "id", "ids", "tmdbId", "trailer", "country", "premiered", "status", "code", "aired", "fileinfo", "watched", "playcount", "genres", "studio", "credits", "director", "tags", "actors", "producers", "resume", "lastplayed", "dateadded", "keywords", "poster", "url", "languages", "source", "edition", "unsupportedElements"})
public class MovieToXbmcNfoConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieToXbmcNfoConnector.class);
    private static final Pattern PATTERN_NFO_MOVIE_TAG = Pattern.compile("<movie.*?>");
    private static JAXBContext context = MovieToXbmcNfoConnector.initContext();
    public String title = "";
    public String originaltitle = "";
    public String set = "";
    public String sorttitle = "";
    public float rating = 0.0f;
    public String year = "";
    public String top250 = "";
    public int votes = 0;
    public String outline = "";
    public String plot = "";
    public String tagline = "";
    public String runtime = "";
    public String thumb = "";
    public String fanart = "";
    public String mpaa = "";
    public String certification = "";
    public String id = "";
    @XmlElementWrapper(name="ids")
    private Map<String, Object> ids;
    public int tmdbId = 0;
    public String trailer = "";
    public String country = "";
    public String premiered = "";
    public Fileinfo fileinfo;
    public boolean watched = false;
    public int playcount = 0;
    @XmlElement(name="genre")
    public List<String> genres;
    public List<String> studio;
    public List<String> credits;
    public List<String> director;
    @XmlElement(name="tag")
    private List<String> tags;
    @XmlAnyElement(lax=true)
    private List<Object> actors = new ArrayList<Object>();
    @XmlAnyElement(lax=true)
    private List<Object> producers;
    public String languages;
    public String source;
    public String edition;
    @XmlAnyElement(lax=true)
    private List<Object> unsupportedElements;
    public String epbookmark;
    public String lastplayed;
    public String status;
    public String code;
    public String aired;
    public Object resume;
    public String dateadded;
    public Object keywords;
    public Object poster;
    public Object url;

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{MovieToXbmcNfoConnector.class, Actor.class});
        }
        catch (JAXBException e) {
            LOGGER.error("Error instantiating JaxB", (Throwable)e);
            return null;
        }
    }

    public MovieToXbmcNfoConnector() {
        this.genres = new ArrayList<String>();
        this.tags = new ArrayList<String>();
        this.director = new ArrayList<String>();
        this.credits = new ArrayList<String>();
        this.producers = new ArrayList<Object>();
        this.ids = new HashMap<String, Object>();
        this.unsupportedElements = new ArrayList<Object>();
        this.fileinfo = new Fileinfo();
    }

    public static void setData(Movie movie) {
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.nfo.writeerror", new String[]{":", "Context is null"}));
            return;
        }
        MovieToXbmcNfoConnector xbmc = MovieToXbmcNfoConnector.createInstanceFromMovie(movie);
        ArrayList<MovieNfoNaming> nfonames = new ArrayList<MovieNfoNaming>();
        if (movie.isMultiMovieDir()) {
            nfonames.add(MovieNfoNaming.FILENAME_NFO);
        } else {
            nfonames = MovieModuleManager.MOVIE_SETTINGS.getMovieNfoFilenames();
        }
        MovieToXbmcNfoConnector.writeNfoFiles(movie, xbmc, nfonames);
    }

    static MovieToXbmcNfoConnector createInstanceFromMovie(Movie movie) {
        Subtitle sub;
        MediaFile mediaFile2;
        MovieToXbmcNfoConnector xbmc = null;
        ArrayList<Object> unsupportedTags = new ArrayList<Object>();
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.NFO)) {
            Path file = mf.getFileAsPath();
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    xbmc = MovieToXbmcNfoConnector.parseNFO(file);
                }
                catch (Exception e) {
                    LOGGER.error("failed to parse " + mf.getFilename(), (Throwable)e);
                }
            }
            if (xbmc == null) continue;
            break;
        }
        if (xbmc == null) {
            xbmc = new MovieToXbmcNfoConnector();
        } else {
            for (Object obj : xbmc.actors) {
                if (obj instanceof Producer || obj instanceof Actor) continue;
                unsupportedTags.add(obj);
            }
        }
        xbmc.title = movie.getTitle();
        xbmc.originaltitle = movie.getOriginalTitle();
        xbmc.rating = movie.getRating();
        xbmc.votes = movie.getVotes();
        xbmc.top250 = movie.getTop250() == 0 ? "" : String.valueOf(movie.getTop250());
        xbmc.year = movie.getYear();
        xbmc.premiered = movie.getReleaseDateFormatted();
        xbmc.plot = movie.getPlot();
        if (StringUtils.isNotBlank((CharSequence)xbmc.plot) && xbmc.plot.length() > 200) {
            int spaceIndex = xbmc.plot.indexOf(" ", 200);
            xbmc.outline = spaceIndex > 0 ? xbmc.plot.substring(0, spaceIndex) + "..." : xbmc.plot;
        } else if (StringUtils.isNotBlank((CharSequence)xbmc.plot)) {
            xbmc.outline = xbmc.plot;
        }
        xbmc.tagline = movie.getTagline();
        xbmc.runtime = String.valueOf(movie.getRuntime());
        String artworkUrl = movie.getArtworkUrl(MediaFileType.POSTER);
        xbmc.thumb = artworkUrl.matches("https?://.*") ? artworkUrl : "";
        artworkUrl = movie.getArtworkUrl(MediaFileType.FANART);
        xbmc.fanart = artworkUrl.matches("https?://.*") ? artworkUrl : "";
        xbmc.id = movie.getImdbId();
        if (movie.getTmdbId() != 0) {
            xbmc.tmdbId = movie.getTmdbId();
        }
        xbmc.ids.putAll(movie.getIds());
        if (StringUtils.isNotEmpty((CharSequence)movie.getProductionCompany())) {
            xbmc.studio = Arrays.asList(movie.getProductionCompany().split("\\s*[,\\/]\\s*"));
        }
        xbmc.country = movie.getCountry();
        xbmc.watched = movie.isWatched();
        xbmc.playcount = xbmc.watched ? 1 : 0;
        xbmc.languages = movie.getSpokenLanguages();
        if (movie.getCertification() != null) {
            xbmc.certification = CertificationStyle.formatCertification(movie.getCertification(), MovieModuleManager.MOVIE_SETTINGS.getMovieCertificationStyle());
            xbmc.mpaa = MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry() == CountryCode.US ? Certification.getMPAAString((Certification)movie.getCertification()) : CertificationStyle.formatCertification(movie.getCertification(), MovieModuleManager.MOVIE_SETTINGS.getMovieCertificationStyle());
        }
        xbmc.director.clear();
        if (StringUtils.isNotEmpty((CharSequence)movie.getDirector())) {
            String[] directors;
            for (String director : directors = movie.getDirector().split(", ")) {
                xbmc.director.add(director);
            }
        }
        xbmc.credits.clear();
        if (StringUtils.isNotEmpty((CharSequence)movie.getWriter())) {
            String[] writers;
            for (String writer : writers = movie.getWriter().split(", ")) {
                xbmc.credits.add(writer);
            }
        }
        xbmc.actors.clear();
        for (MovieActor cast : new ArrayList<MovieActor>(movie.getActors())) {
            xbmc.addActor(cast.getName(), cast.getCharacter(), cast.getThumbUrl());
        }
        xbmc.producers.clear();
        for (MovieProducer producer : new ArrayList<MovieProducer>(movie.getProducers())) {
            xbmc.addProducer(producer.getName(), producer.getRole(), producer.getThumbUrl());
        }
        xbmc.genres.clear();
        for (MediaGenres genre : new ArrayList<MediaGenres>(movie.getGenres())) {
            xbmc.genres.add(genre.toString());
        }
        xbmc.trailer = "";
        for (MovieTrailer trailer : new ArrayList<MovieTrailer>(movie.getTrailer())) {
            if (!trailer.getInNfo().booleanValue() || trailer.getUrl().startsWith("file")) continue;
            xbmc.trailer = MovieToXbmcNfoConnector.prepareTrailerForXbmc(trailer);
            break;
        }
        if (xbmc.trailer.isEmpty()) {
            xbmc.trailer = null;
        }
        xbmc.tags.clear();
        Iterator<Object> i$ = new ArrayList<String>(movie.getTags()).iterator();
        while (i$.hasNext()) {
            String tag = (String)i$.next();
            xbmc.tags.add(tag);
        }
        if (movie.getMovieSet() != null) {
            MovieSet movieSet = movie.getMovieSet();
            xbmc.set = movieSet.getTitle();
        } else {
            xbmc.set = "";
        }
        xbmc.sorttitle = movie.getSortTitle();
        if (movie.getMediaSource() != MediaSource.UNKNOWN) {
            xbmc.source = movie.getMediaSource().name();
        }
        if (movie.getEdition() != MovieEdition.NONE) {
            xbmc.edition = movie.getEdition().getTitle();
        }
        if ((i$ = movie.getMediaFiles(MediaFileType.VIDEO).iterator()).hasNext() && !StringUtils.isEmpty((CharSequence)(mediaFile2 = (MediaFile)i$.next()).getVideoCodec())) {
            xbmc.fileinfo.streamdetails.video.codec = mediaFile2.getVideoCodec();
            xbmc.fileinfo.streamdetails.video.aspect = String.valueOf(mediaFile2.getAspectRatio());
            xbmc.fileinfo.streamdetails.video.width = mediaFile2.getVideoWidth();
            xbmc.fileinfo.streamdetails.video.height = mediaFile2.getVideoHeight();
            xbmc.fileinfo.streamdetails.video.durationinseconds = movie.getRuntimeFromMediaFiles();
            if (mediaFile2.getVideo3DFormat().equals("3D SBS") || mediaFile2.getVideo3DFormat().equals("3D HSBS")) {
                xbmc.fileinfo.streamdetails.video.stereomode = "left_right";
            } else if (mediaFile2.getVideo3DFormat().equals("3D TAB") || mediaFile2.getVideo3DFormat().equals("3D HTAB")) {
                xbmc.fileinfo.streamdetails.video.stereomode = "top_bottom";
            }
            xbmc.fileinfo.streamdetails.audio.clear();
            for (MediaFileAudioStream as : mediaFile2.getAudioStreams()) {
                Audio audio = new Audio();
                audio.codec = StringUtils.isNotBlank((CharSequence)as.getCodec()) ? as.getCodec().replaceAll("-", "_") : as.getCodec();
                audio.language = as.getLanguage();
                audio.channels = String.valueOf(as.getChannelsAsInt());
                xbmc.fileinfo.streamdetails.audio.add(audio);
            }
            xbmc.fileinfo.streamdetails.subtitle.clear();
            for (MediaFileSubtitle ss : mediaFile2.getSubtitles()) {
                sub = new Subtitle();
                sub.language = ss.getLanguage();
                xbmc.fileinfo.streamdetails.subtitle.add(sub);
            }
        }
        for (MediaFile mediaFile2 : movie.getMediaFiles(MediaFileType.SUBTITLE)) {
            for (MediaFileSubtitle ss : mediaFile2.getSubtitles()) {
                sub = new Subtitle();
                sub.language = ss.getLanguage();
                xbmc.fileinfo.streamdetails.subtitle.add(sub);
            }
        }
        xbmc.unsupportedElements.addAll(unsupportedTags);
        return xbmc;
    }

    static void writeNfoFiles(Movie movie, MovieToXbmcNfoConnector xbmc, List<MovieNfoNaming> nfoNames) {
        String nfoFilename = "";
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (MovieNfoNaming name : nfoNames) {
            try {
                nfoFilename = movie.getNfoFilename(name);
                if (nfoFilename.isEmpty()) continue;
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.encoding", (Object)"UTF-8");
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                String comment = "<!-- created on " + dat + " - tinyMediaManager " + Globals.settings.getVersion() + " -->\n";
                m.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)comment);
                StringWriter w = new StringWriter();
                m.marshal((Object)xbmc, (Writer)w);
                StringBuilder sb = new StringBuilder(((Object)w).toString());
                ((Writer)w).close();
                if (SystemUtils.IS_OS_WINDOWS) {
                    sb = new StringBuilder(sb.toString().replaceAll("(?<!\r)\n", "\r\n"));
                }
                Path f = movie.getPathNIO().resolve(nfoFilename);
                Utils.writeStringToFile(f, sb.toString());
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("setData " + movie.getPathNIO().resolve(nfoFilename), (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (newNfos.size() > 0) {
            movie.removeAllMediaFiles(MediaFileType.NFO);
            movie.addToMediaFiles(newNfos);
        }
    }

    public static Movie getData(Path nfoFile) {
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, nfoFile, "message.nfo.readerror"));
            return null;
        }
        Movie movie = null;
        try {
            String urlFromNfo;
            Person cast;
            MovieList movieList;
            MovieSet movieSet;
            MovieToXbmcNfoConnector xbmc = MovieToXbmcNfoConnector.parseNFO(nfoFile);
            movie = new Movie();
            movie.setTitle(xbmc.title);
            movie.setOriginalTitle(xbmc.originaltitle);
            movie.setRating(xbmc.rating);
            movie.setVotes(xbmc.votes);
            movie.setYear(xbmc.year);
            if (StringUtils.isNotBlank((CharSequence)xbmc.top250)) {
                try {
                    movie.setTop250(Integer.parseInt(xbmc.top250));
                }
                catch (NumberFormatException e) {
                    movie.setTop250(0);
                }
            } else {
                movie.setTop250(0);
            }
            movie.setReleaseDate(xbmc.premiered);
            movie.setPlot(xbmc.plot);
            movie.setTagline(xbmc.tagline);
            try {
                String rt = xbmc.runtime.replaceAll("[^0-9]", "");
                movie.setRuntime(Integer.parseInt(rt));
            }
            catch (Exception e) {
                LOGGER.warn("could not parse runtime: " + xbmc.runtime + "; Movie: " + movie.getPathNIO());
            }
            if (StringUtils.isNotBlank((CharSequence)xbmc.thumb) && xbmc.thumb.matches("https?://.*")) {
                movie.setArtworkUrl(xbmc.thumb, MediaFileType.POSTER);
            }
            if (StringUtils.isNotBlank((CharSequence)xbmc.fanart) && xbmc.fanart.matches("https?://.*")) {
                movie.setArtworkUrl(xbmc.fanart, MediaFileType.FANART);
            }
            for (Map.Entry<String, Object> entry : xbmc.ids.entrySet()) {
                try {
                    if ("imdbId".equals(entry.getKey())) {
                        movie.setId("imdb", entry.getValue());
                        continue;
                    }
                    if ("tmdbId".equals(entry.getKey())) {
                        movie.setId("tmdb", entry.getValue());
                        continue;
                    }
                    movie.setId(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    LOGGER.warn("could not set ID: " + entry.getKey() + " ; " + entry.getValue());
                }
            }
            if (StringUtils.isBlank((CharSequence)movie.getImdbId())) {
                movie.setImdbId(xbmc.id);
            }
            if (movie.getTmdbId() == 0 && xbmc.tmdbId != 0) {
                movie.setTmdbId(xbmc.tmdbId);
            }
            String director = "";
            for (String dir : xbmc.director) {
                if (!StringUtils.isEmpty((CharSequence)director)) {
                    director = director + ", ";
                }
                director = director + dir;
            }
            movie.setDirector(director);
            String writer = "";
            for (String wri : xbmc.credits) {
                if (StringUtils.isNotEmpty((CharSequence)writer)) {
                    writer = writer + ", ";
                }
                writer = writer + wri;
            }
            movie.setWriter(writer);
            String studio = StringUtils.join(xbmc.studio, (String)" / ");
            if (studio == null) {
                movie.setProductionCompany("");
            } else {
                movie.setProductionCompany(studio);
            }
            movie.setProductionCompany(movie.getProductionCompany().replaceAll("\\s*,\\s*", " / "));
            movie.setCountry(xbmc.country);
            if (!StringUtils.isEmpty((CharSequence)xbmc.certification)) {
                movie.setCertification(MovieHelpers.parseCertificationStringForMovieSetupCountry(xbmc.certification));
            }
            if (!StringUtils.isEmpty((CharSequence)xbmc.mpaa) && movie.getCertification() == Certification.NOT_RATED) {
                movie.setCertification(MovieHelpers.parseCertificationStringForMovieSetupCountry(xbmc.mpaa));
            }
            movie.setWatched(xbmc.watched);
            if (xbmc.playcount > 0) {
                movie.setWatched(true);
            }
            movie.setSpokenLanguages(xbmc.languages);
            if (StringUtils.isNotBlank((CharSequence)xbmc.source)) {
                try {
                    MediaSource source = MediaSource.valueOf(xbmc.source);
                    if (source != null) {
                        movie.setMediaSource(source);
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)xbmc.edition)) {
                MovieEdition edition = MovieEdition.getMovieEditionFromString(xbmc.edition);
                movie.setEdition(edition);
            }
            if (StringUtils.isNotEmpty((CharSequence)xbmc.set) && (movieSet = (movieList = MovieList.getInstance()).getMovieSet(xbmc.set, 0)) != null) {
                movie.setMovieSet(movieSet);
            }
            movie.setSortTitle(xbmc.sorttitle);
            for (Actor actor : xbmc.getActors()) {
                cast = new MovieActor(actor.name, actor.role);
                cast.setThumbUrl(actor.thumb);
                movie.addActor((MovieActor)cast);
            }
            for (Producer producer : xbmc.getProducers()) {
                cast = new MovieProducer(producer.name, producer.role);
                cast.setThumbUrl(producer.thumb);
                movie.addProducer((MovieProducer)cast);
            }
            for (String genre : xbmc.genres) {
                String[] genres;
                for (String g : genres = genre.split("/")) {
                    MediaGenres genreFound = MediaGenres.getGenre((String)g.trim());
                    if (genreFound == null) continue;
                    movie.addGenre(genreFound);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)xbmc.trailer) && !(urlFromNfo = MovieToXbmcNfoConnector.parseTrailerUrl(xbmc.trailer)).startsWith("file")) {
                MovieTrailer trailer = new MovieTrailer();
                trailer.setName("fromNFO");
                trailer.setProvider("from NFO");
                trailer.setQuality("unknown");
                trailer.setUrl(urlFromNfo);
                trailer.setInNfo(true);
                movie.addTrailer(trailer);
            }
            for (String tag : xbmc.tags) {
                movie.addToTags(tag);
            }
        }
        catch (UnmarshalException e) {
            LOGGER.error("getData " + nfoFile, (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("getData " + nfoFile, (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)movie.getTitle())) {
            return null;
        }
        return movie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MovieToXbmcNfoConnector parseNFO(Path nfoFile) throws Exception {
        Unmarshaller um = context.createUnmarshaller();
        if (um == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, nfoFile, "message.nfo.readerror"));
            throw new Exception("could not create unmarshaller");
        }
        MovieToXbmcNfoConnector xbmc = null;
        try (Reader in = null;){
            in = new InputStreamReader((InputStream)new FileInputStream(nfoFile.toFile()), "UTF-8");
            xbmc = (MovieToXbmcNfoConnector)um.unmarshal(in);
        }
        if (xbmc == null) {
            String completeNFO = Utils.readFileToString(nfoFile).trim().replaceFirst("^([\\W]+)<", "<");
            Matcher matcher = PATTERN_NFO_MOVIE_TAG.matcher(completeNFO);
            if (matcher.find()) {
                completeNFO = matcher.replaceFirst("<movie xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            }
            try {
                in = new StringReader(ParserUtils.cleanNfo(completeNFO));
                xbmc = (MovieToXbmcNfoConnector)um.unmarshal(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return xbmc;
    }

    private void addActor(String name, String role, String thumb) {
        Actor actor = new Actor(name, role, thumb);
        this.actors.add(actor);
    }

    public List<Actor> getActors() {
        ArrayList<Actor> pureActors = new ArrayList<Actor>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Actor)) continue;
            Actor actor = (Actor)obj;
            pureActors.add(actor);
        }
        return pureActors;
    }

    private void addProducer(String name, String role, String thumb) {
        Producer producer = new Producer(name, role, thumb);
        this.producers.add(producer);
    }

    public List<Producer> getProducers() {
        ArrayList<Producer> pureProducers = new ArrayList<Producer>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Producer)) continue;
            Producer producer = (Producer)obj;
            pureProducers.add(producer);
        }
        return pureProducers;
    }

    private static String prepareTrailerForXbmc(MovieTrailer trailer) {
        Pattern pattern = Pattern.compile("https{0,1}://.*youtube..*/watch\\?v=(.*)$");
        Matcher matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            return "plugin://plugin.video.youtube/?action=play_video&videoid=" + matcher.group(1);
        }
        pattern = Pattern.compile("https{0,1}://.*(apple.com|yahoo-redir|yahoo.com|youtube.com|moviefone.com|ign.com|hd-trailers.net|aol.com).*");
        matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            try {
                return "plugin://plugin.video.hdtrailers_net/video/" + matcher.group(1) + "/" + URLEncoder.encode(trailer.getUrl(), "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error("failed to escape " + trailer.getUrl());
            }
        }
        return trailer.getUrl();
    }

    private static String parseTrailerUrl(String nfoTrailerUrl) {
        Pattern pattern = Pattern.compile("plugin://plugin.video.youtube/\\?action=play_video&videoid=(.*)$");
        Matcher matcher = pattern.matcher(nfoTrailerUrl);
        if (matcher.matches()) {
            return "http://www.youtube.com/watch?v=" + matcher.group(1);
        }
        pattern = Pattern.compile("plugin://plugin.video.hdtrailers_net/video/.*\\?/(.*)$");
        matcher = pattern.matcher(nfoTrailerUrl);
        if (matcher.matches()) {
            try {
                return URLDecoder.decode(matcher.group(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("failed to unescape " + nfoTrailerUrl);
            }
        }
        return nfoTrailerUrl;
    }

    static class Subtitle {
        public String language;

        Subtitle() {
        }
    }

    static class Audio {
        public String codec;
        public String language;
        public String channels;

        Audio() {
        }
    }

    static class Video {
        public String codec;
        public String aspect;
        public int width;
        public int height;
        public int durationinseconds;
        public String stereomode;

        Video() {
        }
    }

    static class Streamdetails {
        public Video video = new Video();
        public List<Audio> audio = new ArrayList<Audio>();
        public List<Subtitle> subtitle = new ArrayList<Subtitle>();
    }

    static class Fileinfo {
        public Streamdetails streamdetails = new Streamdetails();
    }

    @XmlRootElement(name="producer")
    public static class Producer {
        public String name;
        public String role;
        public String thumb;

        public Producer() {
        }

        public Producer(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }
    }

    @XmlRootElement(name="actor")
    public static class Actor {
        public String name;
        public String role;
        public String thumb;

        public Actor() {
        }

        public Actor(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }
    }
}

