/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;

public class UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTasks.class);

    public static void performUpgradeTasksBeforeDatabaseLoading(String oldVersion) {
        String v = "" + oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "2.6.9";
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.7") < 0) {
            LOGGER.info("Performing upgrade tasks to version 2.7");
            UpgradeTasks.moveToConfigFolder(Paths.get("movies.db", new String[0]));
            UpgradeTasks.moveToConfigFolder(Paths.get("tvshows.db", new String[0]));
            UpgradeTasks.moveToConfigFolder(Paths.get("scraper_imdb.conf", new String[0]));
            UpgradeTasks.moveToConfigFolder(Paths.get("tmm_ui.prop", new String[0]));
            UpgradeTasks.cleanupNativeFolder();
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.7.2") < 0) {
            File[] subdirs;
            LOGGER.info("Performing upgrade tasks to version 2.7.2");
            if (Platform.isLinux() && (subdirs = new File("native").listFiles()) != null) {
                for (File subdir : subdirs) {
                    if (!subdir.isDirectory() || !subdir.getName().startsWith("linux")) continue;
                    FileUtils.deleteQuietly((File)subdir);
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.9.3") < 0) {
            LOGGER.info("Performing upgrade tasks to version 2.9.3");
            Path uiProp = Paths.get(Settings.getInstance().getSettingsFolder(), "tmm_ui.prop");
            if (Files.exists(uiProp, new LinkOption[0])) {
                try {
                    FileUtils.moveFile((File)uiProp.toFile(), (File)new File(Settings.getInstance().getSettingsFolder(), "tmm.prop"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void moveToConfigFolder(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            Path fnew = Paths.get(Settings.getInstance().getSettingsFolder(), file.getFileName().toString());
            try {
                Utils.moveFileSafe(file, fnew);
            }
            catch (IOException e) {
                LOGGER.warn("error moving " + file);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void performUpgradeTasksAfterDatabaseLoading(String oldVersion) {
        MovieList movieList = MovieList.getInstance();
        TvShowList tvShowList = TvShowList.getInstance();
        String v = "" + oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "2.6.9";
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.7") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.7");
            FileUtils.deleteQuietly((File)new File("tmm.odb"));
            FileUtils.deleteQuietly((File)new File("tmm.odb$"));
            FileUtils.deleteQuietly((File)new File("objectdb.conf"));
            FileUtils.deleteQuietly((File)new File("log"));
            Globals.settings.removeSubtitleFileType(".idx");
            if (ReleaseInfo.isReleaseBuild()) {
                MovieModuleManager.MOVIE_SETTINGS.setImageBanner(true);
                MovieModuleManager.MOVIE_SETTINGS.setImageLogo(true);
                MovieModuleManager.MOVIE_SETTINGS.setImageClearart(true);
                MovieModuleManager.MOVIE_SETTINGS.setImageDiscart(true);
                MovieModuleManager.MOVIE_SETTINGS.setImageThumb(true);
                MovieModuleManager.MOVIE_SETTINGS.setUseTrailerPreference(true);
                Globals.settings.writeDefaultSettings();
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.7.2") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.7.2");
            for (Movie movie : movieList.getMovies()) {
                boolean dirty = false;
                for (MovieActor movieActor : movie.getActors()) {
                    if (!StringUtils.isNotBlank((CharSequence)movieActor.getThumbPath()) || !movieActor.updateThumbRoot(movie.getPath())) continue;
                    dirty = true;
                }
                if (!dirty) continue;
                movie.saveToDb();
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.7.3") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.7.3");
            for (MovieSet movieSet : movieList.getMovieSetList()) {
                MovieSetArtworkHelper.updateArtwork(movieSet);
                movieSet.saveToDb();
            }
            for (Movie movie : movieList.getMovies()) {
                movie.setNewlyAdded(false);
                movie.saveToDb();
            }
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    tvShowEpisode.setNewlyAdded(false);
                    tvShowEpisode.saveToDb();
                }
                tvShow.saveToDb();
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.8") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.8");
            if (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector() == MovieConnectors.MP) {
                MovieModuleManager.MOVIE_SETTINGS.setMovieCertificationStyle(CertificationStyle.TECHNICAL);
            }
            for (Movie movie : movieList.getMovies()) {
                movie.reEvaluateStacking();
                boolean isOffline = false;
                for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
                    if (!"disc".equalsIgnoreCase(mediaFile.getExtension())) continue;
                    isOffline = true;
                }
                movie.setOffline(isOffline);
                movie.saveToDb();
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.8.2") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.8.2");
            Date initialDate = new Date(0L);
            for (Movie movie : movieList.getMovies()) {
                if (movie.getReleaseDate() == null || !DateUtils.isSameDay((Date)initialDate, (Date)movie.getReleaseDate())) continue;
                movie.setReleaseDate((Date)null);
                movie.saveToDb();
            }
            for (TvShow tvShow : tvShowList.getTvShows()) {
                if (tvShow.getFirstAired() != null && DateUtils.isSameDay((Date)initialDate, (Date)tvShow.getFirstAired())) {
                    tvShow.setFirstAired((Date)null);
                    tvShow.saveToDb();
                }
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    if (tvShowEpisode.getFirstAired() == null || !DateUtils.isSameDay((Date)initialDate, (Date)tvShowEpisode.getFirstAired())) continue;
                    tvShowEpisode.setFirstAired((Date)null);
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.8.3") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.8.3");
            for (Movie movie : movieList.getMovies()) {
                boolean changed = false;
                for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
                    if (!mediaFile.getVideoResolution().isEmpty()) continue;
                    mediaFile.setContainerFormat("");
                    changed = true;
                }
                if (!changed) continue;
                movie.saveToDb();
            }
            for (TvShow tvShow : tvShowList.getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    boolean bl = false;
                    for (MediaFile mf : tvShowEpisode.getMediaFiles(MediaFileType.VIDEO)) {
                        if (!mf.getVideoResolution().isEmpty()) continue;
                        mf.setContainerFormat("");
                        bl = true;
                    }
                    if (tvShowEpisode.isDisc()) {
                        Path path = tvShowEpisode.getPathNIO().toAbsolutePath();
                        String folder = tvShow.getPathNIO().relativize(path).toString().toUpperCase(Locale.ROOT);
                        while (folder.contains("BDMV") || folder.contains("VIDEO_TS")) {
                            void var9_88;
                            Path path2 = var9_88.getParent();
                            folder = tvShow.getPathNIO().relativize(path2).toString().toUpperCase(Locale.ROOT);
                            tvShowEpisode.setPath(path2.toAbsolutePath().toString());
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.9") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.9");
            for (Movie movie : movieList.getMovies()) {
                boolean changed = false;
                for (MovieActor movieActor : movie.getActors()) {
                    if (!movieActor.getEntityRoot().isEmpty()) continue;
                    movieActor.setEntityRoot(movie.getPathNIO().toString());
                    movieActor.setThumbPath("");
                    changed = true;
                }
                for (MovieProducer movieProducer : movie.getProducers()) {
                    if (!movieProducer.getEntityRoot().isEmpty()) continue;
                    movieProducer.setEntityRoot(movie.getPathNIO().toString());
                    movieProducer.setThumbPath("");
                    changed = true;
                }
                if (movie.getMovieSet() != null) {
                    movie.setSortTitle("");
                    changed = true;
                }
                if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                    MediaFile mediaFile = movie.getMediaFiles(MediaFileType.VIDEO).get(0);
                    MediaSource mediaSource = MediaSource.parseMediaSource(mediaFile.getPath());
                    if (movie.getMediaSource() != mediaSource) {
                        movie.setMediaSource(mediaSource);
                        changed = true;
                    }
                }
                if (!changed) continue;
                movie.saveToDb();
            }
            for (TvShow tvShow : tvShowList.getTvShows()) {
                boolean changed = false;
                for (TvShowActor tvShowActor : tvShow.getActors()) {
                    if (!tvShowActor.getEntityRoot().isEmpty()) continue;
                    tvShowActor.setEntityRoot(tvShow.getPathNIO().toString());
                    tvShowActor.setThumbUrl(tvShowActor.getThumb());
                    tvShowActor.setThumbPath("");
                    tvShowActor.setThumb("");
                    changed = true;
                }
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    for (TvShowActor a : tvShowEpisode.getActors()) {
                        if (!a.getEntityRoot().isEmpty()) continue;
                        a.setEntityRoot(tvShowEpisode.getPathNIO().toString());
                        a.setThumbUrl(a.getThumb());
                        a.setThumbPath("");
                        a.setThumb("");
                        changed = true;
                    }
                }
                if (!changed) continue;
                tvShow.saveToDb();
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.9.1") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.9.1");
            if (MovieModuleManager.MOVIE_SETTINGS.getMovieConnector() == MovieConnectors.XBMC) {
                MovieModuleManager.MOVIE_SETTINGS.setMovieConnector(MovieConnectors.KODI);
                Settings.getInstance().saveSettings();
            }
            for (Movie movie : movieList.getMovies()) {
                boolean changed = false;
                for (MediaFile mediaFile : movie.getMediaFiles()) {
                    for (MediaFileSubtitle sub : mediaFile.getSubtitles()) {
                        if (!"sme".equals(sub.getLanguage())) continue;
                        sub.setLanguage("swe");
                        changed = true;
                    }
                }
                if (!changed) continue;
                movie.saveToDb();
            }
            for (TvShow show : tvShowList.getTvShows()) {
                boolean changed = false;
                for (TvShowEpisode tvShowEpisode : show.getEpisodes()) {
                    for (MediaFile mf : tvShowEpisode.getMediaFiles()) {
                        for (MediaFileSubtitle sub : mf.getSubtitles()) {
                            if (!"sme".equals(sub.getLanguage())) continue;
                            sub.setLanguage("swe");
                            changed = true;
                        }
                    }
                    if (!changed) continue;
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.9.2") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.9.2");
            for (Movie movie : movieList.getMovies()) {
                boolean changed = UpgradeTasks.removeEmptyIds(movie);
                ArrayList<MediaFile> arrayList = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mediaFile : arrayList) {
                    if (!mediaFile.isGraphic() || !mediaFile.getFilename().startsWith("movieset-")) continue;
                    movie.removeFromMediaFiles(mediaFile);
                    changed = true;
                }
                if (!changed) continue;
                movie.saveToDb();
            }
            for (TvShow show : tvShowList.getTvShows()) {
                boolean changed = UpgradeTasks.removeEmptyIds(show);
                if (changed) {
                    show.saveToDb();
                }
                for (TvShowEpisode tvShowEpisode : show.getEpisodes()) {
                    changed = UpgradeTasks.removeEmptyIds(tvShowEpisode);
                    if (!changed) continue;
                    tvShowEpisode.saveToDb();
                }
            }
            if (Globals.settings.isDeleteTrashOnExit()) {
                for (String datasource : MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource()) {
                    Path ds = Paths.get(datasource, new String[0]);
                    if (!Files.exists(ds, new LinkOption[0])) continue;
                    try {
                        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(ds);
                        Throwable throwable = null;
                        try {
                            for (Path path : directoryStream) {
                                if (!Files.isDirectory(path, new LinkOption[0]) || !ds.relativize(path).toString().startsWith(".deletedByTMM")) continue;
                                Utils.deleteDirectoryRecursive(path);
                            }
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (directoryStream == null) continue;
                            if (throwable != null) {
                                try {
                                    directoryStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            directoryStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                for (String datasource : TvShowModuleManager.SETTINGS.getTvShowDataSource()) {
                    Path ds = Paths.get(datasource, new String[0]);
                    if (!Files.exists(ds, new LinkOption[0])) continue;
                    try {
                        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(ds);
                        Throwable throwable = null;
                        try {
                            for (Path path : directoryStream) {
                                if (!Files.isDirectory(path, new LinkOption[0]) || !ds.relativize(path).toString().startsWith(".deletedByTMM")) continue;
                                Utils.deleteDirectoryRecursive(path);
                            }
                        }
                        catch (Throwable throwable5) {
                            Throwable throwable6 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (directoryStream == null) continue;
                            if (throwable != null) {
                                try {
                                    directoryStream.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            directoryStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"2.9.3") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 2.9.3");
            for (Movie movie : movieList.getMovies()) {
                for (Person person : movie.getActors()) {
                    person.setEntityRoot(movie.getPathNIO());
                }
                for (Person person : movie.getProducers()) {
                    person.setEntityRoot(movie.getPathNIO());
                }
                movie.saveToDb();
            }
            for (MovieSet movieSet : movieList.getMovieSetList()) {
                movieSet.saveToDb();
            }
            for (TvShow show : tvShowList.getTvShows()) {
                for (Person person : show.getActors()) {
                    person.setEntityRoot(show.getPathNIO());
                }
                show.saveToDb();
                for (TvShowEpisode tvShowEpisode : show.getEpisodes()) {
                    for (Person person : tvShowEpisode.getGuests()) {
                        person.setEntityRoot(tvShowEpisode.getPathNIO());
                    }
                    tvShowEpisode.saveToDb();
                }
            }
        }
    }

    private static boolean removeEmptyIds(MediaEntity me) {
        boolean changed = false;
        HashMap<String, Object> ids = me.getIds();
        Iterator it = ids.entrySet().iterator();
        while (it.hasNext()) {
            Object i;
            Map.Entry pair = it.next();
            if (pair.getValue() instanceof Integer) {
                i = (Integer)pair.getValue();
                if (i != null && (Integer)i != 0) continue;
                LOGGER.debug("Removing empty ID: " + (String)pair.getKey() + " (" + me.getTitle() + ")");
                it.remove();
                changed = true;
                continue;
            }
            if (!(pair.getValue() instanceof String) || !StringUtils.isEmpty((CharSequence)(i = (String)pair.getValue()))) continue;
            LOGGER.debug("Removing empty ID: " + (String)pair.getKey() + " (" + me.getTitle() + ")");
            it.remove();
            changed = true;
        }
        return changed;
    }

    private static void cleanupNativeFolder() {
        if (ReleaseInfo.isGitBuild()) {
            return;
        }
        try {
            File[] nativeFiles = new File("native").listFiles();
            if (nativeFiles == null) {
                return;
            }
            for (File file : nativeFiles) {
                if (!file.isDirectory()) continue;
                if (Platform.isWindows() && !"windows-x86".equals(file.getName()) && !"windows-x64".equals(file.getName())) {
                    FileUtils.deleteQuietly((File)file);
                    continue;
                }
                if (Platform.isLinux() && !"linux-x86".equals(file.getName()) && !"linux-x64".equals(file.getName())) {
                    FileUtils.deleteQuietly((File)file);
                    continue;
                }
                if (!Platform.isMac() || "mac-x86".equals(file.getName()) || "mac-x64".equals(file.getName())) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to cleanup native folder: " + e.getMessage());
        }
    }

    public static void renameDownloadedFiles() {
        File cur;
        File file = new File("getdown-new.jar");
        if (file.exists() && file.length() > 100000L) {
            cur = new File("getdown.jar");
            if (file.length() != cur.length() || !cur.exists()) {
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update the updater!");
                }
            }
        }
        if (Platform.isWindows()) {
            file = new File("tinyMediaManager.new");
            if (file.exists() && file.length() > 10000L && file.length() < 50000L) {
                cur = new File("tinyMediaManager.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update tmm!");
                }
            }
            if ((file = new File("tinyMediaManagerUpd.new")).exists() && file.length() > 10000L && file.length() < 50000L) {
                cur = new File("tinyMediaManagerUpd.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update the updater!");
                }
            }
            if ((file = new File("tinyMediaManagerCMD.new")).exists() && file.length() > 10000L && file.length() < 50000L) {
                cur = new File("tinyMediaManagerCMD.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update CMD TMM!");
                }
            }
        }
        if (Platform.isMac() && (file = new File("JavaApplicationStub.new")).exists() && file.length() > 0L) {
            cur = new File("../../MacOS/JavaApplicationStub");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update JavaApplicationStub");
            }
        }
        if (Platform.isMac() && (file = new File("Info.plist")).exists() && file.length() > 0L) {
            cur = new File("../../Info.plist");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update JavaApplicationStub");
            }
        }
    }
}

