/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.seamless.http.Representation;
import org.seamless.util.io.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFetch {
    public static Representation<byte[]> fetchBinary(URL url) throws IOException {
        return HttpFetch.fetchBinary(url, 500, 500);
    }

    public static Representation<byte[]> fetchBinary(URL url, int connectTimeoutMillis, int readTimeoutMillis) throws IOException {
        return HttpFetch.fetch(url, connectTimeoutMillis, readTimeoutMillis, new RepresentationFactory<byte[]>(){

            @Override
            public Representation<byte[]> createRepresentation(URLConnection urlConnection, InputStream is) throws IOException {
                return new Representation<byte[]>(urlConnection, IO.readBytes((InputStream)is));
            }
        });
    }

    public static Representation<String> fetchString(URL url, int connectTimeoutMillis, int readTimeoutMillis) throws IOException {
        return HttpFetch.fetch(url, connectTimeoutMillis, readTimeoutMillis, new RepresentationFactory<String>(){

            @Override
            public Representation<String> createRepresentation(URLConnection urlConnection, InputStream is) throws IOException {
                return new Representation<String>(urlConnection, IO.readLines((InputStream)is));
            }
        });
    }

    public static <E> Representation<E> fetch(URL url, int connectTimeoutMillis, int readTimeoutMillis, RepresentationFactory<E> factory) throws IOException {
        return HttpFetch.fetch(url, "GET", connectTimeoutMillis, readTimeoutMillis, factory);
    }

    public static <E> Representation<E> fetch(URL url, String method, int connectTimeoutMillis, int readTimeoutMillis, RepresentationFactory<E> factory) throws IOException {
        HttpURLConnection urlConnection = null;
        InputStream is = null;
        try {
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(method);
            urlConnection.setConnectTimeout(connectTimeoutMillis);
            urlConnection.setReadTimeout(readTimeoutMillis);
            is = urlConnection.getInputStream();
            Representation<E> representation = factory.createRepresentation(urlConnection, is);
            return representation;
        }
        catch (IOException ex) {
            if (urlConnection != null) {
                int responseCode = urlConnection.getResponseCode();
                throw new IOException("Fetching resource failed, returned status code: " + responseCode);
            }
            throw ex;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static void validate(URL url) throws IOException {
        HttpFetch.fetch(url, "HEAD", 500, 500, new RepresentationFactory(){

            public Representation createRepresentation(URLConnection urlConnection, InputStream is) throws IOException {
                return new Representation<Object>(urlConnection, null);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RepresentationFactory<E> {
        public Representation<E> createRepresentation(URLConnection var1, InputStream var2) throws IOException;
    }
}

