/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.a.a.a;
import com.threerings.getdown.tools.JarDiffCodes;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarDiffPatcher
implements JarDiffCodes {
    protected static final int DEFAULT_READ_SIZE = 2048;
    protected static byte[] newBytes = new byte[2048];
    protected static byte[] oldBytes = new byte[2048];

    public void patchJar(String object, String hashMap, File stringArray, ProgressObserver progressObserver) throws IOException {
        object = new File((String)object);
        hashMap = new File((String)((Object)hashMap));
        JarOutputStream jarOutputStream = null;
        JarFile jarFile = null;
        JarFile jarFile2 = null;
        try {
            int n2;
            jarOutputStream = new JarOutputStream(new FileOutputStream((File)stringArray));
            jarFile = new JarFile((File)object);
            jarFile2 = new JarFile((File)((Object)hashMap));
            object = new HashSet<String>();
            hashMap = new HashMap<String, String>();
            this.determineNameMapping(jarFile2, (Set<String>)object, (Map<String, String>)hashMap);
            stringArray = hashMap.keySet().toArray(new String[hashMap.size()]);
            HashSet<String> hashSet = new HashSet<String>();
            Object object2 = jarFile.entries();
            if (object2 != null) {
                while (object2.hasMoreElements()) {
                    hashSet.add(object2.nextElement().getName());
                }
            }
            double d2 = hashSet.size() + stringArray.length + jarFile2.size();
            double d3 = 0.0;
            hashSet.removeAll((Collection<?>)object);
            d2 -= (double)object.size();
            object = jarFile2.entries();
            if (object != null) {
                while (object.hasMoreElements()) {
                    object2 = (JarEntry)object.nextElement();
                    if (!"META-INF/INDEX.JD".equals(((ZipEntry)object2).getName())) {
                        this.updateObserver(progressObserver, d3, d2);
                        d3 += 1.0;
                        this.writeEntry(jarOutputStream, (JarEntry)object2, jarFile2);
                        boolean bl = hashSet.remove(((ZipEntry)object2).getName());
                        n2 = bl ? 1 : 0;
                        if (!bl) continue;
                        d2 -= 1.0;
                        continue;
                    }
                    d2 -= 1.0;
                }
            }
            object2 = stringArray;
            n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object3 = object2[i2];
                String string = (String)hashMap.get(object3);
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry == null) {
                    object3 = "move" + string + " " + (String)object3;
                    throw new IOException("error.badmove: " + (String)object3);
                }
                object3 = new JarEntry((String)object3);
                ((ZipEntry)object3).setTime(jarEntry.getTime());
                ((ZipEntry)object3).setSize(jarEntry.getSize());
                ((ZipEntry)object3).setCompressedSize(jarEntry.getCompressedSize());
                ((ZipEntry)object3).setCrc(jarEntry.getCrc());
                ((ZipEntry)object3).setMethod(jarEntry.getMethod());
                ((ZipEntry)object3).setExtra(jarEntry.getExtra());
                ((ZipEntry)object3).setComment(jarEntry.getComment());
                this.updateObserver(progressObserver, d3, d2);
                d3 += 1.0;
                this.writeEntry(jarOutputStream, (JarEntry)object3, jarFile.getInputStream(jarEntry));
                boolean bl = hashSet.remove(string);
                if (!bl) continue;
                d2 -= 1.0;
            }
            object2 = hashSet.iterator();
            if (object2 != null) {
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    JarEntry jarEntry = jarFile.getJarEntry(string);
                    this.updateObserver(progressObserver, d3, d2);
                    d3 += 1.0;
                    this.writeEntry(jarOutputStream, jarEntry, jarFile);
                }
            }
            this.updateObserver(progressObserver, d3, d2);
        }
        catch (Throwable throwable) {
            a.a(jarOutputStream);
            JarDiffPatcher.closeFile(jarFile);
            JarDiffPatcher.closeFile(jarFile2);
            throw throwable;
        }
        a.a(jarOutputStream);
        JarDiffPatcher.closeFile(jarFile);
        JarDiffPatcher.closeFile(jarFile2);
    }

    protected void updateObserver(ProgressObserver progressObserver, double d2, double d3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(d2 * 100.0 / d3));
        }
    }

    protected void determineNameMapping(JarFile closeable, Set<String> set, Map<String, String> map) throws IOException {
        if ((closeable = ((JarFile)closeable).getInputStream(((JarFile)closeable).getEntry("META-INF/INDEX.JD"))) == null) {
            throw new IOException("error.noindex");
        }
        String string = ((LineNumberReader)(closeable = new LineNumberReader(new InputStreamReader((InputStream)closeable, "UTF-8")))).readLine();
        if (string == null || !string.equals("version 1.0")) {
            throw new IOException("jardiff.error.badheader: " + string);
        }
        while ((string = ((LineNumberReader)closeable).readLine()) != null) {
            List<String> list;
            if (string.startsWith("remove")) {
                list = this.getSubpaths(string.substring(6));
                if (list.size() != 1) {
                    throw new IOException("error.badremove: " + string);
                }
                set.add(list.get(0));
                continue;
            }
            if (string.startsWith("move")) {
                list = this.getSubpaths(string.substring(4));
                if (list.size() != 2) {
                    throw new IOException("error.badmove: " + string);
                }
                if (map.put(list.get(1), list.get(0)) == null) continue;
                throw new IOException("error.badmove: " + string);
            }
            if (string.length() <= 0) continue;
            throw new IOException("error.badcommand: " + string);
        }
    }

    protected List<String> getSubpaths(String string) {
        int n2 = 0;
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < n3) {
            while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n3) continue;
            int n4 = n2;
            String string2 = null;
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                if (c2 == '\\' && n2 + 1 < n3 && string.charAt(n2 + 1) == ' ') {
                    string2 = string2 == null ? string.substring(n4, n2) : string2 + string.substring(n4, n2);
                    n4 = ++n2;
                } else if (Character.isWhitespace(c2)) break;
                ++n2;
            }
            if (n4 != n2) {
                string2 = string2 == null ? string.substring(n4, n2) : string2 + string.substring(n4, n2);
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, JarFile jarFile) throws IOException {
        this.writeEntry(jarOutputStream, jarEntry, jarFile.getInputStream(jarEntry));
    }

    protected void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, InputStream inputStream) throws IOException {
        jarOutputStream.putNextEntry(new JarEntry(jarEntry.getName()));
        int n2 = inputStream.read(newBytes);
        while (n2 != -1) {
            jarOutputStream.write(newBytes, 0, n2);
            n2 = inputStream.read(newBytes);
        }
        inputStream.close();
    }

    private static void closeFile(JarFile object) {
        if (object != null) {
            try {
                ((ZipFile)object).close();
                return;
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace(System.err);
            }
        }
    }
}

