/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowChangeToDvdOrderAction
extends AbstractAction {
    private static final long serialVersionUID = 8457297935386064655L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowChangeToDvdOrderAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.changetodvdorder"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.changeorder.desc"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                for (TvShowEpisode ep : tvShow.getEpisodes()) {
                    selectedEpisodes.add(ep);
                }
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                for (TvShowEpisode ep : season.getEpisodes()) {
                    selectedEpisodes.add(ep);
                }
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            selectedEpisodes.add(tvShowEpisode);
        }
        for (TvShowEpisode episode : selectedEpisodes) {
            if (episode.isDvdOrder()) continue;
            episode.setDvdOrder(true);
            episode.setDvdSeason(episode.getAiredSeason());
            episode.setDvdEpisode(episode.getAiredEpisode());
            episode.setAiredEpisode(-1);
            episode.setAiredSeason(-1);
            episode.writeNFO();
            episode.saveToDb();
        }
    }
}

