/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaGenres;

public class TvShowExtendedMatcher {
    Map<SearchOptions, Object> searchOptions = Collections.synchronizedMap(new HashMap());

    public boolean matches(Object bean) {
        if (this.searchOptions.isEmpty()) {
            return true;
        }
        if (bean instanceof TvShow) {
            TvShow show = (TvShow)bean;
            return this.tvShowFilterMatch(show);
        }
        if (bean instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)bean;
            return this.tvShowSeasonFilterMatch(season);
        }
        if (bean instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)bean;
            return this.tvShowEpisodeFilterMatch(episode);
        }
        return true;
    }

    private boolean tvShowFilterMatch(TvShow tvShow) {
        if (this.searchOptions.containsKey((Object)SearchOptions.TEXT) && !this.filterText(tvShow, (String)this.searchOptions.get((Object)SearchOptions.TEXT))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.DATASOURCE) && this.searchOptions.get((Object)SearchOptions.DATASOURCE) instanceof List && !this.filterDatasource(tvShow, (List)this.searchOptions.get((Object)SearchOptions.DATASOURCE))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MEDIA_SOURCE) && !this.filterMediaSource(tvShow, (MediaSource)((Object)this.searchOptions.get((Object)SearchOptions.MEDIA_SOURCE)))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.CAST) && !this.filterCrew(tvShow, (String)this.searchOptions.get((Object)SearchOptions.CAST))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_METADATA) && !this.filterMissingMetadata(tvShow)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_ARTWORK) && !this.filterMissingArtwork(tvShow)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_SUBTITLES) && !this.filterMissingSubtitles(tvShow)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.NEW_EPISODES) && !this.filterNewEpisodes(tvShow)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.WATCHED) && !this.filterWatched(tvShow, (Boolean)this.searchOptions.get((Object)SearchOptions.WATCHED))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.GENRE) && !this.filterGenre(tvShow, (MediaGenres)this.searchOptions.get((Object)SearchOptions.GENRE))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.TAG) && this.searchOptions.get((Object)SearchOptions.TAG) instanceof List && !this.filterTag(tvShow, (List)this.searchOptions.get((Object)SearchOptions.TAG))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.VIDEO_CODEC) && !this.filterVideoCodec(tvShow, (String)this.searchOptions.get((Object)SearchOptions.VIDEO_CODEC))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.AUDIO_CODEC) && !this.filterAudioCodec(tvShow, (String)this.searchOptions.get((Object)SearchOptions.AUDIO_CODEC))) {
            return false;
        }
        return !this.searchOptions.containsKey((Object)SearchOptions.VIDEO_FORMAT) || this.filterVideoFormat(tvShow, (String)this.searchOptions.get((Object)SearchOptions.VIDEO_FORMAT));
    }

    private boolean tvShowSeasonFilterMatch(TvShowSeason season) {
        if (this.searchOptions.containsKey((Object)SearchOptions.MEDIA_SOURCE) && !this.filterMediaSource(season, (MediaSource)((Object)this.searchOptions.get((Object)SearchOptions.MEDIA_SOURCE)))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.TEXT) && !this.filterText(season, (String)this.searchOptions.get((Object)SearchOptions.TEXT))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.CAST) && !this.filterCrew(season, (String)this.searchOptions.get((Object)SearchOptions.CAST))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_METADATA) && !this.filterMissingMetadata(season)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_ARTWORK) && !this.filterMissingArtwork(season)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_SUBTITLES) && !this.filterMissingSubtitles(season)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.NEW_EPISODES) && !this.filterNewEpisodes(season)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.WATCHED) && !this.filterWatched(season, (Boolean)this.searchOptions.get((Object)SearchOptions.WATCHED))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.GENRE) && !this.filterGenre(season, (MediaGenres)this.searchOptions.get((Object)SearchOptions.GENRE))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.TAG) && this.searchOptions.get((Object)SearchOptions.TAG) instanceof List && !this.filterTag(season, (List)this.searchOptions.get((Object)SearchOptions.TAG))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.VIDEO_CODEC) && !this.filterVideoCodec(season, (String)this.searchOptions.get((Object)SearchOptions.VIDEO_CODEC))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.AUDIO_CODEC) && !this.filterAudioCodec(season, (String)this.searchOptions.get((Object)SearchOptions.AUDIO_CODEC))) {
            return false;
        }
        return !this.searchOptions.containsKey((Object)SearchOptions.VIDEO_FORMAT) || this.filterVideoFormat(season, (String)this.searchOptions.get((Object)SearchOptions.VIDEO_FORMAT));
    }

    private boolean tvShowEpisodeFilterMatch(TvShowEpisode episode) {
        if (this.searchOptions.containsKey((Object)SearchOptions.TEXT) && !this.filterText(episode, (String)this.searchOptions.get((Object)SearchOptions.TEXT))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.CAST) && !this.filterCrew(episode, (String)this.searchOptions.get((Object)SearchOptions.CAST))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MEDIA_SOURCE) && !this.filterMediaSource(episode, (MediaSource)((Object)this.searchOptions.get((Object)SearchOptions.MEDIA_SOURCE)))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_METADATA) && !this.filterMissingMetadata(episode)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_ARTWORK) && !this.filterMissingArtwork(episode)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.MISSING_SUBTITLES) && !this.filterMissingSubtitles(episode)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.NEW_EPISODES) && !this.filterNewEpisodes(episode)) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.WATCHED) && !this.filterWatched(episode, (Boolean)this.searchOptions.get((Object)SearchOptions.WATCHED))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.GENRE) && !this.filterGenre(episode, (MediaGenres)this.searchOptions.get((Object)SearchOptions.GENRE))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.TAG) && this.searchOptions.get((Object)SearchOptions.TAG) instanceof List && !this.filterTag(episode, (List)this.searchOptions.get((Object)SearchOptions.TAG))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.VIDEO_CODEC) && !this.filterVideoCodec(episode, (String)this.searchOptions.get((Object)SearchOptions.VIDEO_CODEC))) {
            return false;
        }
        if (this.searchOptions.containsKey((Object)SearchOptions.AUDIO_CODEC) && !this.filterAudioCodec(episode, (String)this.searchOptions.get((Object)SearchOptions.AUDIO_CODEC))) {
            return false;
        }
        return !this.searchOptions.containsKey((Object)SearchOptions.VIDEO_FORMAT) || this.filterVideoFormat(episode, (String)this.searchOptions.get((Object)SearchOptions.VIDEO_FORMAT));
    }

    private boolean filterText(TvShow tvShow, String filterText) {
        return this.matchesText(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), filterText);
    }

    private boolean filterText(TvShowSeason season, String filterText) {
        return this.matchesText(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()), filterText);
    }

    private boolean filterText(TvShowEpisode episode, String filterText) {
        return this.matchesText(episode.getTvShow(), Arrays.asList(episode), filterText);
    }

    private boolean filterDatasource(TvShow tvShow, List<?> datasources) {
        return datasources.isEmpty() || datasources.contains(tvShow.getDataSource());
    }

    private boolean filterMediaSource(TvShow tvShow, MediaSource mediaSource) {
        return this.matchesMediaSource(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), mediaSource);
    }

    private boolean filterMediaSource(TvShowSeason season, MediaSource mediaSource) {
        return this.matchesMediaSource(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()), mediaSource);
    }

    private boolean filterMediaSource(TvShowEpisode episode, MediaSource mediaSource) {
        return this.matchesMediaSource(episode.getTvShow(), Arrays.asList(episode), mediaSource);
    }

    private boolean filterCrew(TvShow tvShow, String filterText) {
        return this.matchesCrew(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), filterText);
    }

    private boolean filterCrew(TvShowSeason season, String filterText) {
        return this.matchesCrew(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()), filterText);
    }

    private boolean filterCrew(TvShowEpisode episode, String filterText) {
        return this.matchesCrew(episode.getTvShow(), Arrays.asList(episode), filterText);
    }

    private boolean filterMissingMetadata(TvShow tvShow) {
        return this.matchesMissingMetadata(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()));
    }

    private boolean filterMissingMetadata(TvShowSeason season) {
        return this.matchesMissingMetadata(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()));
    }

    private boolean filterMissingMetadata(TvShowEpisode episode) {
        return this.matchesMissingMetadata(episode.getTvShow(), Arrays.asList(episode));
    }

    private boolean filterMissingArtwork(TvShow tvShow) {
        return this.matchesMissingArtwork(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()));
    }

    private boolean filterMissingArtwork(TvShowSeason season) {
        return this.matchesMissingArtwork(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()));
    }

    private boolean filterMissingArtwork(TvShowEpisode episode) {
        return this.matchesMissingArtwork(episode.getTvShow(), Arrays.asList(episode));
    }

    private boolean filterMissingSubtitles(TvShow tvShow) {
        return this.matchesMissingSubtitles(new ArrayList<TvShowEpisode>(tvShow.getEpisodes()));
    }

    private boolean filterMissingSubtitles(TvShowSeason season) {
        return this.matchesMissingSubtitles(new ArrayList<TvShowEpisode>(season.getEpisodes()));
    }

    private boolean filterMissingSubtitles(TvShowEpisode episode) {
        return this.matchesMissingSubtitles(Arrays.asList(episode));
    }

    private boolean filterNewEpisodes(TvShow tvShow) {
        return tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes();
    }

    private boolean filterNewEpisodes(TvShowSeason season) {
        return season.isNewlyAdded();
    }

    private boolean filterNewEpisodes(TvShowEpisode episode) {
        return episode.isNewlyAdded();
    }

    private boolean filterWatched(TvShow tvShow, Boolean watched) {
        return this.matchesWatched(new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), watched);
    }

    private boolean filterWatched(TvShowSeason season, Boolean watched) {
        return this.matchesWatched(new ArrayList<TvShowEpisode>(season.getEpisodes()), watched);
    }

    private boolean filterWatched(TvShowEpisode episode, Boolean watched) {
        return this.matchesWatched(Arrays.asList(episode), watched);
    }

    private boolean filterGenre(TvShow tvShow, MediaGenres genre) {
        return this.matchesGenre(tvShow, genre);
    }

    private boolean filterGenre(TvShowSeason season, MediaGenres genre) {
        return this.matchesGenre(season.getTvShow(), genre);
    }

    private boolean filterGenre(TvShowEpisode episode, MediaGenres genre) {
        return this.matchesGenre(episode.getTvShow(), genre);
    }

    private boolean filterTag(TvShow tvShow, List<?> tags) {
        return this.matchesTag(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), tags);
    }

    private boolean filterTag(TvShowSeason season, List<?> tags) {
        return this.matchesTag(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()), tags);
    }

    private boolean filterTag(TvShowEpisode episode, List<?> tags) {
        return this.matchesTag(episode.getTvShow(), Arrays.asList(episode), tags);
    }

    private boolean filterVideoCodec(TvShow tvShow, String codec) {
        return this.matchesVideoCodec(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), codec);
    }

    private boolean filterVideoCodec(TvShowSeason season, String codec) {
        return this.matchesVideoCodec(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()), codec);
    }

    private boolean filterVideoCodec(TvShowEpisode episode, String codec) {
        return this.matchesVideoCodec(episode.getTvShow(), Arrays.asList(episode), codec);
    }

    private boolean filterAudioCodec(TvShow tvShow, String codec) {
        return this.matchesAudioCodec(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), codec);
    }

    private boolean filterAudioCodec(TvShowSeason season, String codec) {
        return this.matchesAudioCodec(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()), codec);
    }

    private boolean filterAudioCodec(TvShowEpisode episode, String codec) {
        return this.matchesAudioCodec(episode.getTvShow(), Arrays.asList(episode), codec);
    }

    private boolean filterVideoFormat(TvShow tvShow, String format) {
        return this.matchesVideoFormat(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodes()), format);
    }

    private boolean filterVideoFormat(TvShowSeason season, String format) {
        return this.matchesVideoFormat(season.getTvShow(), new ArrayList<TvShowEpisode>(season.getEpisodes()), format);
    }

    private boolean filterVideoFormat(TvShowEpisode episode, String format) {
        return this.matchesVideoFormat(episode.getTvShow(), Arrays.asList(episode), format);
    }

    private boolean matchesText(TvShow tvShow, List<TvShowEpisode> episodes, String filterText) {
        if (StringUtils.isBlank((CharSequence)filterText)) {
            return true;
        }
        Pattern pattern = Pattern.compile("(?i)" + Pattern.quote(filterText));
        Matcher matcher = pattern.matcher(tvShow.getTitle());
        if (matcher.find()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            matcher = pattern.matcher(episode.getTitle());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesCrew(TvShow tvShow, List<TvShowEpisode> episodes, String filterText) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)filterText)) {
            return true;
        }
        Pattern pattern = Pattern.compile("(?i)" + Pattern.quote(filterText));
        for (TvShowActor actor : tvShow.getActors()) {
            matcher = pattern.matcher(actor.getName());
            if (!matcher.find()) continue;
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            matcher = pattern.matcher(episode.getDirector());
            if (matcher.find()) {
                return true;
            }
            matcher = pattern.matcher(episode.getWriter());
            if (matcher.find()) {
                return true;
            }
            for (TvShowActor actor : episode.getGuests()) {
                matcher = pattern.matcher(actor.getName());
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesMissingMetadata(TvShow tvShow, List<TvShowEpisode> episodes) {
        if (!tvShow.isScraped()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (episode.isScraped()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesMissingArtwork(TvShow tvShow, List<TvShowEpisode> episodes) {
        if (!tvShow.getHasImages().booleanValue()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (episode.getHasImages().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesMissingSubtitles(List<TvShowEpisode> episodes) {
        for (TvShowEpisode episode : episodes) {
            if (episode.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesWatched(List<TvShowEpisode> episodes, boolean watched) {
        for (TvShowEpisode episode : episodes) {
            if (episode.isWatched() != watched) continue;
            return true;
        }
        return false;
    }

    private boolean matchesGenre(TvShow tvShow, MediaGenres genre) {
        return tvShow.getGenres().contains(genre);
    }

    private boolean matchesTag(TvShow tvShow, List<TvShowEpisode> episodes, List<?> tags) {
        ArrayList<String> cleanedTags = new ArrayList<String>();
        for (Object obj : tags) {
            if (!(obj instanceof String) || !StringUtils.isNotBlank((CharSequence)((String)obj))) continue;
            cleanedTags.add((String)obj);
        }
        if (cleanedTags.isEmpty()) {
            return tvShow.getTags().isEmpty();
        }
        if (tvShow.getTags().containsAll(cleanedTags)) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (cleanedTags.isEmpty()) {
                return episode.getTags().isEmpty();
            }
            if (!episode.getTags().containsAll(cleanedTags)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesVideoCodec(TvShow tvShow, List<TvShowEpisode> episodes, String codec) {
        if (StringUtils.isBlank((CharSequence)codec)) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
            for (MediaFile mf : mfs) {
                if (!mf.getVideoCodec().equalsIgnoreCase(codec)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesAudioCodec(TvShow tvShow, List<TvShowEpisode> episodes, String codec) {
        if (StringUtils.isBlank((CharSequence)codec)) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
            for (MediaFile mf : mfs) {
                if (!mf.getAudioCodec().equalsIgnoreCase(codec)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesVideoFormat(TvShow tvShow, List<TvShowEpisode> episodes, String videoFormat) {
        if (StringUtils.isBlank((CharSequence)videoFormat)) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (videoFormat == "HD" || videoFormat == "SD") {
                if (videoFormat == "HD" && this.isVideoHD(episode.getMediaInfoVideoFormat())) {
                    return true;
                }
                if (videoFormat != "SD" || this.isVideoHD(episode.getMediaInfoVideoFormat())) continue;
                return true;
            }
            if (videoFormat != episode.getMediaInfoVideoFormat()) continue;
            return true;
        }
        return false;
    }

    private boolean isVideoHD(String videoFormat) {
        if (videoFormat == "720p") {
            return true;
        }
        if (videoFormat == "1080p") {
            return true;
        }
        if (videoFormat == "4k") {
            return true;
        }
        return videoFormat == "8k";
    }

    private boolean matchesMediaSource(TvShow tvShow, List<TvShowEpisode> episodes, MediaSource mediaSource) {
        for (TvShowEpisode episode : episodes) {
            if (episode.getMediaSource() != mediaSource) continue;
            return true;
        }
        return false;
    }

    public static enum SearchOptions {
        TEXT,
        WATCHED,
        GENRE,
        CAST,
        TAG,
        VIDEO_FORMAT,
        VIDEO_CODEC,
        AUDIO_CODEC,
        DATASOURCE,
        MEDIA_SOURCE,
        MISSING_METADATA,
        MISSING_ARTWORK,
        MISSING_SUBTITLES,
        NEW_EPISODES;

    }
}

