/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.movie.tasks.MovieTrailerDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.util.UrlUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieTrailerPanel
extends JPanel {
    private static final long serialVersionUID = 2506465845096043845L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieTrailerPanel.class);
    private MovieSelectionModel movieSelectionModel;
    private JTable table;
    private SortedList<MovieTrailer> trailerEventList = null;
    private DefaultEventTableModel<MovieTrailer> trailerTableModel = null;

    public MovieTrailerPanel(MovieSelectionModel model) {
        this.movieSelectionModel = model;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        this.trailerEventList = new SortedList((EventList)GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieTrailer.class))));
        this.trailerTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.trailerEventList), (TableFormat)new TrailerTableFormat());
        this.table = new ZebraJTable((TableModel)this.trailerTableModel);
        this.table.setAutoResizeMode(0);
        this.table.setSelectionModel(new NullSelectionModel());
        TableComparatorChooser.install((JTable)this.table, this.trailerEventList, (Object)TableComparatorChooser.SINGLE_COLUMN);
        JScrollPane scrollPane = ZebraJTable.createStripedJScrollPane(this.table);
        this.add((Component)scrollPane, "2, 2, fill, fill");
        scrollPane.setViewportView(this.table);
        LinkListener linkListener = new LinkListener();
        this.table.addMouseListener(linkListener);
        this.table.addMouseMotionListener(linkListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == MovieSelectionModel.class && "selectedMovie".equals(property) || source.getClass() == Movie.class && "trailer".equals(property)) {
                    MovieTrailerPanel.this.trailerEventList.clear();
                    MovieTrailerPanel.this.trailerEventList.addAll(MovieTrailerPanel.this.movieSelectionModel.getSelectedMovie().getTrailer());
                    try {
                        TableColumnResizer.adjustColumnPreferredWidths(MovieTrailerPanel.this.table, 7);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        };
        this.movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private class NullSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = -1956483331520197616L;

        private NullSelectionModel() {
        }

        @Override
        public boolean isSelectionEmpty() {
            return true;
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return false;
        }

        @Override
        public int getMinSelectionIndex() {
            return -1;
        }

        @Override
        public int getMaxSelectionIndex() {
            return -1;
        }

        @Override
        public int getLeadSelectionIndex() {
            return -1;
        }

        @Override
        public int getAnchorSelectionIndex() {
            return -1;
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
        }

        @Override
        public void setLeadSelectionIndex(int index) {
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
        }

        @Override
        public void clearSelection() {
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
        }

        @Override
        public void setSelectionMode(int selectionMode) {
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public void addListSelectionListener(ListSelectionListener lsl) {
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener lsl) {
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MovieTrailer trailer;
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                row = table.convertRowIndexToModel(row);
                trailer = (MovieTrailer)MovieTrailerPanel.this.trailerEventList.get(row);
                if (StringUtils.isNotBlank((CharSequence)trailer.getUrl()) && trailer.getUrl().toLowerCase(Locale.ROOT).startsWith("http")) {
                    Movie movie = MovieTrailerPanel.this.movieSelectionModel.getSelectedMovie();
                    MovieTrailerDownloadTask task = new MovieTrailerDownloadTask(trailer, movie);
                    TmmTaskManager.getInstance().addDownloadTask(task);
                }
            }
            if (col == 1) {
                row = table.convertRowIndexToModel(row);
                trailer = (MovieTrailer)MovieTrailerPanel.this.trailerEventList.get(row);
                String url = trailer.getUrl();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0 || col == 1) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if ((col == 0 || col == 1) && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private class TrailerTableFormat
    implements AdvancedTableFormat<MovieTrailer> {
        private Comparator<String> stringComparator = new StringComparator();

        public int getColumnCount() {
            return 7;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return "";
                }
                case 2: {
                    return BUNDLE.getString("metatag.nfo");
                }
                case 3: {
                    return BUNDLE.getString("metatag.name");
                }
                case 4: {
                    return BUNDLE.getString("metatag.source");
                }
                case 5: {
                    return BUNDLE.getString("metatag.quality");
                }
                case 6: {
                    return BUNDLE.getString("metatag.format");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MovieTrailer trailer, int column) {
            if (trailer == null) {
                return null;
            }
            switch (column) {
                case 0: {
                    if (StringUtils.isNotBlank((CharSequence)trailer.getUrl()) && trailer.getUrl().toLowerCase(Locale.ROOT).startsWith("http")) {
                        return IconManager.DOWNLOAD;
                    }
                    return null;
                }
                case 1: {
                    return IconManager.PLAY_SMALL;
                }
                case 2: {
                    return trailer.getInNfo();
                }
                case 3: {
                    return trailer.getName();
                }
                case 4: {
                    return trailer.getProvider();
                }
                case 5: {
                    return trailer.getQuality();
                }
                case 6: {
                    String ext = UrlUtil.getExtension((String)trailer.getUrl()).toLowerCase(Locale.ROOT);
                    if (!Globals.settings.getVideoFileType().contains("." + ext)) {
                        ext = "";
                    }
                    return ext;
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return ImageIcon.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            switch (arg0) {
                case 0: 
                case 1: {
                    return null;
                }
            }
            return this.stringComparator;
        }

        private class StringComparator
        implements Comparator<String> {
            private StringComparator() {
            }

            @Override
            public int compare(String arg0, String arg1) {
                if (StringUtils.isEmpty((CharSequence)arg0)) {
                    return -1;
                }
                if (StringUtils.isEmpty((CharSequence)arg1)) {
                    return 1;
                }
                return arg0.toLowerCase(Locale.ROOT).compareTo(arg1.toLowerCase(Locale.ROOT));
            }
        }
    }
}

