/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.net.URLEncoder;
import java.util.ArrayList;
import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.Person;
import org.fourthline.cling.support.model.PersonWithRole;
import org.fourthline.cling.support.model.Res;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowActor;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.thirdparty.upnp.MimeTypes;
import org.tinymediamanager.thirdparty.upnp.Upnp;

public class Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);

    public static org.fourthline.cling.support.model.item.Movie getUpnpMovie(Movie tmmMovie, boolean full) {
        LOGGER.trace(tmmMovie.getTitle());
        org.fourthline.cling.support.model.item.Movie m = new org.fourthline.cling.support.model.item.Movie();
        try {
            m.setId("1/" + tmmMovie.getDbId().toString());
            m.setParentID("1");
            if (!tmmMovie.getYear().isEmpty()) {
                m.addProperty((DIDLObject.Property)new DIDLObject.Property.DC.DATE(tmmMovie.getYear()));
            }
            m.setTitle(tmmMovie.getTitle());
            for (MediaFile mf : tmmMovie.getMediaFiles(MediaFileType.VIDEO)) {
                String rel = tmmMovie.getPathNIO().relativize(mf.getFileAsPath()).toString().replaceAll("\\\\", "/");
                String string = "http://" + Upnp.IP + ":8008/upnp/movies/" + tmmMovie.getDbId().toString() + "/" + URLEncoder.encode(rel, "UTF-8");
                Res r = new Res(MimeTypes.getMimeType(mf.getExtension()), Long.valueOf(mf.getFilesize()), string);
                m.addResource(r);
            }
            if (full) {
                PersonWithRole[] arr;
                m.setDescription(tmmMovie.getPlot());
                m.setLanguage(tmmMovie.getSpokenLanguages());
                m.setRating(String.valueOf(tmmMovie.getRating()));
                ArrayList<String> genres = new ArrayList<String>();
                for (MediaGenres g : tmmMovie.getGenres()) {
                    genres.add(g.getLocalizedName());
                }
                if (!genres.isEmpty()) {
                    String[] arr2 = genres.toArray(new String[genres.size()]);
                    m.setGenres(arr2);
                }
                ArrayList<PersonWithRole> persons = new ArrayList<PersonWithRole>();
                for (MovieActor movieActor : tmmMovie.getActors()) {
                    persons.add(new PersonWithRole(movieActor.getName(), movieActor.getCharacter()));
                }
                if (!persons.isEmpty()) {
                    arr = persons.toArray(new PersonWithRole[persons.size()]);
                    m.setActors(arr);
                }
                persons = new ArrayList();
                for (MovieProducer movieProducer : tmmMovie.getProducers()) {
                    persons.add(new PersonWithRole(movieProducer.getName(), movieProducer.getCharacter()));
                }
                if (!persons.isEmpty()) {
                    arr = persons.toArray(new PersonWithRole[persons.size()]);
                    m.setProducers((Person[])arr);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting TMM movie", (Throwable)e);
        }
        return m;
    }

    public static org.fourthline.cling.support.model.item.Movie getUpnpTvShowEpisode(TvShow show, TvShowEpisode ep, boolean full) {
        LOGGER.trace(ep.getTitle());
        org.fourthline.cling.support.model.item.Movie m = new org.fourthline.cling.support.model.item.Movie();
        try {
            m.setId("2/" + show.getDbId().toString() + "/" + ep.getSeason() + "/" + ep.getEpisode());
            m.setParentID("2/" + show.getDbId().toString());
            if (!ep.getYear().isEmpty()) {
                m.addProperty((DIDLObject.Property)new DIDLObject.Property.DC.DATE(ep.getYear()));
            }
            m.setTitle("S" + Metadata.lz(ep.getSeason()) + "E" + Metadata.lz(ep.getEpisode()) + " " + ep.getTitle());
            for (MediaFile mf : ep.getMediaFiles(MediaFileType.VIDEO)) {
                String rel = show.getPathNIO().relativize(mf.getFileAsPath()).toString().replaceAll("\\\\", "/");
                String url = "http://" + Upnp.IP + ":8008/upnp/tvshows/" + show.getDbId().toString() + "/" + URLEncoder.encode(rel, "UTF-8");
                Res r = new Res(MimeTypes.getMimeType(mf.getExtension()), Long.valueOf(mf.getFilesize()), url);
                m.addResource(r);
            }
            if (full) {
                m.setDescription(ep.getPlot());
                m.setRating(String.valueOf(ep.getRating()));
                ArrayList<String> genres = new ArrayList<String>();
                for (MediaGenres g : show.getGenres()) {
                    genres.add(g.getLocalizedName());
                }
                if (!genres.isEmpty()) {
                    String[] arr = genres.toArray(new String[genres.size()]);
                    m.setGenres(arr);
                }
                ArrayList<PersonWithRole> persons = new ArrayList<PersonWithRole>();
                for (TvShowActor a : ep.getActors()) {
                    persons.add(new PersonWithRole(a.getName(), a.getCharacter()));
                }
                if (!persons.isEmpty()) {
                    PersonWithRole[] arr = persons.toArray(new PersonWithRole[persons.size()]);
                    m.setActors(arr);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting TMM show", (Throwable)e);
        }
        return m;
    }

    private static String lz(int num) {
        return String.format("%02d", num);
    }
}

