/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ImageCacheTask;
import org.tinymediamanager.core.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.ui.UTF8Control;

@Deprecated
public class TvShowUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowUpdateDatasourceTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final List<String> skipFolders = Arrays.asList(".", "..", "CERTIFICATE", "BACKUP", "PLAYLIST", "CLPINF", "SSIF", "AUXDATA", "AUDIO_TS", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR");
    private static final String skipFoldersRegex = "^[.][\\w@]+.*";
    private static final String skipFilesStartingWith = "._";
    private static final Pattern posterPattern1 = Pattern.compile("(?i)(poster|folder)\\..{2,4}");
    private static final Pattern posterPattern2 = Pattern.compile("(?i).*-poster\\..{2,4}");
    private static final Pattern fanartPattern1 = Pattern.compile("(?i)fanart\\..{2,4}");
    private static final Pattern fanartPattern2 = Pattern.compile("(?i).*(-|.)fanart\\..{2,4}");
    private static final Pattern bannerPattern1 = Pattern.compile("(?i)banner\\..{2,4}");
    private static final Pattern bannerPattern2 = Pattern.compile("(?i).*(-|.)banner\\..{2,4}");
    private static final Pattern clearartPattern1 = Pattern.compile("(?i)clearart\\..{2,4}");
    private static final Pattern clearartPattern2 = Pattern.compile("(?i).*(-|.)clearart\\..{2,4}");
    private static final Pattern logoPattern1 = Pattern.compile("(?i)logo\\..{2,4}");
    private static final Pattern logoPattern2 = Pattern.compile("(?i).*(-|.)logo\\..{2,4}");
    private static final Pattern clearlogoPattern1 = Pattern.compile("(?i)clearlogo\\..{2,4}");
    private static final Pattern clearlogoPattern2 = Pattern.compile("(?i).*(-|.)clearlogo\\..{2,4}");
    private static final Pattern thumbPattern1 = Pattern.compile("(?i)thumb\\..{2,4}");
    private static final Pattern thumbPattern2 = Pattern.compile("(?i).*(-|.)thumb\\..{2,4}");
    private static final Pattern seasonPattern = Pattern.compile("(?i)season([0-9]{0,2}|-specials)-poster\\..{2,4}");
    private List<String> dataSources;
    private List<File> tvShowFolders = new ArrayList<File>();
    private TvShowList tvShowList;
    private HashSet<File> filesFound = new HashSet();

    public TvShowUpdateDatasourceTask() {
        super(BUNDLE.getString("update.datasource"));
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(TvShowModuleManager.SETTINGS.getTvShowDataSource());
    }

    public TvShowUpdateDatasourceTask(String datasource) {
        super(BUNDLE.getString("update.datasource") + " (" + datasource + ")");
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
    }

    public TvShowUpdateDatasourceTask(List<File> tvShowFolders) {
        super(BUNDLE.getString("update.datasource"));
        this.tvShowList = TvShowList.getInstance();
        this.dataSources = new ArrayList<String>(0);
        this.tvShowFolders.addAll(tvShowFolders);
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.tvShowFolders.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.start();
            if (this.tvShowFolders.size() == 0) {
                this.updateDatasource();
            } else {
                this.updateTvShows();
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took " + stopWatch);
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void updateDatasource() {
        TmmTask task;
        ArrayList<Path> imageFiles = new ArrayList<Path>();
        ArrayList<File> existing = new ArrayList<File>();
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            existing.add(new File(tvShow.getPath()));
        }
        for (String path : this.dataSources) {
            int i;
            File[] dirs = new File(path).listFiles();
            ArrayList<File> newShows = new ArrayList<File>();
            ArrayList<File> existingShows = new ArrayList<File>();
            if (dirs == null || dirs.length == 0) {
                LOGGER.warn("Datasource not available/empty " + path);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{path}));
                continue;
            }
            this.initThreadPool(1, "update");
            for (File subdir : dirs) {
                if (this.cancel) break;
                String directoryName = subdir.getName();
                if (skipFolders.contains(directoryName.toUpperCase(Locale.ROOT)) || directoryName.matches(skipFoldersRegex) || TvShowModuleManager.SETTINGS.getTvShowSkipFolders().contains(subdir.getAbsolutePath())) {
                    LOGGER.info("ignoring directory " + directoryName);
                    continue;
                }
                if (subdir.isDirectory()) {
                    File tmmIgnore = new File(subdir, ".tmmignore");
                    File tmmIgnore2 = new File(subdir, "tmmignore");
                    if (!tmmIgnore.exists() && !tmmIgnore2.exists()) {
                        if (existing.contains(subdir)) {
                            existingShows.add(subdir);
                        } else {
                            newShows.add(subdir);
                        }
                    }
                }
                if (!subdir.isFile() || !Globals.settings.getVideoFileType().contains("." + FilenameUtils.getExtension((String)subdir.getName()))) continue;
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.episodeinroot", new String[]{subdir.getName()}));
            }
            for (File subdir : newShows) {
                this.submitTask(new FindTvShowTask(subdir, path));
            }
            for (File subdir : existingShows) {
                this.submitTask(new FindTvShowTask(subdir, path));
            }
            this.waitForCompletionOrCancel();
            if (this.cancel) break;
            this.setTaskName(BUNDLE.getString("update.cleanup"));
            this.setTaskDescription(null);
            this.setProgressDone(0);
            this.setWorkUnits(0);
            this.publishState();
            LOGGER.info("removing orphaned tv shows/files...");
            for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                TvShow tvShow = this.tvShowList.getTvShows().get(i);
                if (!new File(path).equals(new File(tvShow.getDataSource()))) continue;
                File tvShowDir = new File(tvShow.getPath());
                if (!tvShowDir.exists()) {
                    this.tvShowList.removeTvShow(tvShow);
                    continue;
                }
                this.cleanup(tvShow);
            }
            if (this.cancel) break;
            this.setTaskName(BUNDLE.getString("update.mediainfo"));
            this.publishState();
            this.initThreadPool(1, "mediainfo");
            LOGGER.info("getting Mediainfo...");
            for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                TvShow tvShow = this.tvShowList.getTvShows().get(i);
                if (!new File(path).equals(new File(tvShow.getDataSource()))) continue;
                this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
            }
            this.waitForCompletionOrCancel();
            if (this.cancel) break;
            if (!TvShowModuleManager.SETTINGS.isBuildImageCacheOnImport()) continue;
            for (TvShow tvShow : new ArrayList<TvShow>(this.tvShowList.getTvShows())) {
                if (!new File(path).equals(new File(tvShow.getDataSource()))) continue;
                for (MediaFile mf : new ArrayList<MediaFile>(tvShow.getMediaFiles())) {
                    if (!mf.isGraphic()) continue;
                    imageFiles.add(mf.getFileAsPath());
                }
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    for (MediaFile mf : new ArrayList<MediaFile>(episode.getMediaFiles())) {
                        if (!mf.isGraphic()) continue;
                        imageFiles.add(mf.getFileAsPath());
                    }
                }
            }
        }
        if (this.cancel) {
            return;
        }
        if (imageFiles.size() > 0) {
            task = new ImageCacheTask(imageFiles);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
            task = new SyncTraktTvTask(false, false, true, true);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }

    private void updateTvShows() {
        TvShow tvShow;
        int i;
        this.initThreadPool(1, "update");
        for (File tvShowFolder : this.tvShowFolders) {
            File[] filesInDatasourceRoot = tvShowFolder.getParentFile().listFiles();
            if (filesInDatasourceRoot == null || filesInDatasourceRoot.length == 0) {
                LOGGER.warn("TvShow folder not available/empty " + tvShowFolder);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{tvShowFolder.getParent()}));
                continue;
            }
            if (!tvShowFolder.isDirectory()) continue;
            this.submitTask(new FindTvShowTask(tvShowFolder, tvShowFolder.getParent()));
        }
        this.waitForCompletionOrCancel();
        this.setTaskName(BUNDLE.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            tvShow = this.tvShowList.getTvShows().get(i);
            if (!this.tvShowFolders.contains(new File(tvShow.getPath()))) continue;
            this.cleanup(tvShow);
        }
        this.setTaskName(BUNDLE.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            tvShow = this.tvShowList.getTvShows().get(i);
            if (!this.tvShowFolders.contains(new File(tvShow.getPath()))) continue;
            this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
        }
        this.waitForCompletionOrCancel();
        if (this.cancel) {
            return;
        }
        if (TvShowModuleManager.SETTINGS.isBuildImageCacheOnImport()) {
            ArrayList<Path> imageFiles = new ArrayList<Path>();
            for (int i2 = this.tvShowList.getTvShows().size() - 1; i2 >= 0 && !this.cancel; --i2) {
                TvShow tvShow2 = this.tvShowList.getTvShows().get(i2);
                if (!this.tvShowFolders.contains(new File(tvShow2.getPath()))) continue;
                for (MediaFile mf : new ArrayList<MediaFile>(tvShow2.getMediaFiles())) {
                    if (!mf.isGraphic()) continue;
                    imageFiles.add(mf.getFileAsPath());
                }
                for (TvShowEpisode episode : tvShow2.getEpisodes()) {
                    for (MediaFile mf : new ArrayList<MediaFile>(episode.getMediaFiles())) {
                        if (!mf.isGraphic()) continue;
                        imageFiles.add(mf.getFileAsPath());
                    }
                }
            }
            ImageCacheTask task = new ImageCacheTask(imageFiles);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }

    private void cleanup(TvShow tvShow) {
        boolean dirty = false;
        if (!tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes()) {
            ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(tvShow.getMediaFiles());
            for (MediaFile mf : mediaFiles) {
                if (this.filesFound.contains(mf.getFile())) continue;
                if (!mf.exists()) {
                    LOGGER.debug("removing orphaned file: " + mf.getPath() + File.separator + mf.getFilename());
                    tvShow.removeFromMediaFiles(mf);
                    dirty = true;
                    continue;
                }
                LOGGER.warn("file " + mf.getFile().getAbsolutePath() + " not in hashset, but on hdd!");
            }
            ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(tvShow.getEpisodes());
            for (TvShowEpisode episode : episodes) {
                mediaFiles = new ArrayList<MediaFile>(episode.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFile())) continue;
                    if (!mf.exists()) {
                        LOGGER.debug("removing orphaned file: " + mf.getPath() + File.separator + mf.getFilename());
                        episode.removeFromMediaFiles(mf);
                        dirty = true;
                        continue;
                    }
                    LOGGER.warn("file " + mf.getFile().getAbsolutePath() + " not in hashset, but on hdd!");
                }
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (mfs.size() != 0) continue;
                tvShow.removeEpisode(episode);
                dirty = true;
            }
        }
        if (dirty) {
            tvShow.saveToDb();
        }
    }

    private void gatherMediaInformationForUngatheredMediaFiles(TvShow tvShow) {
        ArrayList<MediaFile> ungatheredMediaFiles = new ArrayList<MediaFile>();
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
            ungatheredMediaFiles.add(mf);
        }
        if (ungatheredMediaFiles.size() > 0) {
            this.submitTask(new MediaFileInformationFetcherTask(ungatheredMediaFiles, (MediaEntity)tvShow, false));
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            ungatheredMediaFiles = new ArrayList();
            for (MediaFile mf : episode.getMediaFiles()) {
                if (!StringUtils.isBlank((CharSequence)mf.getContainerFormat())) continue;
                ungatheredMediaFiles.add(mf);
            }
            if (ungatheredMediaFiles.size() <= 0) continue;
            this.submitTask(new MediaFileInformationFetcherTask(ungatheredMediaFiles, (MediaEntity)episode, false));
        }
    }

    private void createTvShowFromDirectory(File dir, String datasource) {
        TvShow tvShow = this.tvShowList.getTvShowByPath(dir);
        if (tvShow == null) {
            tvShow = TvShow.parseNFO(dir);
            if (tvShow == null) {
                tvShow = new TvShow();
                tvShow.setPath(dir.getPath());
                String[] ty = ParserUtils.detectCleanMovienameAndYear(dir.getName());
                tvShow.setTitle(ty[0]);
                if (!ty[1].isEmpty()) {
                    tvShow.setYear(ty[1]);
                }
            }
            if (tvShow != null) {
                tvShow.setDataSource(datasource);
                tvShow.setNewlyAdded(true);
                this.tvShowList.addTvShow(tvShow);
            }
        }
        if (tvShow != null) {
            this.findAdditionalTvShowFiles(tvShow, dir);
            this.findTvEpisodes(tvShow, dir);
            if (tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes()) {
                tvShow.saveToDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAdditionalTvShowFiles(TvShow tvShow, File directory) {
        File[] contents = directory.listFiles();
        if (contents == null) {
            return;
        }
        ArrayList<File> completeDirContents = new ArrayList<File>(Arrays.asList(contents));
        HashSet<File> hashSet = this.filesFound;
        synchronized (hashSet) {
            this.filesFound.addAll(completeDirContents);
        }
        for (File file : completeDirContents) {
            Matcher matcher = seasonPattern.matcher(file.getName());
            if (matcher.matches() && !file.getName().startsWith(skipFilesStartingWith)) {
                LOGGER.debug("found season poster " + file.getPath());
                try {
                    int season = Integer.parseInt(matcher.group(1));
                    tvShow.setSeasonPoster(season, file);
                }
                catch (Exception e) {}
                continue;
            }
            if (!file.getName().startsWith("season-specials-poster")) continue;
            LOGGER.debug("found season specials poster " + file.getPath());
            tvShow.setSeasonPoster(-1, file);
        }
        this.findArtwork(tvShow, completeDirContents, posterPattern1, MediaFileType.POSTER);
        this.findArtwork(tvShow, completeDirContents, posterPattern2, MediaFileType.POSTER);
        this.downloadArtwork(tvShow, MediaFileType.POSTER);
        this.findArtwork(tvShow, completeDirContents, fanartPattern1, MediaFileType.FANART);
        this.findArtwork(tvShow, completeDirContents, fanartPattern2, MediaFileType.FANART);
        this.downloadArtwork(tvShow, MediaFileType.FANART);
        this.findArtwork(tvShow, completeDirContents, bannerPattern1, MediaFileType.BANNER);
        this.findArtwork(tvShow, completeDirContents, bannerPattern2, MediaFileType.BANNER);
        this.downloadArtwork(tvShow, MediaFileType.BANNER);
        this.findArtwork(tvShow, completeDirContents, logoPattern1, MediaFileType.LOGO);
        this.findArtwork(tvShow, completeDirContents, logoPattern2, MediaFileType.LOGO);
        this.downloadArtwork(tvShow, MediaFileType.LOGO);
        this.findArtwork(tvShow, completeDirContents, clearlogoPattern1, MediaFileType.CLEARLOGO);
        this.findArtwork(tvShow, completeDirContents, clearlogoPattern2, MediaFileType.CLEARLOGO);
        this.downloadArtwork(tvShow, MediaFileType.CLEARLOGO);
        this.findArtwork(tvShow, completeDirContents, clearartPattern1, MediaFileType.CLEARART);
        this.findArtwork(tvShow, completeDirContents, clearartPattern2, MediaFileType.CLEARART);
        this.downloadArtwork(tvShow, MediaFileType.CLEARART);
        this.findArtwork(tvShow, completeDirContents, thumbPattern1, MediaFileType.THUMB);
        this.findArtwork(tvShow, completeDirContents, thumbPattern2, MediaFileType.THUMB);
        this.downloadArtwork(tvShow, MediaFileType.THUMB);
    }

    private void findArtwork(TvShow show, List<File> directoryContents, Pattern searchPattern, MediaFileType type) {
        for (File file : directoryContents) {
            Matcher matcher = searchPattern.matcher(file.getName());
            if (!matcher.matches() || file.getName().startsWith(skipFilesStartingWith) || type == MediaFileType.POSTER && file.getName().matches(seasonPattern.pattern())) continue;
            MediaFile mf = new MediaFile(file, type);
            show.addToMediaFiles(mf);
            LOGGER.debug("found " + mf.getType().name().toLowerCase(Locale.ROOT) + ": " + file.getPath());
            break;
        }
    }

    private void downloadArtwork(TvShow tvShow, MediaFileType type) {
        if (StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(type)) && StringUtils.isNotBlank((CharSequence)tvShow.getArtworkUrl(type))) {
            tvShow.downloadArtwork(type);
            LOGGER.debug("got " + type.name().toLowerCase(Locale.ROOT) + " url: " + tvShow.getArtworkUrl(type) + " ; try to download this");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findTvEpisodes(TvShow tvShow, File dir) {
        LOGGER.debug("parsing " + dir.getPath());
        Object[] content = dir.listFiles();
        if (content == null) {
            LOGGER.error("Whops. Cannot access directory: " + dir.getName());
            return;
        }
        HashSet<File> hashSet = this.filesFound;
        synchronized (hashSet) {
            this.filesFound.addAll(Arrays.asList(content));
        }
        Arrays.sort(content);
        for (Object file : content) {
            MediaFile mf = new MediaFile((File)file);
            if (mf.isDiscFile()) {
                this.findTvEpisodesAsDisc(tvShow, ((File)file).getParentFile());
                break;
            }
            if (((File)file).isFile() && !((File)file).getName().startsWith(skipFilesStartingWith)) {
                if (!mf.getType().equals((Object)MediaFileType.VIDEO)) continue;
                List<TvShowEpisode> episodes = this.tvShowList.getTvEpisodesByFile(tvShow, (File)file);
                if (episodes.size() == 0) {
                    List<TvShowEpisode> episodesInNfo;
                    TvShowEpisode ep;
                    String relativePath = new File(tvShow.getPath()).toURI().relativize(((File)file).toURI()).getPath();
                    TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(relativePath, tvShow.getTitle());
                    if (result.episodes.size() == 1 && result.season > -1 && result.stackingMarkerFound && (ep = tvShow.getEpisode(result.season, result.episodes.get(0))) != null) {
                        ep.setNewlyAdded(true);
                        ep.addToMediaFiles(mf);
                        continue;
                    }
                    if (result.episodes.size() == 0) {
                        result = TvShowEpisodeAndSeasonParser.detectEpisodeFromDirectory(dir, tvShow.getPath());
                    }
                    if (result.season == -1) {
                        result.season = TvShowEpisodeAndSeasonParser.detectSeason(relativePath);
                    }
                    if ((episodesInNfo = TvShowEpisode.parseNFO((File)file)).size() > 0) {
                        for (TvShowEpisode e : episodesInNfo) {
                            e.setPath(dir.getPath());
                            e.setTvShow(tvShow);
                            e.addToMediaFiles(mf);
                            e.setDateAddedFromMediaFile(mf);
                            if (e.getMediaSource() == MediaSource.UNKNOWN) {
                                e.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                            }
                            this.findAdditionalEpisodeFiles(e, (File)file, (File[])content);
                            e.setNewlyAdded(true);
                            e.saveToDb();
                            tvShow.addEpisode(e);
                        }
                    } else if (result.episodes.size() > 0) {
                        Iterator<Comparable<TvShowEpisode>> i$ = result.episodes.iterator();
                        while (i$.hasNext()) {
                            int ep2 = (Integer)i$.next();
                            TvShowEpisode episode = new TvShowEpisode();
                            episode.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                            episode.setEpisode(ep2);
                            episode.setSeason(result.season);
                            episode.setFirstAired(result.date);
                            if (result.name.isEmpty()) {
                                result.name = FilenameUtils.getBaseName((String)((File)file).getName());
                            }
                            episode.setTitle(result.name);
                            episode.setPath(dir.getPath());
                            episode.setTvShow(tvShow);
                            episode.addToMediaFiles(mf);
                            episode.setDateAddedFromMediaFile(mf);
                            if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                                episode.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                            }
                            this.findAdditionalEpisodeFiles(episode, (File)file, (File[])content);
                            episode.setNewlyAdded(true);
                            episode.saveToDb();
                            tvShow.addEpisode(episode);
                        }
                    } else {
                        TvShowEpisode episode = new TvShowEpisode();
                        episode.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                        episode.setEpisode(-1);
                        episode.setSeason(-1);
                        episode.setPath(dir.getPath());
                        episode.setTitle(FilenameUtils.getBaseName((String)((File)file).getName()));
                        episode.setTvShow(tvShow);
                        episode.setFirstAired(result.date);
                        episode.addToMediaFiles(mf);
                        episode.setDateAddedFromMediaFile(mf);
                        if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                            episode.setMediaSource(MediaSource.parseMediaSource(mf.getFile().getAbsolutePath()));
                        }
                        this.findAdditionalEpisodeFiles(episode, (File)file, (File[])content);
                        episode.setNewlyAdded(true);
                        episode.saveToDb();
                        tvShow.addEpisode(episode);
                    }
                } else {
                    for (TvShowEpisode episode : episodes) {
                        if (!this.findAdditionalEpisodeFiles(episode, (File)file, (File[])content)) continue;
                        episode.saveToDb();
                    }
                }
            }
            if (!((File)file).isDirectory() || skipFolders.contains(((File)file).getName().toUpperCase(Locale.ROOT)) || ((File)file).getName().matches(skipFoldersRegex) || TvShowModuleManager.SETTINGS.getTvShowSkipFolders().contains(((File)file).getAbsolutePath())) continue;
            File tmmIgnore = new File((File)file, ".tmmignore");
            File tmmIgnore2 = new File((File)file, "tmmignore");
            if (tmmIgnore.exists() || tmmIgnore2.exists()) continue;
            if (((File)file).getName().toUpperCase(Locale.ROOT).equals("VIDEO_TS")) {
                this.findTvEpisodesAsDisc(tvShow, (File)file);
                continue;
            }
            if (((File)file).getName().toUpperCase(Locale.ROOT).equals("BDMV")) {
                this.findTvEpisodesAsDisc(tvShow, (File)file);
                continue;
            }
            this.findTvEpisodes(tvShow, (File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findTvEpisodesAsDisc(TvShow tvShow, File dir) {
        List<TvShowEpisode> episodes;
        String parentDir = dir.getParent();
        LOGGER.debug("parsing disc structure in " + dir.getPath() + " parent: " + parentDir);
        ArrayList<MediaFile> videoFiles = new ArrayList<MediaFile>();
        File firstVideoFile = null;
        File[] content = dir.listFiles();
        if (content == null) {
            LOGGER.error("Whops. Cannot access directory: " + dir.getName());
            return;
        }
        HashSet<File> hashSet = this.filesFound;
        synchronized (hashSet) {
            this.filesFound.addAll(Arrays.asList(content));
        }
        for (File file : content) {
            if (!file.isFile() || !Globals.settings.getVideoFileType().contains("." + FilenameUtils.getExtension((String)file.getName()).toLowerCase(Locale.ROOT)) || file.getName().startsWith(skipFilesStartingWith)) continue;
            videoFiles.add(new MediaFile(file));
            if (firstVideoFile != null) continue;
            firstVideoFile = file;
        }
        boolean isRoot = false;
        if (firstVideoFile.getParentFile().equals(new File(tvShow.getPath()))) {
            isRoot = true;
        }
        if ((episodes = this.tvShowList.getTvEpisodesByFile(tvShow, firstVideoFile)).size() == 0) {
            String relativePath = new File(tvShow.getPath()).toURI().relativize(firstVideoFile.toURI()).getPath();
            TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = null;
            result = isRoot ? TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(firstVideoFile.getPath(), tvShow.getTitle()) : TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(firstVideoFile.getParentFile().getPath(), tvShow.getTitle());
            if (result.season == -1) {
                result.season = TvShowEpisodeAndSeasonParser.detectSeason(relativePath);
            }
            if (result.episodes.size() == 0) {
                result = isRoot ? TvShowEpisodeAndSeasonParser.detectEpisodeFromDirectory(dir, tvShow.getPath()) : TvShowEpisodeAndSeasonParser.detectEpisodeFromDirectory(dir.getParentFile(), tvShow.getPath());
            }
            List<TvShowEpisode> episodesInNfo = TvShowEpisode.parseNFO(firstVideoFile);
            while (!isRoot && dir.getPath().toUpperCase(Locale.ROOT).contains("BDMV") || dir.getPath().toUpperCase(Locale.ROOT).contains("VIDEO_TS")) {
                dir = dir.getParentFile();
            }
            if (result.episodes.size() > 0) {
                for (int ep : result.episodes) {
                    TvShowEpisode episode = null;
                    for (int i = episodesInNfo.size() - 1; i >= 0; --i) {
                        TvShowEpisode e = episodesInNfo.get(i);
                        if (e.getSeason() != result.season || e.getEpisode() != ep) continue;
                        episode = e;
                        episodesInNfo.remove(i);
                        break;
                    }
                    if (episode == null) {
                        episode = new TvShowEpisode();
                        episode.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                        episode.setEpisode(ep);
                        episode.setSeason(result.season);
                        episode.setNewlyAdded(true);
                        episode.setFirstAired(result.date);
                    }
                    episode.setPath(dir.getPath());
                    episode.setTvShow(tvShow);
                    episode.setDisc(true);
                    episode.setNewlyAdded(true);
                    episode.addToMediaFiles(videoFiles);
                    episode.setDateAddedFromMediaFile(new MediaFile(firstVideoFile));
                    if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                        episode.setMediaSource(MediaSource.parseMediaSource(firstVideoFile.getAbsolutePath()));
                    }
                    this.findAdditionalEpisodeFiles(episode, firstVideoFile, content);
                    episode.saveToDb();
                    tvShow.addEpisode(episode);
                }
            } else if (episodesInNfo.size() > 0) {
                for (TvShowEpisode e : episodesInNfo) {
                    e.setPath(dir.getPath());
                    e.setTvShow(tvShow);
                    e.addToMediaFiles(videoFiles);
                    e.setNewlyAdded(true);
                    e.setDateAddedFromMediaFile(new MediaFile(firstVideoFile));
                    if (e.getMediaSource() == MediaSource.UNKNOWN) {
                        e.setMediaSource(MediaSource.parseMediaSource(firstVideoFile.getAbsolutePath()));
                    }
                    this.findAdditionalEpisodeFiles(e, firstVideoFile, content);
                    e.saveToDb();
                    tvShow.addEpisode(e);
                }
            } else {
                TvShowEpisode episode = new TvShowEpisode();
                episode.setPath(dir.getPath());
                episode.setDvdOrder(TvShowModuleManager.SETTINGS.isDvdOrder());
                episode.setEpisode(-1);
                episode.setSeason(-1);
                episode.setTvShow(tvShow);
                episode.setFirstAired(result.date);
                episode.setDisc(true);
                episode.setNewlyAdded(true);
                episode.addToMediaFiles(videoFiles);
                episode.setDateAddedFromMediaFile(new MediaFile(firstVideoFile));
                if (episode.getMediaSource() == MediaSource.UNKNOWN) {
                    episode.setMediaSource(MediaSource.parseMediaSource(firstVideoFile.getAbsolutePath()));
                }
                this.findAdditionalEpisodeFiles(episode, firstVideoFile, content);
                episode.saveToDb();
                tvShow.addEpisode(episode);
            }
        } else {
            for (TvShowEpisode episode : episodes) {
                if (!this.findAdditionalEpisodeFiles(episode, firstVideoFile, content)) continue;
                episode.saveToDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findAdditionalEpisodeFiles(TvShowEpisode episode, File videoFile, File[] directoryContents) {
        boolean newFileFound = false;
        List<MediaFile> existingMediaFiles = episode.getMediaFiles();
        for (File file : directoryContents) {
            Object vfilename;
            if (file.isFile()) {
                MediaFile mf = new MediaFile(file);
                if (existingMediaFiles.contains(mf) || mf.getType().equals((Object)MediaFileType.VIDEO) || !mf.getBasename().startsWith(FilenameUtils.getBaseName((String)videoFile.getName())) || file.getName().startsWith(skipFilesStartingWith)) continue;
                if (mf.getType() == MediaFileType.SUBTITLE) {
                    episode.setSubtitles(true);
                }
                if (mf.getType() == MediaFileType.GRAPHIC) {
                    LOGGER.debug("parsing unknown graphic " + mf.getFilename());
                    vfilename = videoFile.getName();
                    if (FilenameUtils.getBaseName((String)vfilename).equals(FilenameUtils.getBaseName((String)mf.getFilename())) || FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers((String)vfilename)).trim().equals(FilenameUtils.getBaseName((String)mf.getFilename())) || episode.getTitle().equals(FilenameUtils.getBaseName((String)mf.getFilename()))) {
                        mf.setType(MediaFileType.THUMB);
                    }
                }
                episode.addToMediaFiles(mf);
                newFileFound = true;
                continue;
            }
            if (!file.getName().equalsIgnoreCase("subs") && !file.getName().equalsIgnoreCase("subtitle")) continue;
            File[] subDirContent = file.listFiles();
            if (subDirContent == null) {
                LOGGER.error("Whops. Cannot access directory: " + file.getName());
                continue;
            }
            vfilename = this.filesFound;
            synchronized (vfilename) {
                this.filesFound.addAll(Arrays.asList(subDirContent));
            }
            for (File subDirFile : subDirContent) {
                MediaFile mf;
                if (!FilenameUtils.getBaseName((String)subDirFile.getName()).startsWith(FilenameUtils.getBaseName((String)videoFile.getName())) || existingMediaFiles.contains(mf = new MediaFile(subDirFile))) continue;
                if (mf.getType() == MediaFileType.SUBTITLE) {
                    episode.setSubtitles(true);
                }
                episode.addToMediaFiles(mf);
                newFileFound = true;
            }
        }
        return newFileFound;
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class FindTvShowTask
    implements Callable<Object> {
        private File subdir = null;
        private String datasource = "";

        public FindTvShowTask(File subdir, String datasource) {
            this.subdir = subdir;
            this.datasource = datasource;
        }

        @Override
        public String call() throws Exception {
            TvShowUpdateDatasourceTask.this.createTvShowFromDirectory(this.subdir, this.datasource);
            return this.subdir.getName();
        }
    }
}

