/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.async;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.Location;
import org.fourthline.cling.model.NetworkAddress;
import org.fourthline.cling.model.message.discovery.OutgoingNotificationRequest;
import org.fourthline.cling.model.message.discovery.OutgoingNotificationRequestDeviceType;
import org.fourthline.cling.model.message.discovery.OutgoingNotificationRequestRootDevice;
import org.fourthline.cling.model.message.discovery.OutgoingNotificationRequestServiceType;
import org.fourthline.cling.model.message.discovery.OutgoingNotificationRequestUDN;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.types.NotificationSubtype;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.protocol.SendingAsync;
import org.fourthline.cling.transport.RouterException;

public abstract class SendingNotification
extends SendingAsync {
    private static final Logger log = Logger.getLogger(SendingNotification.class.getName());
    private LocalDevice device;

    public SendingNotification(UpnpService upnpService, LocalDevice device) {
        super(upnpService);
        this.device = device;
    }

    public LocalDevice getDevice() {
        return this.device;
    }

    @Override
    protected void execute() throws RouterException {
        List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(null);
        if (activeStreamServers.size() == 0) {
            log.fine("Aborting notifications, no active stream servers found (network disabled?)");
            return;
        }
        ArrayList<Location> descriptorLocations = new ArrayList<Location>();
        for (NetworkAddress networkAddress : activeStreamServers) {
            descriptorLocations.add(new Location(networkAddress, this.getUpnpService().getConfiguration().getNamespace().getDescriptorPathString(this.getDevice())));
        }
        for (int i = 0; i < this.getBulkRepeat(); ++i) {
            try {
                for (Location descriptorLocation : descriptorLocations) {
                    this.sendMessages(descriptorLocation);
                }
                log.finer("Sleeping " + this.getBulkIntervalMilliseconds() + " milliseconds");
                Thread.sleep(this.getBulkIntervalMilliseconds());
                continue;
            }
            catch (InterruptedException interruptedException) {
                log.warning("Advertisement thread was interrupted: " + interruptedException);
            }
        }
    }

    protected int getBulkRepeat() {
        return 3;
    }

    protected int getBulkIntervalMilliseconds() {
        return 150;
    }

    public void sendMessages(Location descriptorLocation) throws RouterException {
        List<OutgoingNotificationRequest> serviceTypeMsgs;
        log.finer("Sending root device messages: " + this.getDevice());
        List<OutgoingNotificationRequest> rootDeviceMsgs = this.createDeviceMessages(this.getDevice(), descriptorLocation);
        for (OutgoingNotificationRequest upnpMessage : rootDeviceMsgs) {
            this.getUpnpService().getRouter().send(upnpMessage);
        }
        if (this.getDevice().hasEmbeddedDevices()) {
            for (LocalDevice embeddedDevice : (LocalDevice[])this.getDevice().findEmbeddedDevices()) {
                log.finer("Sending embedded device messages: " + embeddedDevice);
                List<OutgoingNotificationRequest> embeddedDeviceMsgs = this.createDeviceMessages(embeddedDevice, descriptorLocation);
                for (OutgoingNotificationRequest upnpMessage : embeddedDeviceMsgs) {
                    this.getUpnpService().getRouter().send(upnpMessage);
                }
            }
        }
        if ((serviceTypeMsgs = this.createServiceTypeMessages(this.getDevice(), descriptorLocation)).size() > 0) {
            log.finer("Sending service type messages");
            for (OutgoingNotificationRequest upnpMessage : serviceTypeMsgs) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
        }
    }

    protected List<OutgoingNotificationRequest> createDeviceMessages(LocalDevice device, Location descriptorLocation) {
        ArrayList<OutgoingNotificationRequest> msgs = new ArrayList<OutgoingNotificationRequest>();
        if (device.isRoot()) {
            msgs.add(new OutgoingNotificationRequestRootDevice(descriptorLocation, device, this.getNotificationSubtype()));
        }
        msgs.add(new OutgoingNotificationRequestUDN(descriptorLocation, device, this.getNotificationSubtype()));
        msgs.add(new OutgoingNotificationRequestDeviceType(descriptorLocation, device, this.getNotificationSubtype()));
        return msgs;
    }

    protected List<OutgoingNotificationRequest> createServiceTypeMessages(LocalDevice device, Location descriptorLocation) {
        ArrayList<OutgoingNotificationRequest> msgs = new ArrayList<OutgoingNotificationRequest>();
        for (ServiceType serviceType : device.findServiceTypes()) {
            msgs.add(new OutgoingNotificationRequestServiceType(descriptorLocation, device, this.getNotificationSubtype(), serviceType));
        }
        return msgs;
    }

    protected abstract NotificationSubtype getNotificationSubtype();
}

