/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.panels.MediaFilesPanel;

public class MovieMediaFilesPanel
extends JPanel {
    private static final long serialVersionUID = 3181909355114738346L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieMediaFilesPanel.class);
    private MovieSelectionModel movieSelectionModel;
    private JLabel lblFilesT;
    private LinkLabel lblMoviePath;
    private JLabel lblDateAddedT;
    private JLabel lblDateAdded;
    private JLabel lblMoviePathT;
    private EventList<MediaFile> mediaFileEventList;
    private MediaFilesPanel panelMediaFiles;

    public MovieMediaFilesPanel(MovieSelectionModel model) {
        this.movieSelectionModel = model;
        this.mediaFileEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFile.class));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.NARROW_LINE_GAP_ROWSPEC}));
        this.lblDateAddedT = new JLabel(BUNDLE.getString("metatag.dateadded"));
        this.add((Component)this.lblDateAddedT, "2, 2");
        this.lblDateAdded = new JLabel("");
        this.add((Component)this.lblDateAdded, "4, 2");
        this.lblMoviePathT = new JLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)this.lblMoviePathT, "2, 4");
        this.lblMoviePath = new LinkLabel("");
        this.lblMoviePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!StringUtils.isEmpty((CharSequence)MovieMediaFilesPanel.this.lblMoviePath.getNormalText())) {
                    Path path = Paths.get(MovieMediaFilesPanel.this.lblMoviePath.getNormalText(), new String[0]);
                    try {
                        if (Files.exists(path, new LinkOption[0])) {
                            TmmUIHelper.openFile(path);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("open filemanager", (Throwable)ex);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                    }
                }
            }
        });
        this.lblMoviePathT.setLabelFor(this.lblMoviePath);
        this.lblMoviePathT.setLabelFor(this.lblMoviePath);
        this.add((Component)this.lblMoviePath, "4, 4");
        this.lblFilesT = new JLabel(BUNDLE.getString("metatag.files"));
        this.add((Component)this.lblFilesT, "2, 6, default, top");
        this.panelMediaFiles = new MediaFilesPanel(this.mediaFileEventList){

            @Override
            public MediaEntity getMediaEntity() {
                return MovieMediaFilesPanel.this.movieSelectionModel.getSelectedMovie();
            }
        };
        this.add((Component)this.panelMediaFiles, "4, 6, 1, 1, fill, fill");
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == MovieSelectionModel.class && "selectedMovie".equals(property) || source.getClass() == Movie.class && "mediaFiles".equals(property)) {
                    try {
                        MovieMediaFilesPanel.this.mediaFileEventList.getReadWriteLock().writeLock().lock();
                        MovieMediaFilesPanel.this.mediaFileEventList.clear();
                        MovieMediaFilesPanel.this.mediaFileEventList.addAll(MovieMediaFilesPanel.this.movieSelectionModel.getSelectedMovie().getMediaFiles());
                    }
                    catch (Exception e) {
                    }
                    finally {
                        MovieMediaFilesPanel.this.mediaFileEventList.getReadWriteLock().writeLock().unlock();
                    }
                    try {
                        MovieMediaFilesPanel.this.panelMediaFiles.adjustColumns();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        };
        this.movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.dateAdded.date");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedMovie.dateAdded.day");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_2, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedMovie.dateAddedAsString");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_3, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedMovie.path");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_13, (Object)this.lblMoviePath, (Property)jLabelBeanProperty);
        autoBinding_19.bind();
    }
}

