/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCServerException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ResponseParser {
    private static final String FAULT_CODE = "faultCode";
    private static final String FAULT_STRING = "faultString";

    ResponseParser() {
    }

    public Object parse(InputStream response) throws XMLRPCException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document dom = builder.parse(response);
            Element e = dom.getDocumentElement();
            if (!e.getNodeName().equals("methodResponse")) {
                throw new XMLRPCException("MethodResponse root tag is missing.");
            }
            if ((e = XMLUtil.getOnlyChildElement(e.getChildNodes())).getNodeName().equals("params")) {
                if (!(e = XMLUtil.getOnlyChildElement(e.getChildNodes())).getNodeName().equals("param")) {
                    throw new XMLRPCException("The params tag must contain a param tag.");
                }
                return this.getReturnValueFromElement(e);
            }
            if (e.getNodeName().equals("fault")) {
                Map o = (Map)this.getReturnValueFromElement(e);
                throw new XMLRPCServerException((String)o.get(FAULT_STRING), (Integer)o.get(FAULT_CODE));
            }
            throw new XMLRPCException("The methodResponse tag must contain a fault or params tag.");
        }
        catch (Exception ex) {
            if (ex instanceof XMLRPCServerException) {
                throw (XMLRPCServerException)ex;
            }
            throw new XMLRPCException("Error getting result from server.", ex);
        }
    }

    private Object getReturnValueFromElement(Element element) throws XMLRPCException {
        element = XMLUtil.getOnlyChildElement(element.getChildNodes());
        return SerializerHandler.getDefault().deserialize(element);
    }
}

