/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.discovery;

import java.net.URL;
import org.fourthline.cling.model.message.IncomingDatagramMessage;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.DeviceUSNHeader;
import org.fourthline.cling.model.message.header.InterfaceMacHeader;
import org.fourthline.cling.model.message.header.LocationHeader;
import org.fourthline.cling.model.message.header.MaxAgeHeader;
import org.fourthline.cling.model.message.header.ServiceUSNHeader;
import org.fourthline.cling.model.message.header.UDNHeader;
import org.fourthline.cling.model.message.header.USNRootDeviceHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.types.NamedDeviceType;
import org.fourthline.cling.model.types.NamedServiceType;
import org.fourthline.cling.model.types.UDN;

public class IncomingSearchResponse
extends IncomingDatagramMessage<UpnpResponse> {
    public IncomingSearchResponse(IncomingDatagramMessage<UpnpResponse> source) {
        super(source);
    }

    public boolean isSearchResponseMessage() {
        UpnpHeader st = this.getHeaders().getFirstHeader(UpnpHeader.Type.ST);
        UpnpHeader usn = this.getHeaders().getFirstHeader(UpnpHeader.Type.USN);
        UpnpHeader ext = this.getHeaders().getFirstHeader(UpnpHeader.Type.EXT);
        return st != null && st.getValue() != null && usn != null && usn.getValue() != null && ext != null;
    }

    public UDN getRootDeviceUDN() {
        UpnpHeader udnHeader = this.getHeaders().getFirstHeader(UpnpHeader.Type.USN, USNRootDeviceHeader.class);
        if (udnHeader != null) {
            return (UDN)udnHeader.getValue();
        }
        udnHeader = this.getHeaders().getFirstHeader(UpnpHeader.Type.USN, UDNHeader.class);
        if (udnHeader != null) {
            return (UDN)udnHeader.getValue();
        }
        DeviceUSNHeader deviceTypeHeader = this.getHeaders().getFirstHeader(UpnpHeader.Type.USN, DeviceUSNHeader.class);
        if (deviceTypeHeader != null) {
            return ((NamedDeviceType)deviceTypeHeader.getValue()).getUdn();
        }
        ServiceUSNHeader serviceTypeHeader = this.getHeaders().getFirstHeader(UpnpHeader.Type.USN, ServiceUSNHeader.class);
        if (serviceTypeHeader != null) {
            return ((NamedServiceType)serviceTypeHeader.getValue()).getUdn();
        }
        return null;
    }

    public URL getLocationURL() {
        LocationHeader header = this.getHeaders().getFirstHeader(UpnpHeader.Type.LOCATION, LocationHeader.class);
        if (header != null) {
            return (URL)header.getValue();
        }
        return null;
    }

    public Integer getMaxAge() {
        MaxAgeHeader header = this.getHeaders().getFirstHeader(UpnpHeader.Type.MAX_AGE, MaxAgeHeader.class);
        if (header != null) {
            return (Integer)header.getValue();
        }
        return null;
    }

    public byte[] getInterfaceMacHeader() {
        InterfaceMacHeader header = this.getHeaders().getFirstHeader(UpnpHeader.Type.EXT_IFACE_MAC, InterfaceMacHeader.class);
        if (header != null) {
            return (byte[])header.getValue();
        }
        return null;
    }
}

