/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import java.net.HttpURLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class CookieManager {
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE = "Cookie";
    private int flags;
    private Map<String, String> cookies = new ConcurrentHashMap<String, String>();

    public CookieManager(int flags) {
        this.flags = flags;
    }

    public void clearCookies() {
        this.cookies.clear();
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void readCookies(HttpURLConnection http) {
        if ((this.flags & 4) == 0) {
            return;
        }
        for (int i = 0; i < http.getHeaderFields().size(); ++i) {
            String cookie;
            String[] split;
            String key = http.getHeaderFieldKey(i);
            if (key == null || !SET_COOKIE.toLowerCase().equals(key.toLowerCase()) || (split = (cookie = http.getHeaderField(i).split(";")[0]).split("=")).length < 2) continue;
            this.cookies.put(split[0], split[1]);
        }
    }

    public void setCookies(HttpURLConnection http) {
        if ((this.flags & 4) == 0) {
            return;
        }
        String concat = "";
        for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
            concat = concat + cookie.getKey() + "=" + cookie.getValue() + "; ";
        }
        http.setRequestProperty(COOKIE, concat);
    }
}

