/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEditorDialog;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEpisodeEditorDialog;

public class TvShowEditAction
extends AbstractAction {
    private static final long serialVersionUID = -3911290901017607679L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowEditAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("tvshow.edit"));
        }
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.edit"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        for (Object obj : selectedObjects) {
            TvShowEpisode tvShowEpisode;
            TvShow tvShow;
            TmmDialog editor;
            if (obj instanceof TvShow && !((TvShowEditorDialog)(editor = new TvShowEditorDialog(tvShow = (TvShow)obj, selectedObjects.size() > 1))).showDialog()) break;
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                ImageLabel imageLabel = new ImageLabel();
                ImageChooserDialog dialog = new ImageChooserDialog(season.getTvShow().getIds(), ImageChooserDialog.ImageType.SEASON, TvShowList.getInstance().getAvailableArtworkScrapers(), imageLabel, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
                    season.setPosterUrl(imageLabel.getImageUrl());
                    season.getTvShow().downloadSeasonPoster(season.getSeason());
                }
            }
            if (!(obj instanceof TvShowEpisode) || ((TvShowEpisodeEditorDialog)(editor = new TvShowEpisodeEditorDialog(tvShowEpisode = (TvShowEpisode)obj, selectedObjects.size() > 1))).showDialog()) continue;
            break;
        }
    }
}

