/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.ui.UTF8Control;

public class MovieMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieMissingArtworkDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToScrape;

    public MovieMissingArtworkDownloadTask(List<Movie> moviesToScrape) {
        super(BUNDLE.getString("task.missingartwork"));
        this.moviesToScrape = moviesToScrape;
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing artwork");
        this.initThreadPool(3, "scrapeMissingMovieArtwork");
        this.start();
        for (int i = 0; i < this.moviesToScrape.size(); ++i) {
            Movie movie = this.moviesToScrape.get(i);
            if (!MovieArtworkHelper.hasMissingArtwork(movie)) continue;
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done getting missing artwork");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private MovieList movieList;
        private Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        @Override
        public void run() {
            try {
                this.movieList = MovieList.getInstance();
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
                options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                for (Map.Entry<String, Object> entry : this.movie.getIds().entrySet()) {
                    options.setId(entry.getKey(), entry.getValue().toString());
                }
                options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
                options.setFanartSize(MovieModuleManager.MOVIE_SETTINGS.getImageFanartSize());
                options.setPosterSize(MovieModuleManager.MOVIE_SETTINGS.getImagePosterSize());
                for (MediaScraper scraper : this.movieList.getDefaultArtworkScrapers()) {
                    IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(options));
                    }
                    catch (Exception e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "message.scrape.movieartworkfailed"));
                    }
                }
                if (!artwork.isEmpty()) {
                    MovieArtworkHelper.downloadMissingArtwork(this.movie, artwork);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

