/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TreePopupListener;
import org.tinymediamanager.ui.TreeUI;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.RequestFocusAction;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.JSplitButton;
import org.tinymediamanager.ui.components.ZebraJTree;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeInformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowExtendedMatcher;
import org.tinymediamanager.ui.tvshows.TvShowExtendedSearchPanel;
import org.tinymediamanager.ui.tvshows.TvShowInformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowRootTreeNode;
import org.tinymediamanager.ui.tvshows.TvShowSeasonInformationPanel;
import org.tinymediamanager.ui.tvshows.TvShowSeasonSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowTreeCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowTreeModel;
import org.tinymediamanager.ui.tvshows.actions.DebugDumpShow;
import org.tinymediamanager.ui.tvshows.actions.TvShowBulkEditAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeSeasonPosterAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeToAiredOrderAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeToDvdOrderAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowClearImageCacheAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDeleteAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDownloadMissingArtworkAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowEditAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowExportAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowMediaInformationAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRemoveAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRenameAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRewriteEpisodeNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRewriteNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeEpisodesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeNewItemsAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSelectedScrapeAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSetWatchedFlagAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSingleScrapeAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSubtitleDownloadAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSubtitleSearchAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncSelectedTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncWatchedTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateDatasourcesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateSingleDatasourceAction;

public class TvShowPanel
extends JPanel {
    private static final long serialVersionUID = -1923811385292825136L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    TvShowSelectionModel tvShowSelectionModel;
    TvShowSeasonSelectionModel tvShowSeasonSelectionModel;
    TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel;
    private TvShowTreeModel treeModel;
    private TvShowList tvShowList = TvShowList.getInstance();
    private JTree tree;
    private JPanel panelRight;
    private JMenu menu;
    private JLabel lblTvShows;
    private JLabel lblEpisodes;
    private final Action actionUpdateDatasources = new TvShowUpdateDatasourcesAction(false);
    private final Action actionUpdateDatasources2 = new TvShowUpdateDatasourcesAction(true);
    private final Action actionUpdateTvShow = new TvShowUpdateAction();
    private final Action actionScrape = new TvShowSingleScrapeAction(false);
    private final Action actionScrape2 = new TvShowSingleScrapeAction(true);
    private final Action actionScrapeSelected = new TvShowSelectedScrapeAction();
    private final Action actionScrapeNewItems = new TvShowScrapeNewItemsAction();
    private final Action actionEdit = new TvShowEditAction(false);
    private final Action actionEdit2 = new TvShowEditAction(true);
    private final Action actionRemove2 = new TvShowRemoveAction(true);
    private final Action actionDelete2 = new TvShowDeleteAction(true);
    private final Action actionChangeSeasonPoster2 = new TvShowChangeSeasonPosterAction(true);
    private final Action actionBatchEdit = new TvShowBulkEditAction();
    private final Action actionSetWatchedFlag = new TvShowSetWatchedFlagAction();
    private final Action actionScrapeEpisodes = new TvShowScrapeEpisodesAction(true);
    private final Action actionScrapeEpisodes2 = new TvShowScrapeEpisodesAction(false);
    private final Action actionRewriteTvShowNfo = new TvShowRewriteNfoAction();
    private final Action actionRewriteTvShowEpisodeNfo = new TvShowRewriteEpisodeNfoAction();
    private final Action actionRename = new TvShowRenameAction(true);
    private final Action actionRenameIcon = new TvShowRenameAction(false);
    private final Action actionMediaInformation = new TvShowMediaInformationAction(false);
    private final Action actionMediaInformation2 = new TvShowMediaInformationAction(true);
    private final Action actionClearImageCache = new TvShowClearImageCacheAction();
    private final Action actionExport = new TvShowExportAction();
    private final Action actionSyncTrakt = new TvShowSyncTraktTvAction();
    private final Action actionSyncWatchedTrakt = new TvShowSyncWatchedTraktTvAction();
    private final Action actionSyncSelectedTrakt = new TvShowSyncSelectedTraktTvAction();
    private final Action actionChangeToDvdOrder = new TvShowChangeToDvdOrderAction();
    private final Action actionChangeToAiredOrder = new TvShowChangeToAiredOrderAction();
    private final Action actionDownloadSubtitles = new TvShowSubtitleDownloadAction();
    private final Action actionDownloadMissingArtwork = new TvShowDownloadMissingArtworkAction();
    private final Action actionSearchAndDownloadSubtitles = new TvShowSubtitleSearchAction();
    private final Action debugDumpShow = new DebugDumpShow();
    private int width = 0;
    private JTextField textField;

    public TvShowPanel() {
        this.treeModel = new TvShowTreeModel(this.tvShowList.getTvShows());
        this.tvShowSeasonSelectionModel = new TvShowSeasonSelectionModel();
        this.tvShowEpisodeSelectionModel = new TvShowEpisodeSelectionModel();
        this.menu = new JMenu(BUNDLE.getString("tmm.tvshows"));
        JFrame mainFrame = MainWindow.getFrame();
        JMenuBar menuBar = mainFrame.getJMenuBar();
        menuBar.add(this.menu);
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"850px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        this.add((Component)splitPane, "2, 2, fill, fill");
        JPanel panelTvShowTree = new JPanel();
        splitPane.setLeftComponent(panelTvShowTree);
        panelTvShowTree.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"3px:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.textField = EnhancedTextField.createSearchTextField();
        panelTvShowTree.add((Component)this.textField, "4, 1, right, bottom");
        this.textField.setColumns(12);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.applyFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.applyFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.applyFilter();
            }

            public void applyFilter() {
                TvShowTreeModel filteredModel = (TvShowTreeModel)TvShowPanel.this.tree.getModel();
                if (StringUtils.isNotBlank((CharSequence)TvShowPanel.this.textField.getText())) {
                    filteredModel.setFilter(TvShowExtendedMatcher.SearchOptions.TEXT, TvShowPanel.this.textField.getText());
                } else {
                    filteredModel.removeFilter(TvShowExtendedMatcher.SearchOptions.TEXT);
                }
                filteredModel.filter(TvShowPanel.this.tree);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(70, 128), "search");
        this.getActionMap().put("search", new RequestFocusAction(this.textField));
        final JToggleButton btnFilter = new JToggleButton(IconManager.FILTER);
        btnFilter.setToolTipText(BUNDLE.getString("movieextendedsearch.options"));
        panelTvShowTree.add((Component)btnFilter, "6, 1, default, bottom");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        panelTvShowTree.add((Component)scrollPane, "2, 3, 5, 1, fill, fill");
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        toolBar.setOpaque(false);
        panelTvShowTree.add((Component)toolBar, "2, 1");
        final JSplitButton buttonUpdateDatasource = new JSplitButton(IconManager.REFRESH);
        buttonUpdateDatasource.setText("   ");
        buttonUpdateDatasource.setHorizontalAlignment(2);
        buttonUpdateDatasource.setSplitWidth(18);
        buttonUpdateDatasource.setToolTipText(BUNDLE.getString("update.datasource"));
        buttonUpdateDatasource.addSplitButtonActionListener(new JSplitButton.SplitButtonActionListener(){

            @Override
            public void buttonClicked(ActionEvent e) {
                TvShowPanel.this.actionUpdateDatasources.actionPerformed(e);
            }

            @Override
            public void splitButtonClicked(ActionEvent e) {
                buttonUpdateDatasource.getPopupMenu().removeAll();
                buttonUpdateDatasource.getPopupMenu().add(new JMenuItem(TvShowPanel.this.actionUpdateDatasources2));
                buttonUpdateDatasource.getPopupMenu().addSeparator();
                for (String ds : TvShowModuleManager.SETTINGS.getTvShowDataSource()) {
                    buttonUpdateDatasource.getPopupMenu().add(new JMenuItem(new TvShowUpdateSingleDatasourceAction(ds)));
                }
                buttonUpdateDatasource.getPopupMenu().addSeparator();
                buttonUpdateDatasource.getPopupMenu().add(new JMenuItem(TvShowPanel.this.actionUpdateTvShow));
                buttonUpdateDatasource.getPopupMenu().pack();
            }
        });
        JPopupMenu popup = new JPopupMenu("popup");
        buttonUpdateDatasource.setPopupMenu(popup);
        toolBar.add(buttonUpdateDatasource);
        JSplitButton buttonScrape = new JSplitButton(IconManager.SEARCH);
        buttonScrape.setText("   ");
        buttonScrape.setHorizontalAlignment(2);
        buttonScrape.setSplitWidth(18);
        buttonScrape.setToolTipText(BUNDLE.getString("tvshow.scrape.selected"));
        buttonScrape.addSplitButtonActionListener(new JSplitButton.SplitButtonActionListener(){

            @Override
            public void buttonClicked(ActionEvent e) {
                TvShowPanel.this.actionScrape.actionPerformed(e);
            }

            @Override
            public void splitButtonClicked(ActionEvent e) {
            }
        });
        popup = new JPopupMenu("popup");
        JMenuItem item = new JMenuItem(this.actionScrape2);
        popup.add(item);
        item = new JMenuItem(this.actionScrapeSelected);
        popup.add(item);
        item = new JMenuItem(this.actionScrapeNewItems);
        popup.add(item);
        buttonScrape.setPopupMenu(popup);
        toolBar.add(buttonScrape);
        toolBar.add(this.actionEdit);
        JButton btnRen = new JButton();
        btnRen.setAction(this.actionRenameIcon);
        toolBar.add(btnRen);
        JButton btnMediaInformation = new JButton();
        btnMediaInformation.setAction(this.actionMediaInformation);
        toolBar.add(btnMediaInformation);
        this.tree = new ZebraJTree(this.treeModel){
            private static final long serialVersionUID = 2422163883324014637L;

            @Override
            public void paintComponent(Graphics g) {
                TvShowPanel.this.width = this.getWidth();
                super.paintComponent(g);
            }
        };
        this.tvShowSelectionModel = new TvShowSelectionModel(this.tree);
        TreeUI ui = new TreeUI(){

            @Override
            protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                bounds.width = TvShowPanel.this.width - bounds.x;
                super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
        };
        this.tree.setUI((javax.swing.plaf.TreeUI)((Object)ui));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new TvShowTreeCellRenderer());
        this.tree.setRowHeight(0);
        scrollPane.setViewportView(this.tree);
        JPanel panelHeader = new JPanel(){
            private static final long serialVersionUID = -6914183798172482157L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                JTattooUtilities.fillHorGradient((Graphics)g, (Color[])AbstractLookAndFeel.getTheme().getColHeaderColors(), (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
            }
        };
        scrollPane.setColumnHeaderView(panelHeader);
        panelHeader.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px"), ColumnSpec.decode((String)"center:20px")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblTvShowsColumn = new JLabel(BUNDLE.getString("metatag.tvshow"));
        lblTvShowsColumn.setHorizontalAlignment(0);
        panelHeader.add((Component)lblTvShowsColumn, "2, 1");
        JLabel lblNfoColumn = new JLabel("");
        lblNfoColumn.setHorizontalAlignment(0);
        lblNfoColumn.setIcon(IconManager.INFO);
        lblNfoColumn.setToolTipText(BUNDLE.getString("metatag.nfo"));
        panelHeader.add((Component)lblNfoColumn, "4, 1");
        JLabel lblImageColumn = new JLabel("");
        lblImageColumn.setHorizontalAlignment(0);
        lblImageColumn.setIcon(IconManager.IMAGE);
        lblImageColumn.setToolTipText(BUNDLE.getString("metatag.images"));
        panelHeader.add((Component)lblImageColumn, "5, 1");
        JLabel lblSubtitleColumn = new JLabel("");
        lblSubtitleColumn.setHorizontalAlignment(0);
        lblSubtitleColumn.setIcon(IconManager.SUBTITLE);
        lblSubtitleColumn.setToolTipText(BUNDLE.getString("metatag.subtitles"));
        panelHeader.add((Component)lblSubtitleColumn, "6, 1");
        JPanel panel = new JPanel();
        panelTvShowTree.add((Component)panel, "2, 5, 3, 1, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblTvShowsT = new JLabel(BUNDLE.getString("metatag.tvshows") + ":");
        panel.add((Component)lblTvShowsT, "1, 2, fill, fill");
        this.lblTvShows = new JLabel("");
        panel.add((Component)this.lblTvShows, "3, 2");
        JLabel labelSlash = new JLabel("/");
        panel.add((Component)labelSlash, "5, 2");
        JLabel lblEpisodesT = new JLabel(BUNDLE.getString("metatag.episodes") + ":");
        panel.add((Component)lblEpisodesT, "7, 2");
        this.lblEpisodes = new JLabel("");
        panel.add((Component)this.lblEpisodes, "9, 2");
        JLayeredPane layeredPaneRight = new JLayeredPane();
        layeredPaneRight.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default"), ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"default"), RowSpec.decode((String)"default:grow")}));
        this.panelRight = new JPanel();
        layeredPaneRight.add((Component)this.panelRight, "1, 1, 2, 2, fill, fill");
        layeredPaneRight.setLayer(this.panelRight, 0);
        final TvShowExtendedSearchPanel panelExtendedSearch = new TvShowExtendedSearchPanel(this.treeModel, this.tree);
        panelExtendedSearch.setVisible(false);
        btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (panelExtendedSearch.isVisible()) {
                    panelExtendedSearch.setVisible(false);
                } else {
                    panelExtendedSearch.setVisible(true);
                }
            }
        });
        this.tree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("filterChanged".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        btnFilter.setIcon(IconManager.FILTER_ACTIVE);
                        btnFilter.setToolTipText(BUNDLE.getString("movieextendedsearch.options.active"));
                    } else {
                        btnFilter.setIcon(IconManager.FILTER);
                        btnFilter.setToolTipText(BUNDLE.getString("movieextendedsearch.options"));
                    }
                }
            }
        });
        layeredPaneRight.add((Component)panelExtendedSearch, "1, 1, fill, fill");
        layeredPaneRight.setLayer(panelExtendedSearch, 1);
        splitPane.setRightComponent(layeredPaneRight);
        this.panelRight.setLayout(new CardLayout(0, 0));
        TvShowInformationPanel panelTvShow = new TvShowInformationPanel(this.tvShowSelectionModel);
        this.panelRight.add((Component)panelTvShow, "tvShow");
        TvShowSeasonInformationPanel panelTvShowSeason = new TvShowSeasonInformationPanel(this.tvShowSeasonSelectionModel);
        this.panelRight.add((Component)panelTvShowSeason, "tvShowSeason");
        TvShowEpisodeInformationPanel panelTvShowEpisode = new TvShowEpisodeInformationPanel(this.tvShowEpisodeSelectionModel);
        this.panelRight.add((Component)panelTvShowEpisode, "tvShowEpisode");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)TvShowPanel.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    CardLayout cl;
                    if (node.getUserObject() instanceof TvShow) {
                        TvShow tvShow = (TvShow)node.getUserObject();
                        TvShowPanel.this.tvShowSelectionModel.setSelectedTvShow(tvShow);
                        cl = (CardLayout)TvShowPanel.this.panelRight.getLayout();
                        cl.show(TvShowPanel.this.panelRight, "tvShow");
                    }
                    if (node.getUserObject() instanceof TvShowSeason) {
                        TvShowSeason tvShowSeason = (TvShowSeason)node.getUserObject();
                        TvShowPanel.this.tvShowSeasonSelectionModel.setSelectedTvShowSeason(tvShowSeason);
                        cl = (CardLayout)TvShowPanel.this.panelRight.getLayout();
                        cl.show(TvShowPanel.this.panelRight, "tvShowSeason");
                    }
                    if (node.getUserObject() instanceof TvShowEpisode) {
                        TvShowEpisode tvShowEpisode = (TvShowEpisode)node.getUserObject();
                        TvShowPanel.this.tvShowEpisodeSelectionModel.setSelectedTvShowEpisode(tvShowEpisode);
                        cl = (CardLayout)TvShowPanel.this.panelRight.getLayout();
                        cl.show(TvShowPanel.this.panelRight, "tvShowEpisode");
                    }
                } else {
                    TvShowRootTreeNode root = (TvShowRootTreeNode)TvShowPanel.this.tree.getModel().getRoot();
                    if (root.getChildCount() == 0) {
                        TvShowPanel.this.tvShowSelectionModel.setSelectedTvShow(null);
                    }
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TvShowPanel.this.menu.setVisible(false);
                super.componentHidden(e);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                TvShowPanel.this.menu.setVisible(true);
                super.componentHidden(e);
            }
        });
        this.init();
        this.initDataBindings();
        if (this.tvShowList.getTvShows() != null && this.tvShowList.getTvShows().size() > 0) {
            DefaultMutableTreeNode firstLeaf = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getFirstChild();
            this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)firstLeaf.getParent()).getPath()));
            this.tree.setSelectionPath(new TreePath(firstLeaf.getPath()));
        }
    }

    private void init() {
        this.buildMenu();
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed() && e.getButton() == 1) {
                    TvShowPanel.this.actionEdit2.actionPerformed(new ActionEvent(e, 0, ""));
                }
            }
        };
        this.tree.addMouseListener(mouseListener);
    }

    private void buildMenu() {
        this.menu.setMnemonic(86);
        JMenuItem menuItem = this.menu.add(this.actionUpdateDatasources2);
        menuItem.setMnemonic(85);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(85, 3));
        this.menu.addSeparator();
        JMenu menuScrape = new JMenu(BUNDLE.getString("Button.scrape"));
        menuScrape.setMnemonic(83);
        menuItem = menuScrape.add(this.actionScrape2);
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        menuItem = menuScrape.add(this.actionScrapeSelected);
        menuItem.setMnemonic(70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        menuItem = menuScrape.add(this.actionScrapeNewItems);
        menuItem.setMnemonic(78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 3));
        this.menu.add(menuScrape);
        JMenu menuEdit = new JMenu(BUNDLE.getString("Button.edit"));
        menuEdit.setMnemonic(69);
        menuItem = menuEdit.add(this.actionEdit2);
        menuItem.setMnemonic(69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        menuItem = menuEdit.add(this.actionBatchEdit);
        menuItem.setMnemonic(66);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 3));
        menuItem = menuEdit.add(this.actionSetWatchedFlag);
        menuItem.setMnemonic(87);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        menuItem = menuEdit.add(this.actionChangeSeasonPoster2);
        menuItem.setMnemonic(83);
        menuEdit.add(this.actionChangeToDvdOrder);
        menuEdit.add(this.actionChangeToAiredOrder);
        this.menu.add(menuEdit);
        this.menu.add(this.actionRewriteTvShowNfo);
        this.menu.add(this.actionRewriteTvShowEpisodeNfo);
        menuItem = this.menu.add(this.actionRename);
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 3));
        menuItem = this.menu.add(this.actionMediaInformation2);
        menuItem.setMnemonic(77);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        menuItem = this.menu.add(this.actionExport);
        menuItem.setMnemonic(88);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 3));
        menuItem = this.menu.add(this.actionClearImageCache);
        menuItem.setMnemonic(67);
        this.menu.addSeparator();
        menuItem = this.menu.add(this.actionRemove2);
        menuItem.setAccelerator(KeyStroke.getKeyStroke('\u007f'));
        menuItem = this.menu.add(this.actionDelete2);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 1));
        this.menu.addSeparator();
        menuItem = this.menu.add(this.actionSyncTrakt);
        menuItem.setMnemonic(84);
        menuItem = this.menu.add(this.actionSyncWatchedTrakt);
        menuItem.setMnemonic(87);
        menuItem = this.menu.add(this.actionSyncSelectedTrakt);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.actionScrape2);
        popupMenu.add(this.actionScrapeSelected);
        popupMenu.add(this.actionScrapeEpisodes);
        popupMenu.add(this.actionScrapeEpisodes2);
        popupMenu.add(this.actionScrapeNewItems);
        popupMenu.addSeparator();
        popupMenu.add(this.actionUpdateTvShow);
        popupMenu.addSeparator();
        popupMenu.add(this.actionEdit2);
        popupMenu.add(this.actionChangeSeasonPoster2);
        popupMenu.add(this.actionBatchEdit);
        popupMenu.add(this.actionSetWatchedFlag);
        popupMenu.add(this.actionChangeToDvdOrder);
        popupMenu.add(this.actionChangeToAiredOrder);
        popupMenu.add(this.actionRewriteTvShowNfo);
        popupMenu.add(this.actionRewriteTvShowEpisodeNfo);
        popupMenu.add(this.actionRename);
        popupMenu.add(this.actionMediaInformation2);
        popupMenu.add(this.actionExport);
        popupMenu.add(this.actionClearImageCache);
        popupMenu.addSeparator();
        popupMenu.add(this.actionDownloadMissingArtwork);
        popupMenu.add(this.actionDownloadSubtitles);
        popupMenu.add(this.actionSearchAndDownloadSubtitles);
        popupMenu.addSeparator();
        popupMenu.add(this.actionSyncTrakt);
        popupMenu.add(this.actionSyncWatchedTrakt);
        popupMenu.add(this.actionSyncSelectedTrakt);
        popupMenu.addSeparator();
        popupMenu.add(this.actionRemove2);
        popupMenu.add(this.actionDelete2);
        popupMenu.addSeparator();
        popupMenu.add(new ExpandAllAction());
        popupMenu.add(new CollapseAllAction());
        if (Globals.isDebug()) {
            JMenu menuDebug = new JMenu("Debug");
            menuDebug.add(this.debugDumpShow);
            popupMenu.addSeparator();
            popupMenu.add(menuDebug);
        }
        TreePopupListener popupListener = new TreePopupListener(popupMenu, this.tree);
        this.tree.addMouseListener(popupListener);
    }

    protected void initDataBindings() {
        BeanProperty tvShowListBeanProperty = BeanProperty.create((String)"tvShowCount");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowList, (Property)tvShowListBeanProperty, (Object)this.lblTvShows, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowListBeanProperty_1 = BeanProperty.create((String)"episodeCount");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowList, (Property)tvShowListBeanProperty_1, (Object)this.lblEpisodes, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }

    private class ExpandAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 6191727607109012198L;

        public ExpandAllAction() {
            this.putValue("Name", BUNDLE.getString("tree.expandall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            do {
                TvShowPanel.this.tree.expandRow(i++);
            } while (i < TvShowPanel.this.tree.getRowCount());
        }
    }

    private class CollapseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1444530142931061317L;

        public CollapseAllAction() {
            this.putValue("Name", BUNDLE.getString("tree.collapseall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = TvShowPanel.this.tree.getRowCount() - 1; i >= 0; --i) {
                TvShowPanel.this.tree.collapseRow(i);
            }
        }
    }
}

