/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.MediaScraperComboBox;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieChooserModel;
import org.tinymediamanager.ui.movies.MovieScraperMetadataPanel;

public class MovieChooserDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = -3104541519073924724L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieChooserDialog.class);
    private MovieList movieList = MovieList.getInstance();
    private Movie movieToScrape;
    private List<MovieChooserModel> moviesFound = ObservableCollections.observableList(new ArrayList());
    private MovieScraperMetadataConfig scraperMetadataConfig = new MovieScraperMetadataConfig();
    private MediaScraper mediaScraper;
    private List<MediaScraper> artworkScrapers;
    private List<MediaScraper> trailerScrapers;
    private boolean continueQueue = true;
    private SearchTask activeSearchTask;
    private final JPanel contentPanel = new JPanel();
    private JTextField textFieldSearchString;
    private MediaScraperComboBox cbScraper;
    private JTable table;
    private JLabel lblMovieName;
    private JTextPane tpMovieDescription;
    private ImageLabel lblMoviePoster;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JLabel lblTagline;
    private JButton okButton;
    private JLabel lblPath;
    private JComboBox cbLanguage;
    private JTableBinding<MovieChooserModel, List<MovieChooserModel>, JTable> jTableBinding;
    private AutoBinding<JTable, String, JLabel, String> autoBinding;
    private AutoBinding<JTable, String, JTextPane, String> autoBinding_1;
    private AutoBinding<JTable, String, ImageLabel, String> autoBinding_2;
    private AutoBinding<JTable, String, JLabel, String> autoBinding_3;

    public MovieChooserDialog(Movie movie, boolean inQueue) {
        super(BUNDLE.getString("moviechooser.search"), "movieChooser");
        this.setBounds(5, 5, 960, 642);
        MovieScraperMetadataConfig settings = Globals.settings.getMovieScraperMetadataConfig();
        this.mediaScraper = this.movieList.getDefaultMediaScraper();
        this.artworkScrapers = this.movieList.getDefaultArtworkScrapers();
        this.trailerScrapers = this.movieList.getDefaultTrailerScrapers();
        this.scraperMetadataConfig.setTitle(settings.isTitle());
        this.scraperMetadataConfig.setOriginalTitle(settings.isOriginalTitle());
        this.scraperMetadataConfig.setTagline(settings.isTagline());
        this.scraperMetadataConfig.setPlot(settings.isPlot());
        this.scraperMetadataConfig.setRating(settings.isRating());
        this.scraperMetadataConfig.setRuntime(settings.isRuntime());
        this.scraperMetadataConfig.setYear(settings.isYear());
        this.scraperMetadataConfig.setCertification(settings.isCertification());
        this.scraperMetadataConfig.setCast(settings.isCast());
        this.scraperMetadataConfig.setGenres(settings.isGenres());
        this.scraperMetadataConfig.setArtwork(settings.isArtwork());
        this.scraperMetadataConfig.setTrailer(settings.isTrailer());
        this.scraperMetadataConfig.setCollection(settings.isCollection());
        this.scraperMetadataConfig.setTags(settings.isTags());
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"800px:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"fill:300px:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelPath = new JPanel();
        this.contentPanel.add((Component)panelPath, "2, 2, left, default");
        panelPath.setLayout(new FlowLayout(1, 5, 0));
        this.lblPath = new JLabel("");
        panelPath.add(this.lblPath);
        JButton btnPlay = new JButton(IconManager.PLAY_SMALL);
        btnPlay.setFocusable(false);
        btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaFile mf = MovieChooserDialog.this.movieToScrape.getMediaFiles(MediaFileType.VIDEO).get(0);
                try {
                    TmmUIHelper.openFile(mf.getFileAsPath());
                }
                catch (Exception ex) {
                    LOGGER.error("open file", (Object)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
        panelPath.add(btnPlay);
        JPanel panelSearchField = new JPanel();
        this.contentPanel.add((Component)panelSearchField, "2, 4, fill, fill");
        panelSearchField.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"right:max(100px;default)")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblScraper = new JLabel(BUNDLE.getString("scraper"));
        panelSearchField.add((Component)lblScraper, "2, 1, right, default");
        this.cbScraper = new MediaScraperComboBox(this.movieList.getAvailableMediaScrapers());
        MediaScraper defaultScraper = this.movieList.getDefaultMediaScraper();
        this.cbScraper.setSelectedItem(defaultScraper);
        this.cbScraper.setAction(new ChangeScraperAction());
        panelSearchField.add((Component)this.cbScraper, "4, 1, fill, default");
        this.textFieldSearchString = new JTextField();
        panelSearchField.add((Component)this.textFieldSearchString, "6, 1, fill, default");
        this.textFieldSearchString.setColumns(10);
        JButton btnSearch = new JButton(BUNDLE.getString("Button.search"));
        panelSearchField.add((Component)btnSearch, "8, 1, fill, default");
        btnSearch.setIcon(IconManager.SEARCH);
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MovieChooserDialog.this.searchMovie(MovieChooserDialog.this.textFieldSearchString.getText(), null);
            }
        });
        this.getRootPane().setDefaultButton(btnSearch);
        JLabel lblLanguage = new JLabel(BUNDLE.getString("metatag.language"));
        panelSearchField.add((Component)lblLanguage, "2, 3, right, default");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.values());
        this.cbLanguage.setSelectedItem(MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage());
        this.cbLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieChooserDialog.this.searchMovie(MovieChooserDialog.this.textFieldSearchString.getText(), null);
            }
        });
        panelSearchField.add((Component)this.cbLanguage, "4, 3, fill, default");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        splitPane.setContinuousLayout(true);
        this.contentPanel.add((Component)splitPane, "2, 6, fill, fill");
        JPanel panelSearchResults = new JPanel();
        splitPane.setLeftComponent(panelSearchResults);
        panelSearchResults.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:260px:grow")}));
        JScrollPane scrollPane = new JScrollPane();
        panelSearchResults.add((Component)scrollPane, "2, 2, fill, fill");
        this.table = new JTable();
        scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.setBorder(new LineBorder(new Color(0, 0, 0)));
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    selectedRow = MovieChooserDialog.this.table.convertRowIndexToModel(selectedRow);
                    try {
                        MovieChooserModel model = (MovieChooserModel)MovieChooserDialog.this.moviesFound.get(selectedRow);
                        if (model != MovieChooserModel.emptyResult && !model.isScraped()) {
                            ScrapeTask task = new ScrapeTask(model);
                            task.execute();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn(ex.getMessage());
                    }
                }
            }
        });
        JPanel panelSearchDetail = new JPanel();
        splitPane.setRightComponent(panelSearchDetail);
        panelSearchDetail.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"350px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"20px"), FormFactory.PARAGRAPH_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow")}));
        this.lblMovieName = new JLabel("");
        TmmFontHelper.changeFont(this.lblMovieName, 1.167, 1);
        panelSearchDetail.add((Component)this.lblMovieName, "2, 1, default, top");
        this.lblTagline = new JLabel("");
        panelSearchDetail.add((Component)this.lblTagline, "2, 2, default, top");
        JPanel panel = new JPanel();
        panelSearchDetail.add((Component)panel, "2, 4, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"150px"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow")}, new RowSpec[]{RowSpec.decode((String)"240px")}));
        this.lblMoviePoster = new ImageLabel(false);
        panel.add((Component)this.lblMoviePoster, "1, 1, fill, fill");
        this.lblMoviePoster.setAlternativeText("");
        JScrollPane scrollPane2 = new JScrollPane();
        panel.add((Component)scrollPane2, "3, 1, fill, fill");
        scrollPane2.setBorder(null);
        this.tpMovieDescription = new JTextPane();
        this.tpMovieDescription.setOpaque(false);
        this.tpMovieDescription.setEditable(false);
        scrollPane2.setViewportView(this.tpMovieDescription);
        JLabel lblScrapeFollowingItems = new JLabel(BUNDLE.getString("chooser.scrape"));
        this.contentPanel.add((Component)lblScrapeFollowingItems, "2, 8");
        MovieScraperMetadataPanel panelScraperMetadataSetting = new MovieScraperMetadataPanel(this.scraperMetadataConfig);
        this.contentPanel.add((Component)panelScraperMetadataSetting, "2, 9, fill, fill");
        JPanel bottomPane = new JPanel();
        this.contentPanel.add((Component)bottomPane, "2, 11");
        bottomPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"max(82dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC}));
        this.progressBar = new JProgressBar();
        bottomPane.add((Component)this.progressBar, "2, 2");
        this.lblProgressAction = new JLabel("");
        bottomPane.add((Component)this.lblProgressAction, "4, 2, left, default");
        JPanel buttonPane = new JPanel();
        bottomPane.add((Component)buttonPane, "5, 2, fill, fill");
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        this.okButton = new JButton(BUNDLE.getString("Button.ok"));
        this.okButton.setIcon(IconManager.APPLY);
        buttonPane.add(this.okButton);
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        cancelButton.setIcon(IconManager.CANCEL);
        buttonPane.add(cancelButton);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        if (inQueue) {
            JButton abortButton = new JButton(BUNDLE.getString("Button.abortqueue"));
            abortButton.setIcon(IconManager.PROCESS_STOP);
            buttonPane.add(abortButton);
            abortButton.setActionCommand("Abort");
            abortButton.addActionListener(this);
        }
        this.initDataBindings();
        this.movieToScrape = movie;
        this.progressBar.setVisible(false);
        this.table.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("chooser.searchresult"));
        this.textFieldSearchString.setText(this.movieToScrape.getTitle());
        this.searchMovie(this.textFieldSearchString.getText(), this.movieToScrape);
        this.lblPath.setText(this.movieToScrape.getPath() + File.separatorChar + this.movieToScrape.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MovieChooserModel model;
        int row;
        if ("OK".equals(e.getActionCommand()) && (row = this.table.getSelectedRow()) >= 0 && (model = this.moviesFound.get(row)) != MovieChooserModel.emptyResult) {
            if (!model.isScraped()) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieChooser", "message.scrape.threadcrashed"));
                return;
            }
            MediaMetadata md = model.getMetadata();
            if (!MovieModuleManager.MOVIE_SETTINGS.isScrapeBestImage()) {
                md.clearMediaArt();
            }
            this.movieToScrape.setMetadata(md, this.scraperMetadataConfig);
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.scraperMetadataConfig.isArtwork()) {
                if (!MovieModuleManager.MOVIE_SETTINGS.isScrapeBestImage()) {
                    ImageLabel lblImage = new ImageLabel();
                    ImageChooserDialog dialog = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.POSTER, this.artworkScrapers, lblImage, null, null, MediaType.MOVIE);
                    dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                    dialog.setVisible(true);
                    this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.POSTER);
                    this.movieToScrape.downloadArtwork(MediaFileType.POSTER);
                    lblImage = new ImageLabel();
                    ArrayList<String> extrathumbs = new ArrayList<String>();
                    ArrayList<String> extrafanarts = new ArrayList<String>();
                    ImageChooserDialog dialog2 = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.FANART, this.artworkScrapers, lblImage, extrathumbs, extrafanarts, MediaType.MOVIE);
                    dialog2.setVisible(true);
                    this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.FANART);
                    this.movieToScrape.downloadArtwork(MediaFileType.FANART);
                    this.movieToScrape.setExtraThumbs(extrathumbs);
                    this.movieToScrape.setExtraFanarts(extrafanarts);
                    if (extrafanarts.size() > 0) {
                        this.movieToScrape.downloadArtwork(MediaFileType.EXTRAFANART);
                    }
                    if (extrathumbs.size() > 0) {
                        this.movieToScrape.downloadArtwork(MediaFileType.EXTRATHUMB);
                    }
                    if (MovieModuleManager.MOVIE_SETTINGS.isImageBanner()) {
                        lblImage = new ImageLabel();
                        dialog = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.BANNER, this.artworkScrapers, lblImage, null, null, MediaType.MOVIE);
                        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                        dialog.setVisible(true);
                        this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.BANNER);
                        this.movieToScrape.downloadArtwork(MediaFileType.BANNER);
                    }
                    if (MovieModuleManager.MOVIE_SETTINGS.isImageLogo()) {
                        lblImage = new ImageLabel();
                        dialog = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.LOGO, this.artworkScrapers, lblImage, null, null, MediaType.MOVIE);
                        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                        dialog.setVisible(true);
                        this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.LOGO);
                        this.movieToScrape.downloadArtwork(MediaFileType.LOGO);
                    }
                    if (MovieModuleManager.MOVIE_SETTINGS.isImageLogo()) {
                        lblImage = new ImageLabel();
                        dialog = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.CLEARLOGO, this.artworkScrapers, lblImage, null, null, MediaType.MOVIE);
                        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                        dialog.setVisible(true);
                        this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.CLEARLOGO);
                        this.movieToScrape.downloadArtwork(MediaFileType.CLEARLOGO);
                    }
                    if (MovieModuleManager.MOVIE_SETTINGS.isImageClearart()) {
                        lblImage = new ImageLabel();
                        dialog = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.CLEARART, this.artworkScrapers, lblImage, null, null, MediaType.MOVIE);
                        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                        dialog.setVisible(true);
                        this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.CLEARART);
                        this.movieToScrape.downloadArtwork(MediaFileType.CLEARART);
                    }
                    if (MovieModuleManager.MOVIE_SETTINGS.isImageDiscart()) {
                        lblImage = new ImageLabel();
                        dialog = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.DISC, this.artworkScrapers, lblImage, null, null, MediaType.MOVIE);
                        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                        dialog.setVisible(true);
                        this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.DISCART);
                        this.movieToScrape.downloadArtwork(MediaFileType.DISCART);
                    }
                    if (MovieModuleManager.MOVIE_SETTINGS.isImageThumb()) {
                        lblImage = new ImageLabel();
                        dialog = new ImageChooserDialog(this.movieToScrape.getIds(), ImageChooserDialog.ImageType.THUMB, this.artworkScrapers, lblImage, null, null, MediaType.MOVIE);
                        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                        dialog.setVisible(true);
                        this.movieToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.THUMB);
                        this.movieToScrape.downloadArtwork(MediaFileType.THUMB);
                    }
                } else {
                    model.startArtworkScrapeTask(this.movieToScrape, this.scraperMetadataConfig);
                }
            }
            if (this.scraperMetadataConfig.isTrailer()) {
                model.startTrailerScrapeTask(this.movieToScrape);
            }
            if (MovieModuleManager.MOVIE_SETTINGS.getSyncTrakt()) {
                SyncTraktTvTask task = new SyncTraktTvTask(Arrays.asList(this.movieToScrape), null);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setVisible(false);
        }
        if ("Cancel".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Abort".equals(e.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
    }

    private void searchMovie(String searchTerm, Movie movie) {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        this.activeSearchTask = new SearchTask(searchTerm, movie);
        this.activeSearchTask.execute();
    }

    private void startProgressBar(final String description) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MovieChooserDialog.this.lblProgressAction.setText(description);
                MovieChooserDialog.this.progressBar.setVisible(true);
                MovieChooserDialog.this.progressBar.setIndeterminate(true);
            }
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MovieChooserDialog.this.lblProgressAction.setText("");
                MovieChooserDialog.this.progressBar.setVisible(false);
                MovieChooserDialog.this.progressBar.setIndeterminate(false);
            }
        });
    }

    protected void initDataBindings() {
        this.jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.moviesFound, (JTable)this.table);
        BeanProperty movieChooserModelBeanProperty = BeanProperty.create((String)"combinedName");
        this.jTableBinding.addColumnBinding((Property)movieChooserModelBeanProperty).setEditable(false);
        this.jTableBinding.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.overview");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        this.autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.table, (Property)jTableBeanProperty_1, (Object)this.tpMovieDescription, (Property)jTextPaneBeanProperty);
        this.autoBinding_1.bind();
        BeanProperty jTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.posterUrl");
        BeanProperty imageLabelBeanProperty = BeanProperty.create((String)"imageUrl");
        this.autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.table, (Property)jTableBeanProperty_2, (Object)this.lblMoviePoster, (Property)imageLabelBeanProperty);
        this.autoBinding_2.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.tagline");
        BeanProperty jTextAreaBeanProperty = BeanProperty.create((String)"text");
        this.autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.table, (Property)jTableBeanProperty, (Object)this.lblTagline, (Property)jTextAreaBeanProperty);
        this.autoBinding.bind();
        BeanProperty jTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.combinedName");
        BeanProperty jTextAreaBeanProperty_1 = BeanProperty.create((String)"text");
        this.autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.table, (Property)jTableBeanProperty_3, (Object)this.lblMovieName, (Property)jTextAreaBeanProperty_1);
        this.autoBinding_3.bind();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void dispose() {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        super.dispose();
        this.jTableBinding.unbind();
        this.autoBinding.unbind();
        this.autoBinding_1.unbind();
        this.autoBinding_2.unbind();
        this.autoBinding_3.unbind();
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private MovieChooserModel model;

        public ScrapeTask(MovieChooserModel model) {
            this.model = model;
        }

        @Override
        public Void doInBackground() {
            MovieChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.scrapeing") + " " + this.model.getName());
            MovieChooserDialog.this.okButton.setEnabled(false);
            this.model.scrapeMetaData();
            MovieChooserDialog.this.okButton.setEnabled(true);
            return null;
        }

        @Override
        public void done() {
            MovieChooserDialog.this.stopProgressBar();
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private String searchTerm;
        private Movie movie;
        private List<MediaSearchResult> searchResult;
        private MediaLanguages language;
        boolean cancel = false;

        public SearchTask(String searchTerm, Movie movie) {
            this.searchTerm = searchTerm;
            this.movie = movie;
            this.language = (MediaLanguages)MovieChooserDialog.this.cbLanguage.getSelectedItem();
        }

        @Override
        public Void doInBackground() {
            MovieChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + this.searchTerm);
            this.searchResult = MovieChooserDialog.this.movieList.searchMovie(this.searchTerm, this.movie, MovieChooserDialog.this.mediaScraper, this.language);
            return null;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void done() {
            if (!this.cancel) {
                MovieChooserDialog.this.moviesFound.clear();
                if (this.searchResult == null || this.searchResult.size() == 0) {
                    MovieChooserDialog.this.moviesFound.add(MovieChooserModel.emptyResult);
                } else {
                    MediaScraper mpFromResult = null;
                    for (MediaSearchResult result : this.searchResult) {
                        if (mpFromResult == null) {
                            mpFromResult = MovieChooserDialog.this.movieList.getMediaScraperById(result.getProviderId());
                        }
                        MovieChooserDialog.this.moviesFound.add(new MovieChooserModel(mpFromResult, MovieChooserDialog.this.artworkScrapers, MovieChooserDialog.this.trailerScrapers, result, this.language));
                    }
                }
                if (MovieChooserDialog.this.moviesFound.size() == 1) {
                    MovieChooserDialog.this.table.setRowSelectionInterval(0, 0);
                }
            }
            MovieChooserDialog.this.stopProgressBar();
        }
    }

    private class ChangeScraperAction
    extends AbstractAction {
        private static final long serialVersionUID = -4365761222995534769L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieChooserDialog.this.mediaScraper = (MediaScraper)MovieChooserDialog.this.cbScraper.getSelectedItem();
            MovieChooserDialog.this.searchMovie(MovieChooserDialog.this.textFieldSearchString.getText(), MovieChooserDialog.this.movieToScrape);
        }
    }
}

