/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.tinymediamanager.ui.movies.actions.MovieEditAction;

public class MovieTableMouseListener
extends MouseAdapter {
    private JPopupMenu popup;
    private JTable table;

    MovieTableMouseListener(JPopupMenu popupMenu, JTable table) {
        this.popup = popupMenu;
        this.table = table;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1) {
            MovieEditAction editAction = new MovieEditAction(false);
            editAction.actionPerformed(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int[] selectedRows;
            boolean selected = false;
            int row = this.table.rowAtPoint(e.getPoint());
            for (int selectedRow : selectedRows = this.table.getSelectedRows()) {
                if (selectedRow != row) continue;
                selected = true;
            }
            if (!selected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

