/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class MovieScraperMetadataPanel
extends JPanel {
    private static final long serialVersionUID = 1053348917399322570L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieScraperMetadataConfig config;
    private JCheckBox chckbxTitle;
    private JCheckBox chckbxOriginalTitle;
    private JCheckBox chckbxTagline;
    private JCheckBox chckbxPlot;
    private JCheckBox chckbxRating;
    private JCheckBox chckbxRuntime;
    private JCheckBox chckbxYear;
    private JCheckBox chckbxCertification;
    private JCheckBox chckbxCast;
    private JCheckBox chckbxGenres;
    private JCheckBox chckbxArtwork;
    private JCheckBox chckbxTrailer;
    private JCheckBox chckbxCollection;
    private JCheckBox chckbxTags;
    private JLabel lblMovieSetHint;
    private JPanel panelSelectButtons;

    public MovieScraperMetadataPanel(MovieScraperMetadataConfig config) {
        this.config = config;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, ColumnSpec.decode((String)"15dlu"), FormSpecs.DEFAULT_COLSPEC, ColumnSpec.decode((String)"15dlu"), FormSpecs.DEFAULT_COLSPEC, ColumnSpec.decode((String)"15dlu"), FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        this.chckbxTitle = new JCheckBox(BUNDLE.getString("metatag.title"));
        this.add((Component)this.chckbxTitle, "2, 2");
        this.chckbxOriginalTitle = new JCheckBox(BUNDLE.getString("metatag.originaltitle"));
        this.add((Component)this.chckbxOriginalTitle, "4, 2");
        this.chckbxTagline = new JCheckBox(BUNDLE.getString("metatag.tagline"));
        this.add((Component)this.chckbxTagline, "6, 2");
        this.chckbxPlot = new JCheckBox(BUNDLE.getString("metatag.plot"));
        this.add((Component)this.chckbxPlot, "8, 2");
        this.chckbxRating = new JCheckBox(BUNDLE.getString("metatag.rating"));
        this.add((Component)this.chckbxRating, "2, 4");
        this.chckbxRuntime = new JCheckBox(BUNDLE.getString("metatag.runtime"));
        this.add((Component)this.chckbxRuntime, "4, 4");
        this.chckbxYear = new JCheckBox(BUNDLE.getString("metatag.year"));
        this.add((Component)this.chckbxYear, "6, 4");
        this.chckbxCertification = new JCheckBox(BUNDLE.getString("metatag.certification"));
        this.add((Component)this.chckbxCertification, "8, 4");
        this.chckbxCast = new JCheckBox(BUNDLE.getString("metatag.cast"));
        this.add((Component)this.chckbxCast, "2, 6");
        this.chckbxGenres = new JCheckBox(BUNDLE.getString("metatag.genre"));
        this.add((Component)this.chckbxGenres, "4, 6");
        this.chckbxArtwork = new JCheckBox(BUNDLE.getString("metatag.artwork"));
        this.add((Component)this.chckbxArtwork, "6, 6");
        this.chckbxTrailer = new JCheckBox(BUNDLE.getString("metatag.trailer"));
        this.add((Component)this.chckbxTrailer, "8, 6");
        JPanel panelMovieSet = new JPanel();
        panelMovieSet.setLayout(new FlowLayout(0, 0, 0));
        this.chckbxCollection = new JCheckBox(BUNDLE.getString("metatag.movieset"));
        panelMovieSet.add(this.chckbxCollection);
        this.lblMovieSetHint = new JLabel(IconManager.HINT);
        this.lblMovieSetHint.setToolTipText(BUNDLE.getString("Settings.movieset.scraper.hint"));
        panelMovieSet.add(this.lblMovieSetHint);
        this.add((Component)panelMovieSet, "2, 8");
        this.chckbxTags = new JCheckBox(BUNDLE.getString("metatag.tags"));
        this.add((Component)this.chckbxTags, "4, 8");
        this.panelSelectButtons = new JPanel();
        this.add((Component)this.panelSelectButtons, "2, 10, 3, 1, fill, fill");
        this.panelSelectButtons.setLayout(new FlowLayout(0, 5, 0));
        JButton btnSelectAll = new JButton(IconManager.CHECK_ALL);
        btnSelectAll.setToolTipText(BUNDLE.getString("Button.select.all"));
        btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieScraperMetadataPanel.this.setCheckBoxState(true);
            }
        });
        this.panelSelectButtons.add(btnSelectAll);
        JButton btnDeSelectAll = new JButton(IconManager.UNCHECK_ALL);
        btnDeSelectAll.setToolTipText(BUNDLE.getString("Button.select.none"));
        btnDeSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieScraperMetadataPanel.this.setCheckBoxState(false);
            }
        });
        this.panelSelectButtons.add(btnDeSelectAll);
        this.initDataBindings();
    }

    private void setCheckBoxState(boolean state) {
        for (JCheckBox checkBox : this.getAllCheckBoxes(this)) {
            checkBox.setSelected(state);
        }
    }

    private List<JCheckBox> getAllCheckBoxes(Container container) {
        Component[] comps = container.getComponents();
        ArrayList<JCheckBox> compList = new ArrayList<JCheckBox>();
        for (Component comp : comps) {
            if (comp instanceof JCheckBox) {
                compList.add((JCheckBox)comp);
            }
            if (!(comp instanceof Container)) continue;
            compList.addAll(this.getAllCheckBoxes((Container)comp));
        }
        return compList;
    }

    protected void initDataBindings() {
        BeanProperty scraperMetadataConfigBeanProperty = BeanProperty.create((String)"title");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty, (Object)this.chckbxTitle, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty scraperMetadataConfigBeanProperty_1 = BeanProperty.create((String)"originalTitle");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_1, (Object)this.chckbxOriginalTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty scraperMetadataConfigBeanProperty_2 = BeanProperty.create((String)"tagline");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_2, (Object)this.chckbxTagline, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty scraperMetadataConfigBeanProperty_3 = BeanProperty.create((String)"plot");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_3, (Object)this.chckbxPlot, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty scraperMetadataConfigBeanProperty_4 = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_4, (Object)this.chckbxRating, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty scraperMetadataConfigBeanProperty_5 = BeanProperty.create((String)"runtime");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_5, (Object)this.chckbxRuntime, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty scraperMetadataConfigBeanProperty_6 = BeanProperty.create((String)"year");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_6, (Object)this.chckbxYear, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty scraperMetadataConfigBeanProperty_7 = BeanProperty.create((String)"certification");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_7, (Object)this.chckbxCertification, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty scraperMetadataConfigBeanProperty_8 = BeanProperty.create((String)"cast");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_8, (Object)this.chckbxCast, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty scraperMetadataConfigBeanProperty_9 = BeanProperty.create((String)"genres");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_9, (Object)this.chckbxGenres, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty scraperMetadataConfigBeanProperty_10 = BeanProperty.create((String)"artwork");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_10, (Object)this.chckbxArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
        BeanProperty scraperMetadataConfigBeanProperty_11 = BeanProperty.create((String)"trailer");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_11, (Object)this.chckbxTrailer, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty scraperMetadataConfigBeanProperty_12 = BeanProperty.create((String)"collection");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_12, (Object)this.chckbxCollection, (Property)jCheckBoxBeanProperty);
        autoBinding_12.bind();
        BeanProperty movieScraperMetadataConfigBeanProperty = BeanProperty.create((String)"tags");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)movieScraperMetadataConfigBeanProperty, (Object)this.chckbxTags, (Property)jCheckBoxBeanProperty);
        autoBinding_13.bind();
    }
}

