/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;

public class ImageLabel
extends JLabel {
    private static final long serialVersionUID = -2524445544386464158L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static Font FONT;
    protected BufferedImage scaledImage;
    protected String imageUrl;
    protected String imagePath;
    protected Position position = Position.TOP_LEFT;
    protected String alternativeText = null;
    protected boolean drawBorder;
    protected boolean drawFullWidth;
    protected boolean enabledLightbox = false;
    protected boolean useCache = true;
    protected float desiredAspectRatio = 0.0f;
    protected SwingWorker<BufferedImage, Void> worker = null;
    protected MouseListener lightboxListener = null;

    public ImageLabel() {
        super("");
        this.drawBorder = true;
        this.drawFullWidth = false;
    }

    public ImageLabel(boolean drawBorder) {
        super("");
        this.drawBorder = drawBorder;
        this.drawFullWidth = false;
    }

    public ImageLabel(boolean drawBorder, boolean drawFullWidth) {
        super("");
        this.drawBorder = drawBorder;
        this.drawFullWidth = drawFullWidth;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String newValue) {
        String oldValue = this.imagePath;
        if (StringUtils.isNotEmpty((CharSequence)oldValue) && oldValue.equals(newValue)) {
            return;
        }
        this.imagePath = newValue;
        this.firePropertyChange("imagePath", oldValue, newValue);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.scaledImage = null;
        this.repaint();
        if (StringUtils.isBlank((CharSequence)newValue)) {
            return;
        }
        this.worker = new ImageLoader(this.imagePath, this.getSize());
        this.worker.execute();
    }

    public void clearImage() {
        this.imagePath = "";
        this.imageUrl = "";
        this.scaledImage = null;
        this.repaint();
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String newValue) {
        String oldValue = this.imageUrl;
        this.imageUrl = newValue;
        this.firePropertyChange("imageUrl", oldValue, newValue);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.scaledImage = null;
        this.repaint();
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            return;
        }
        this.worker = new ImageFetcher(this.getSize());
        this.worker.execute();
    }

    public void setDesiredAspectRatio(float desiredAspectRatio) {
        this.desiredAspectRatio = desiredAspectRatio;
    }

    public float getDesiredAspectRatio() {
        return this.desiredAspectRatio;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.desiredAspectRatio == 0.0f) {
            return super.getPreferredSize();
        }
        if (this.scaledImage != null) {
            return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / (float)this.scaledImage.getWidth() * (float)this.scaledImage.getHeight()));
        }
        return new Dimension(this.getParent().getWidth(), (int)((float)this.getParent().getWidth() / this.desiredAspectRatio) + 1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scaledImage != null) {
            int originalWidth = this.scaledImage.getWidth(null);
            int originalHeight = this.scaledImage.getHeight(null);
            int newWidth = 0;
            int newHeight = 0;
            int offsetX = 0;
            int offsetY = 0;
            if (this.drawBorder && !this.drawFullWidth) {
                Point size = ImageCache.calculateSize(this.getWidth() - 8, this.getHeight() - 8, originalWidth, originalHeight, true);
                if (this.position == Position.TOP_RIGHT || this.position == Position.BOTTOM_RIGHT) {
                    offsetX = this.getWidth() - size.x - 8;
                }
                if (this.position == Position.BOTTOM_LEFT || this.position == Position.BOTTOM_RIGHT) {
                    offsetY = this.getHeight() - size.y - 8;
                }
                if (this.position == Position.CENTER) {
                    offsetX = (this.getWidth() - size.x - 8) / 2;
                    offsetY = (this.getHeight() - size.y - 8) / 2;
                }
                newWidth = size.x;
                newHeight = size.y;
                this.recreateScaledImageIfNeeded(originalWidth, originalHeight, newWidth, newHeight);
                g.setColor(Color.BLACK);
                g.drawRect(offsetX, offsetY, size.x + 7, size.y + 7);
                g.setColor(Color.WHITE);
                g.fillRect(offsetX + 1, offsetY + 1, size.x + 6, size.y + 6);
                g.drawImage(this.scaledImage, offsetX + 4, offsetY + 4, newWidth, newHeight, this);
            } else {
                Point size = null;
                size = this.drawFullWidth ? new Point(this.getWidth(), this.getWidth() * originalHeight / originalWidth) : ImageCache.calculateSize(this.getWidth(), this.getHeight(), originalWidth, originalHeight, true);
                if (this.position == Position.TOP_RIGHT || this.position == Position.BOTTOM_RIGHT) {
                    offsetX = this.getWidth() - size.x;
                }
                if (this.position == Position.BOTTOM_LEFT || this.position == Position.BOTTOM_RIGHT) {
                    offsetY = this.getHeight() - size.y;
                }
                if (this.position == Position.CENTER) {
                    offsetX = (this.getWidth() - size.x) / 2;
                    offsetY = (this.getHeight() - size.y) / 2;
                }
                newWidth = size.x;
                newHeight = size.y;
                this.recreateScaledImageIfNeeded(originalWidth, originalHeight, newWidth, newHeight);
                g.drawImage(this.scaledImage, offsetX, offsetY, newWidth, newHeight, this);
            }
        } else {
            if (this.drawBorder) {
                g.setColor(Color.BLACK);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                if (this.getParent().isOpaque()) {
                    g.setColor(this.getParent().getBackground());
                    g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                }
            }
            int diagonalSize = (int)Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
            String text = "";
            text = this.alternativeText != null ? this.alternativeText : BUNDLE.getString("image.nonefound");
            if (!this.getParent().isOpaque()) {
                text = "";
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            AffineTransform orig = g2.getTransform();
            AffineTransform at = new AffineTransform(orig);
            at.translate(0.0, this.getHeight());
            at.rotate(this.getWidth(), -this.getHeight());
            g2.setTransform(at);
            g2.setColor(Color.BLACK);
            g2.setFont(FONT);
            FontMetrics fm = g2.getFontMetrics();
            int x = (diagonalSize - fm.stringWidth(text)) / 2;
            int y = (fm.getAscent() - fm.getDescent()) / 2;
            g2.drawString(text, x, y);
            at.translate(0.0, -this.getHeight());
            g2.setTransform(orig);
        }
    }

    private void recreateScaledImageIfNeeded(int originalWidth, int originalHeight, int newWidth, int newHeight) {
        if ((float)newWidth * 0.8f > (float)originalWidth || (float)originalWidth > (float)newWidth * 1.2f || (float)newHeight * 0.8f > (float)originalHeight || (float)originalHeight > (float)newHeight * 1.2f && newWidth > 10) {
            if (StringUtils.isNotBlank((CharSequence)this.imagePath)) {
                this.worker = new ImageLoader(this.imagePath, new Dimension(newWidth, newHeight));
                this.worker.execute();
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.imageUrl})) {
                this.worker = new ImageFetcher(new Dimension(newWidth, newHeight));
                this.worker.execute();
            }
        }
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void setAlternativeText(String text) {
        this.alternativeText = text;
    }

    public void enableLightbox() {
        this.enabledLightbox = true;
        if (this.lightboxListener == null) {
            this.lightboxListener = new ImageLabelClickListener();
            this.addMouseListener(this.lightboxListener);
        }
    }

    public void disableLightbox() {
        this.enabledLightbox = false;
        if (this.lightboxListener != null) {
            this.removeMouseListener(this.lightboxListener);
            this.lightboxListener = null;
        }
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    static {
        try {
            JLabel fontLabel = new JLabel("");
            TmmFontHelper.changeFont((JComponent)fontLabel, 1.5);
            FONT = fontLabel.getFont();
        }
        catch (Exception e) {
            FONT = Font.getFont("Dialog").deriveFont(18.0f);
        }
    }

    private class ImageLabelClickListener
    extends MouseAdapter {
        private ImageLabelClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getClickCount() == 1 && ImageLabel.this.scaledImage != null) {
                MainWindow.getActiveInstance().createLightbox(ImageLabel.this.getImagePath(), ImageLabel.this.getImageUrl());
            }
        }
    }

    protected class ImageLoader
    extends SwingWorker<BufferedImage, Void> {
        private String imagePath;
        private Dimension newSize;

        public ImageLoader(String imagePath, Dimension newSize) {
            this.imagePath = imagePath;
            this.newSize = newSize;
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            Path file = null;
            file = ImageLabel.this.useCache ? ImageCache.getCachedFile(Paths.get(this.imagePath, new String[0])) : Paths.get(this.imagePath, new String[0]);
            if (file != null && Files.exists(file, new LinkOption[0])) {
                try {
                    return Scalr.resize((BufferedImage)ImageCache.createImage(file), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)this.newSize.width, (int)this.newSize.height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            try {
                ImageLabel.this.scaledImage = (BufferedImage)this.get();
            }
            catch (Exception e) {
                ImageLabel.this.scaledImage = null;
            }
            ImageLabel.this.revalidate();
            ImageLabel.this.repaint();
        }
    }

    protected class ImageFetcher
    extends SwingWorker<BufferedImage, Void> {
        private Dimension newSize;

        public ImageFetcher(Dimension newSize) {
            this.newSize = newSize;
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            try {
                Url url = new Url(ImageLabel.this.imageUrl);
                return Scalr.resize((BufferedImage)ImageCache.createImage(url.getBytes()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)this.newSize.width, (int)this.newSize.height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            }
            catch (Exception e) {
                ImageLabel.this.imageUrl = "";
                return null;
            }
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            try {
                ImageLabel.this.scaledImage = (BufferedImage)this.get();
            }
            catch (Exception e) {
                ImageLabel.this.scaledImage = null;
            }
            ImageLabel.this.repaint();
        }
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER;

    }
}

