/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.profile;

import java.net.InetAddress;
import org.fourthline.cling.model.message.Connection;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.message.header.UserAgentHeader;
import org.fourthline.cling.model.profile.ClientInfo;
import org.seamless.http.RequestInfo;

public class RemoteClientInfo
extends ClientInfo {
    protected final Connection connection;
    protected final UpnpHeaders extraResponseHeaders = new UpnpHeaders();

    public RemoteClientInfo() {
        this((StreamRequestMessage)null);
    }

    public RemoteClientInfo(StreamRequestMessage requestMessage) {
        this(requestMessage != null ? requestMessage.getConnection() : null, requestMessage != null ? requestMessage.getHeaders() : new UpnpHeaders());
    }

    public RemoteClientInfo(Connection connection, UpnpHeaders requestHeaders) {
        super(requestHeaders);
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isRequestCancelled() {
        return !this.getConnection().isOpen();
    }

    public void throwIfRequestCancelled() throws InterruptedException {
        if (this.isRequestCancelled()) {
            throw new InterruptedException("Client's request cancelled");
        }
    }

    public InetAddress getRemoteAddress() {
        return this.getConnection().getRemoteAddress();
    }

    public InetAddress getLocalAddress() {
        return this.getConnection().getLocalAddress();
    }

    public UpnpHeaders getExtraResponseHeaders() {
        return this.extraResponseHeaders;
    }

    public void setResponseUserAgent(String userAgent) {
        this.setResponseUserAgent(new UserAgentHeader(userAgent));
    }

    public void setResponseUserAgent(UserAgentHeader userAgentHeader) {
        this.getExtraResponseHeaders().add(UpnpHeader.Type.USER_AGENT, userAgentHeader);
    }

    public boolean isWMPRequest() {
        return RequestInfo.isWMPRequest((String)this.getRequestUserAgent());
    }

    public boolean isXbox360Request() {
        return RequestInfo.isXbox360Request((String)this.getRequestUserAgent(), (String)this.getRequestHeaders().getFirstHeaderString(UpnpHeader.Type.SERVER));
    }

    public boolean isPS3Request() {
        return RequestInfo.isPS3Request((String)this.getRequestUserAgent(), (String)this.getRequestHeaders().getFirstHeaderString(UpnpHeader.Type.EXT_AV_CLIENT_INFO));
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Remote Address: " + this.getRemoteAddress();
    }
}

