/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.ui.UTF8Control;

public class MovieAssignMovieSetTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieAssignMovieSetTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<Movie> moviesToScrape;

    public MovieAssignMovieSetTask(List<Movie> moviesToScrape) {
        super(BUNDLE.getString("movie.assignmovieset"));
        this.moviesToScrape = moviesToScrape;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(1, "scrape");
        this.start();
        for (int i = 0; i < this.moviesToScrape.size(); ++i) {
            Movie movie = this.moviesToScrape.get(i);
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done assigning movies to movie sets");
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private class Worker
    implements Runnable {
        private MovieList movieList = MovieList.getInstance();
        private Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        @Override
        public void run() {
            block11: {
                if (this.movie.getMovieSet() != null) {
                    return;
                }
                try {
                    List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                    if (sets == null || sets.size() <= 0) break block11;
                    MediaScraper first = sets.get(0);
                    IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                    MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
                    options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                    options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
                    for (Map.Entry<String, Object> entry : this.movie.getIds().entrySet()) {
                        options.setId(entry.getKey(), entry.getValue().toString());
                    }
                    MediaMetadata md = mp.getMetadata(options);
                    int collectionId = (Integer)md.getId("tmdbSet");
                    if (collectionId <= 0) break block11;
                    String collectionName = md.getCollectionName();
                    MovieSet movieSet = this.movieList.getMovieSet(collectionName, collectionId);
                    if (movieSet != null && movieSet.getTmdbId() == 0) {
                        movieSet.setTmdbId(collectionId);
                        try {
                            options = new MediaScrapeOptions(MediaType.MOVIE_SET);
                            options.setTmdbId(collectionId);
                            options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.MOVIE_SETTINGS.getScraperLanguage().name()));
                            options.setCountry(MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry());
                            MediaMetadata info = mp.getMetadata(options);
                            if (info != null && StringUtils.isNotBlank((CharSequence)info.getTitle())) {
                                movieSet.setTitle(info.getTitle());
                                movieSet.setPlot(info.getPlot());
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                                    movieSet.setArtworkUrl(((MediaArtwork)info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0)).getDefaultUrl(), MediaFileType.POSTER);
                                }
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                                    movieSet.setArtworkUrl(((MediaArtwork)info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).get(0)).getDefaultUrl(), MediaFileType.FANART);
                                }
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (movieSet != null) {
                        this.movie.setMovieSet(null);
                        this.movie.setMovieSet(movieSet);
                        movieSet.insertMovie(this.movie);
                        this.movie.writeNFO();
                        this.movie.saveToDb();
                        movieSet.saveToDb();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("error getting metadata: " + e.getMessage());
                }
            }
        }
    }
}

