/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.Pair;

public class StreamingUrl
extends Url {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingUrl.class);

    public StreamingUrl(String url) throws IOException {
        super(url);
    }

    @Override
    public InputStream getInputStream() throws IOException, InterruptedException {
        if (this.url.startsWith("file:")) {
            String newUrl = this.url.replace("file:", "");
            File file = new File(newUrl);
            return new FileInputStream(file);
        }
        String logUrl = this.url.replaceAll("api_key=\\w+", "api_key=<API_KEY>").replaceAll("api/\\d+\\w+", "api/<API_KEY>");
        LOGGER.debug("getting " + logUrl);
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(this.url);
        InputStream is = null;
        for (Pair header : this.headersRequest) {
            requestBuilder.addHeader((String)header.first(), (String)header.second());
        }
        this.request = requestBuilder.build();
        try {
            this.call = client.newCall(this.request);
            this.response = this.call.execute();
            this.headersResponse = this.response.headers();
            this.responseCode = this.response.code();
            this.responseMessage = this.response.message();
            this.responseCharset = this.response.body().contentType().charset();
            this.responseContentType = this.response.body().contentType().toString();
            is = this.response.body().byteStream();
        }
        catch (InterruptedIOException | IllegalStateException e) {
            LOGGER.info("aborted request: " + logUrl + " ;" + e.getMessage());
            this.cleanup();
            throw new InterruptedException();
        }
        catch (UnknownHostException e) {
            LOGGER.error("proxy or host not found/reachable", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Exception getting url " + logUrl, (Throwable)e);
        }
        return is;
    }
}

