/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.japura.gui.util.InputEventBlocker;
import org.japura.gui.util.SwingWorkerHandlerEvent;

public class SwingWorkerHandler {
    private int delay = 600;
    private int workersCount;

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getWorkersCount() {
        return this.workersCount;
    }

    void decWorkersCount() {
        --this.workersCount;
    }

    void incWorkersCount() {
        ++this.workersCount;
    }

    public void register(SwingWorker<?, ?> worker, String name) {
        worker.addPropertyChangeListener(new Starter(this, name));
    }

    protected void progress(int value) {
    }

    protected void before(SwingWorkerHandlerEvent event) {
    }

    protected void after(SwingWorkerHandlerEvent event) {
    }

    private static class Starter
    extends Timer
    implements ActionListener,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private SwingWorkerHandler handler;
        private String name;
        private InputEventBlocker eventHook = new InputEventBlocker();
        private boolean stop;
        private boolean called;

        public Starter(SwingWorkerHandler handler, String name) {
            super(handler.getDelay(), null);
            this.name = name;
            this.handler = handler;
            this.addActionListener(this);
            this.setRepeats(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName())) {
                if (evt.getNewValue().equals((Object)SwingWorker.StateValue.STARTED)) {
                    this.handler.incWorkersCount();
                    this.eventHook.apply();
                    this.start();
                } else if (evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                    this.handler.decWorkersCount();
                    this.stop();
                    this.eventHook.remove();
                }
            } else if ("progress".equals(evt.getPropertyName())) {
                this.handler.progress((Integer)evt.getNewValue());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.stop) {
                this.called = true;
                this.eventHook.remove();
                this.handler.before(new SwingWorkerHandlerEvent(this.handler.getWorkersCount(), this.name));
            }
        }

        @Override
        public void stop() {
            this.stop = true;
            super.stop();
            if (this.called) {
                this.handler.after(new SwingWorkerHandlerEvent(this.handler.getWorkersCount(), this.name));
            }
        }
    }
}

