/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.modal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.InternalFrameListener;
import org.japura.gui.modal.ModalEvent;
import org.japura.gui.modal.ModalListener;
import org.japura.gui.modal.ModalPanel;

public class Modal {
    private static Integer defaultModalDepth = JLayeredPane.DEFAULT_LAYER + 1;
    private static Hashtable<RootPaneContainer, Modal> modals = new Hashtable();
    private RootPaneContainer rootPane;
    private ModalPanel modalPanel;
    private int oldDefaultCloseOperation;
    private WindowListener[] oldWindowListeners;
    private InternalFrameListener[] oldInternalFrameListeners;
    private ComponentListener resizeListener;
    private List<Component> components;
    private HashMap<Component, List<ModalListener>> listeners;
    private HashMap<Component, Integer> depths;

    public static Component getCurrentModal(JFrame frame) {
        return Modal.getCurrentModal_(frame);
    }

    public static Component getCurrentModal(JDialog dialog) {
        return Modal.getCurrentModal_(dialog);
    }

    public static Component getCurrentModal(JInternalFrame frame) {
        return Modal.getCurrentModal_(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component getCurrentModal_(RootPaneContainer rootPane) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPane);
            if (modal != null && modal.getSize() > 0) {
                return modal.components.get(modal.components.size() - 1);
            }
            return null;
        }
    }

    public static void closeCurrentModal(JFrame frame) {
        Modal.closeCurrentModal_(frame);
    }

    public static void closeCurrentModal(JDialog dialog) {
        Modal.closeCurrentModal_(dialog);
    }

    public static void closeCurrentModal(JInternalFrame frame) {
        Modal.closeCurrentModal_(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeCurrentModal_(RootPaneContainer rootPane) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPane);
            if (modal != null) {
                modal.closeCurrent();
                if (modal.getSize() == 0) {
                    modals.remove(rootPane);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeModal(Component component) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            RootPaneContainer frame = null;
            Modal modal = null;
            for (Map.Entry<RootPaneContainer, Modal> entry : modals.entrySet()) {
                modal = entry.getValue();
                frame = entry.getKey();
                if (frame != null && modal != null && modal.components.contains(component)) break;
                frame = null;
                modal = null;
            }
            if (frame != null && modal != null) {
                super.close(component);
                if (modal.getSize() == 0) {
                    modals.remove(frame);
                }
            }
        }
    }

    public static void closeAllModals(JFrame frame) {
        Modal.closeAllModals_(frame);
    }

    public static void closeAllModals(JDialog dialog) {
        Modal.closeAllModals_(dialog);
    }

    public static void closeAllModals(JInternalFrame frame) {
        Modal.closeAllModals_(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeAllModals_(RootPaneContainer rootPane) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPane);
            if (modal != null) {
                modal.closeAll();
                modals.remove(rootPane);
            }
        }
    }

    public static boolean hasModal(JFrame frame) {
        return Modal.hasModal_(frame);
    }

    public static boolean hasModal(JDialog dialog) {
        return Modal.hasModal_(dialog);
    }

    public static boolean hasModal(JInternalFrame frame) {
        return Modal.hasModal_(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasModal_(RootPaneContainer rootPane) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPane);
            return modal != null && modal.getSize() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Modal getModal(RootPaneContainer rootPane) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPane);
            if (modal == null) {
                modal = new Modal(rootPane);
                modals.put(rootPane, modal);
            }
            return modal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isModal(Component component) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            for (Map.Entry<RootPaneContainer, Modal> entry : modals.entrySet()) {
                if (!entry.getValue().components.contains(component)) continue;
                return true;
            }
            return false;
        }
    }

    public static void addModal(JInternalFrame frame, Component component) {
        Modal.addModal(frame, component, null);
    }

    public static void addModal(JInternalFrame frame, Component component, ModalListener listener) {
        Modal.addModal_(frame, component, listener, defaultModalDepth);
    }

    public static void addModal(JInternalFrame frame, Component component, ModalListener listener, Integer modalDepth) {
        Modal.addModal_(frame, component, listener, modalDepth);
    }

    public static void addModal(JDialog dialog, Component component) {
        Modal.addModal(dialog, component, null);
    }

    public static void addModal(JDialog dialog, Component component, ModalListener listener) {
        Modal.addModal_(dialog, component, listener, defaultModalDepth);
    }

    public static void addModal(JDialog dialog, Component component, ModalListener listener, Integer modalDepth) {
        Modal.addModal_(dialog, component, listener, modalDepth);
    }

    public static void addModal(RootPaneContainer rootPane, Component component) {
        Modal.addModal(rootPane, component, null);
    }

    public static void addModal(RootPaneContainer rootPane, Component component, ModalListener listener) {
        Modal.addModal(rootPane, component, listener, defaultModalDepth);
    }

    public static void addModal(RootPaneContainer rootPane, Component component, ModalListener listener, Integer modalDepth) {
        if (rootPane instanceof JFrame) {
            Modal.addModal_((JFrame)rootPane, component, listener, modalDepth);
        } else if (rootPane instanceof JDialog) {
            Modal.addModal_((JDialog)rootPane, component, listener, modalDepth);
        } else if (rootPane instanceof JInternalFrame) {
            Modal.addModal_((JInternalFrame)rootPane, component, listener, modalDepth);
        } else {
            return;
        }
    }

    public static void addModal(JFrame frame, Component component) {
        Modal.addModal(frame, component, null);
    }

    public static void addModal(JFrame frame, Component component, ModalListener listener) {
        Modal.addModal_(frame, component, listener, defaultModalDepth);
    }

    public static void addModal(JFrame frame, Component component, ModalListener listener, Integer modalDepth) {
        Modal.addModal_(frame, component, listener, modalDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addModal_(RootPaneContainer rootPane, Component component, ModalListener listener, Integer modalDepth) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            if (!Modal.isModal(component)) {
                Modal.getModal(rootPane).addModal(component, listener, modalDepth);
            }
        }
    }

    public static void addListener(JFrame frame, Component component, ModalListener listener) {
        Modal.addListener_(frame, component, listener);
    }

    public static void addListener(JDialog dialog, Component component, ModalListener listener) {
        Modal.addListener_(dialog, component, listener);
    }

    public static void addListener(JInternalFrame frame, Component component, ModalListener listener) {
        Modal.addListener_(frame, component, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addListener_(RootPaneContainer rootPane, Component component, ModalListener listener) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            if (Modal.isModal(component)) {
                Modal.getModal(rootPane).addListener(component, listener);
            }
        }
    }

    public static int getModalCount(JFrame frame) {
        return Modal.getModalCount_(frame);
    }

    public static int getModalCount(JDialog dialog) {
        return Modal.getModalCount_(dialog);
    }

    public static int getModalCount(JInternalFrame frame) {
        return Modal.getModalCount_(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getModalCount_(RootPaneContainer rootPane) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPane);
            if (modal != null) {
                return modal.getSize();
            }
            return 0;
        }
    }

    private Modal(RootPaneContainer rootPane) {
        this.rootPane = rootPane;
        this.resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Modal.this.resizeModalPanel();
            }
        };
        this.components = new ArrayList<Component>();
        this.depths = new HashMap();
        this.listeners = new HashMap();
        this.rootPane.getRootPane().addComponentListener(this.resizeListener);
        this.resizeModalPanel();
        if (rootPane instanceof JFrame) {
            this.backupProperties((JFrame)rootPane);
        } else if (rootPane instanceof JDialog) {
            this.backupProperties((JDialog)rootPane);
        } else if (rootPane instanceof JInternalFrame) {
            this.backupProperties((JInternalFrame)rootPane);
        }
        this.getModalPanel().setVisible(true);
    }

    private void backupProperties(JFrame frame) {
        this.oldDefaultCloseOperation = frame.getDefaultCloseOperation();
        frame.setDefaultCloseOperation(0);
        for (WindowListener listener : this.oldWindowListeners = frame.getWindowListeners()) {
            frame.removeWindowListener(listener);
        }
    }

    private void backupProperties(JDialog dialog) {
        this.oldDefaultCloseOperation = dialog.getDefaultCloseOperation();
        dialog.setDefaultCloseOperation(0);
        for (WindowListener listener : this.oldWindowListeners = dialog.getWindowListeners()) {
            dialog.removeWindowListener(listener);
        }
    }

    private void backupProperties(JInternalFrame frame) {
        this.oldDefaultCloseOperation = frame.getDefaultCloseOperation();
        frame.setDefaultCloseOperation(0);
        for (InternalFrameListener listener : this.oldInternalFrameListeners = frame.getInternalFrameListeners()) {
            frame.removeInternalFrameListener(listener);
        }
    }

    private void closeCurrent() {
        if (this.components.size() > 0) {
            Component component = this.components.remove(this.components.size() - 1);
            this.getModalPanel().removeAll();
            this.fireCloseActionListener(this.listeners.get(component));
            this.listeners.remove(component);
            if (this.components.size() > 0) {
                this.showNextComponent();
            } else {
                this.restoreRootPane();
            }
        }
    }

    private void resizeModalPanel() {
        Dimension dim = this.rootPane.getRootPane().getSize();
        this.getModalPanel().setBounds(0, 0, dim.width, dim.height);
        this.getModalPanel().revalidate();
    }

    private void restoreRootPane() {
        Container frame;
        this.rootPane.getRootPane().removeComponentListener(this.resizeListener);
        this.rootPane.getLayeredPane().remove(this.getModalPanel());
        if (this.rootPane instanceof JFrame) {
            frame = (JFrame)this.rootPane;
            ((JFrame)frame).setDefaultCloseOperation(this.oldDefaultCloseOperation);
            for (WindowListener listener : this.oldWindowListeners) {
                ((Window)frame).addWindowListener(listener);
            }
        } else if (this.rootPane instanceof JDialog) {
            JDialog dialog = (JDialog)this.rootPane;
            dialog.setDefaultCloseOperation(this.oldDefaultCloseOperation);
            for (WindowListener listener : this.oldWindowListeners) {
                dialog.addWindowListener(listener);
            }
        } else if (this.rootPane instanceof JInternalFrame) {
            frame = (JInternalFrame)this.rootPane;
            ((JInternalFrame)frame).setDefaultCloseOperation(this.oldDefaultCloseOperation);
            for (InternalFrameListener listener : this.oldInternalFrameListeners) {
                ((JInternalFrame)frame).addInternalFrameListener(listener);
            }
        }
        Component comp = (Component)((Object)this.rootPane);
        comp.update(comp.getGraphics());
    }

    private void close(Component component) {
        if (this.components.size() > 0) {
            if (!this.components.contains(component)) {
                return;
            }
            this.components.remove(component);
            this.depths.remove(component);
            this.getModalPanel().removeAll();
            this.fireCloseActionListener(this.listeners.get(component));
            this.listeners.remove(component);
            if (this.components.size() > 0) {
                this.showNextComponent();
            } else {
                this.restoreRootPane();
            }
        }
    }

    private void showNextComponent() {
        Component component = this.components.get(this.components.size() - 1);
        Integer modalDepth = this.depths.get(component);
        this.rootPane.getLayeredPane().remove(this.getModalPanel());
        this.rootPane.getLayeredPane().add((Component)this.getModalPanel(), modalDepth);
        this.getModalPanel().add("", component);
        this.getModalPanel().revalidate();
        this.getModalPanel().repaint();
    }

    private void fireCloseActionListener(List<ModalListener> list) {
        if (list != null) {
            for (ModalListener listener : list) {
                listener.modalClosed(new ModalEvent(this.rootPane));
            }
        }
    }

    private void closeAll() {
        this.getModalPanel().removeAll();
        this.components.clear();
        this.depths.clear();
        this.listeners.clear();
        this.restoreRootPane();
    }

    private void addModal(Component component, ModalListener listener, Integer modalDepth) {
        if (modalDepth == null) {
            modalDepth = defaultModalDepth;
        }
        if (!this.components.contains(component)) {
            this.rootPane.getLayeredPane().remove(this.getModalPanel());
            this.rootPane.getLayeredPane().add((Component)this.getModalPanel(), modalDepth);
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            focusManager.clearGlobalFocusOwner();
            this.getModalPanel().removeAll();
            this.getModalPanel().add("", component);
            this.resizeModalPanel();
            this.getModalPanel().repaint();
            this.components.add(component);
            this.depths.put(component, modalDepth);
            this.addListener(component, listener);
        }
    }

    private void addListener(Component component, ModalListener listener) {
        if (this.components.contains(component)) {
            List<ModalListener> list = this.listeners.get(component);
            if (list == null) {
                list = new ArrayList<ModalListener>();
                this.listeners.put(component, list);
            }
            if (listener != null) {
                list.add(listener);
            }
        }
    }

    private int getSize() {
        return this.components.size();
    }

    private ModalPanel getModalPanel() {
        if (this.modalPanel == null) {
            this.modalPanel = new ModalPanel();
            this.modalPanel.setLayout(new ModalLayout());
        }
        return this.modalPanel;
    }

    public static RootPaneContainer getRootPaneContainer(Component component) {
        if (component instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)component);
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof RootPaneContainer)) continue;
            return (RootPaneContainer)((Object)p);
        }
        return null;
    }

    public static Component getCurrentModal(RootPaneContainer rootPane) {
        if (rootPane != null) {
            if (rootPane instanceof JFrame) {
                return Modal.getCurrentModal((JFrame)rootPane);
            }
            if (rootPane instanceof JDialog) {
                return Modal.getCurrentModal((JDialog)rootPane);
            }
        }
        return null;
    }

    public static void closeCurrentModal(RootPaneContainer rootPane) {
        if (rootPane != null) {
            if (rootPane instanceof JFrame) {
                Modal.closeCurrentModal((JFrame)rootPane);
            } else if (rootPane instanceof JDialog) {
                Modal.closeCurrentModal((JDialog)rootPane);
            }
        }
    }

    public static void closeAllModals(RootPaneContainer rootPane) {
        if (rootPane != null) {
            if (rootPane instanceof JFrame) {
                JFrame frame = (JFrame)rootPane;
                Modal.closeAllModals(frame);
            } else if (rootPane instanceof JDialog) {
                JDialog dialog = (JDialog)rootPane;
                Modal.closeAllModals(dialog);
            } else if (rootPane instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)rootPane;
                Modal.closeAllModals(frame);
            }
        }
    }

    public static boolean hasModal(RootPaneContainer rootPane) {
        if (rootPane == null) {
            return false;
        }
        if (rootPane instanceof JFrame) {
            return Modal.hasModal((JFrame)rootPane);
        }
        if (rootPane instanceof JDialog) {
            return Modal.hasModal((JDialog)rootPane);
        }
        return false;
    }

    private static class ModalLayout
    implements LayoutManager {
        private Component comp;

        private ModalLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.comp = comp;
        }

        @Override
        public void layoutContainer(Container parent) {
            if (this.comp != null) {
                Dimension cdim = this.comp.getPreferredSize();
                Dimension pdim = parent.getSize();
                int x = pdim.width / 2 - cdim.width / 2;
                int y = pdim.height / 2 - cdim.height / 2;
                this.comp.setBounds(x, y, cdim.width, cdim.height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            if (this.comp != null) {
                return this.comp.getPreferredSize();
            }
            return dim;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

