/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Logger;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.options.Option;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.locations.FileClasspathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.locations.JARClasspathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.locations.MultiPluginClasspathLocation;

public abstract class AbstractClassPathLocation {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final URI location;
    protected final String realm;
    protected final JARCache cache;
    protected JARCache.JARInformation cacheEntry = null;

    protected AbstractClassPathLocation(JARCache cache, String realm, URI location) {
        this.cache = cache;
        this.realm = realm;
        this.location = location;
    }

    public static AbstractClassPathLocation newClasspathLocation(JARCache cache, String realm, URI location) {
        if (CoreKeeper.$(location).filter(".*\\.plugin[/]$", new Option[0]).get(false) != null) {
            return new MultiPluginClasspathLocation(cache, realm, location);
        }
        if (location.toString().endsWith(".jar")) {
            return new JARClasspathLocation(cache, realm, location);
        }
        return new FileClasspathLocation(cache, realm, location);
    }

    public URI getToplevelLocation() {
        return this.location;
    }

    public URI[] getClasspathLocations() {
        return new URI[]{this.location};
    }

    public String getRealm() {
        return this.realm;
    }

    public abstract LocationType getType();

    public abstract Collection<String> listToplevelClassNames();

    public abstract Collection<String> listAllEntries();

    public abstract InputStream getInputStream(String var1);

    public static enum LocationType {
        JAR,
        DIRECTORY,
        MULTI_PLUGIN;

    }
}

