/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.util.HashMap;
import java.util.List;
import net.jcores.jre.CommonCore;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.adapter.AbstractAdapter;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.map.MapEntry;
import net.jcores.jre.utils.map.MapUtil;

public class CoreMap<K, V>
extends CoreObject<MapEntry<K, V>> {
    private static final long serialVersionUID = 5115270057138570660L;

    public CoreMap(CommonCore commonCore, MapEntry<K, V> ... mapEntryArray) {
        super(commonCore, mapEntryArray);
    }

    public CoreMap(CommonCore commonCore, List<MapEntry<K, V>> list) {
        super(commonCore, list);
    }

    public CoreMap(CommonCore commonCore, AbstractAdapter<MapEntry<K, V>> abstractAdapter) {
        super(commonCore, abstractAdapter);
    }

    public CoreMap<V, K> inverse() {
        return new CoreMap<K, V>(this.commonCore, this.map(new F1<MapEntry<K, V>, MapEntry<V, K>>(){

            @Override
            public MapEntry<V, K> f(MapEntry<K, V> mapEntry) {
                return new MapEntry(mapEntry.value(), mapEntry.key());
            }
        }, new Option[0]).unsafelist());
    }

    public K key(V v) {
        for (MapEntry mapEntry : this) {
            if (mapEntry == null || !mapEntry.value().equals(v)) continue;
            return mapEntry.key();
        }
        return null;
    }

    public CoreObject<K> keys() {
        return new CoreObject(this.commonCore, this.map(new F1<MapEntry<K, V>, K>(){

            @Override
            public K f(MapEntry<K, V> mapEntry) {
                return mapEntry.key();
            }
        }, new Option[0]).unsafelist());
    }

    public MapUtil<K, V> map() {
        MapUtil mapUtil = new MapUtil(new HashMap());
        for (MapEntry mapEntry : this) {
            if (mapEntry == null) continue;
            mapUtil.put(mapEntry.key(), mapEntry.value());
        }
        return mapUtil;
    }

    public CoreObject<V> values() {
        return new CoreObject(this.commonCore, this.map(new F1<MapEntry<K, V>, V>(){

            @Override
            public V f(MapEntry<K, V> mapEntry) {
                return mapEntry.value();
            }
        }, new Option[0]).unsafelist());
    }

    public V value(K k) {
        for (MapEntry mapEntry : this) {
            if (mapEntry == null || !mapEntry.key().equals(k)) continue;
            return mapEntry.value();
        }
        return null;
    }
}

