/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.cores;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jcores.jre.CommonCore;
import net.jcores.jre.annotations.Beta;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.interfaces.functions.F1;
import net.jcores.jre.options.MessageType;

@Beta
public class CoreFuture<T>
extends CoreObject<Future<T>> {
    private static final long serialVersionUID = -7643964446329787050L;

    public CoreFuture(CommonCore commonCore, Future<T> ... futureArray) {
        super(commonCore, futureArray);
    }

    public CoreFuture<T> onNext(final F1<T, Void> f1) {
        for (final Future future : this) {
            this.commonCore.executor().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object v = future.get();
                        f1.f(v);
                    }
                    catch (InterruptedException interruptedException) {
                        CoreFuture.this.commonCore.report(MessageType.EXCEPTION, "InterruptedException when waiting for future");
                        return;
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace();
                    }
                }
            });
        }
        return this;
    }

    public CoreObject<T> await() {
        return this.await(Long.MAX_VALUE, TimeUnit.DAYS);
    }

    public CoreObject<T> await(long l, TimeUnit timeUnit) {
        throw new IllegalStateException("Not implemented yet");
    }

    public T obtain(int n) {
        return this.obtain(n, 1L, TimeUnit.NANOSECONDS);
    }

    public T obtain(int n, long l, TimeUnit timeUnit) {
        Future future = (Future)this.get(n);
        if (future == null) {
            return null;
        }
        try {
            return (T)future.get(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return null;
    }
}

