/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowScrapeMetadataDialog;

public class TvShowSelectedScrapeAction
extends AbstractAction {
    private static final long serialVersionUID = 699165862194137592L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowSelectedScrapeAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.scrape.selected.force"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.scrape.selected.force.desc"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        if (selectedTvShows.size() > 0) {
            TvShowScrapeMetadataDialog dialog = new TvShowScrapeMetadataDialog(BUNDLE.getString("tvshow.scrape.selected.force"));
            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            dialog.setVisible(true);
            TvShowSearchAndScrapeOptions options = dialog.getTvShowSearchAndScrapeConfig();
            if (dialog.shouldStartScrape()) {
                TvShowScrapeTask scrapeTask = new TvShowScrapeTask(selectedTvShows, true, options);
                if (TmmTaskManager.getInstance().addMainTask(scrapeTask)) {
                    JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
                }
            }
        }
    }
}

