/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class MovieSetAddAction
extends AbstractAction {
    private static final long serialVersionUID = 819724436270051906L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetAddAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movieset.add.desc"));
        }
        this.putValue("SwingLargeIconKey", IconManager.LIST_ADD);
        this.putValue("SmallIcon", IconManager.LIST_ADD);
        this.putValue("ShortDescription", BUNDLE.getString("movieset.add.desc"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = JOptionPane.showInputDialog(null, BUNDLE.getString("movieset.title"), "", 3);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            MovieSet movieSet = new MovieSet(name);
            movieSet.saveToDb();
            MovieList.getInstance().addMovieSet(movieSet);
        }
    }
}

