/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.moviesets.MovieSetTreeNode;

public class MovieSetRootTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -1209627220507076339L;
    private Comparator<TreeNode> nodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof MovieSetTreeNode && o2 instanceof MovieSetTreeNode) {
                MovieSetTreeNode node1 = (MovieSetTreeNode)o1;
                MovieSet movieSet1 = (MovieSet)node1.getUserObject();
                MovieSetTreeNode node2 = (MovieSetTreeNode)o2;
                MovieSet movieSet2 = (MovieSet)node2.getUserObject();
                return movieSet1.getTitleSortable().compareToIgnoreCase(movieSet2.getTitleSortable());
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public MovieSetRootTreeNode() {
        super("MovieSets");
    }

    @Override
    public String toString() {
        if (this.getUserObject() instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)this.getUserObject();
            return movieSet.getTitle();
        }
        return super.toString();
    }

    public void sort() {
        if (this.children != null) {
            Collections.sort(this.children, this.nodeComparator);
        }
    }
}

