/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.trakttv.ClearTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class MovieSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = -7580437046944123496L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private JComboBox<MovieConnectors> cbNfoFormat;
    private JCheckBox cbMovieNfoFilename1;
    private JCheckBox cbMovieNfoFilename2;
    private JCheckBox cbMovieNfoFilename3;
    private JCheckBox chckbxImageCache;
    private JTextField tfAddBadword;
    private JList<String> listBadWords;
    private JList<String> listDataSources;
    private JCheckBox chckbxYear;
    private JCheckBox chckbxTrailer;
    private JCheckBox chckbxSubtitles;
    private JCheckBox chckbxImages;
    private JCheckBox chckbxNfo;
    private JCheckBox chckbxMetadata;
    private JCheckBox chckbxRuntimeFromMf;
    private JCheckBox chckbxTraktTv;
    private JCheckBox chckbxWatched;
    private JCheckBox chckbxRating;
    private JCheckBox chckbxDateAdded;
    private JCheckBox chckbxSaveUiFilter;
    private JList<String> listIgnore;
    private JCheckBox chckbxRename;
    private JComboBox<CertificationStyleWrapper> cbCertificationStyle;

    public MovieSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JPanel panelGeneral = new JPanel();
        panelGeneral.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.general"), 4, 2, null, null));
        this.add((Component)panelGeneral, "2, 2, fill, fill");
        panelGeneral.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblVisiblecolumns = new JLabel(BUNDLE.getString("Settings.movie.visiblecolumns"));
        panelGeneral.add((Component)lblVisiblecolumns, "2, 2, right, default");
        this.chckbxYear = new JCheckBox(BUNDLE.getString("metatag.year"));
        panelGeneral.add((Component)this.chckbxYear, "4, 2");
        this.chckbxRating = new JCheckBox(BUNDLE.getString("metatag.rating"));
        panelGeneral.add((Component)this.chckbxRating, "6, 2");
        this.chckbxNfo = new JCheckBox(BUNDLE.getString("metatag.nfo"));
        panelGeneral.add((Component)this.chckbxNfo, "8, 2");
        this.chckbxMetadata = new JCheckBox(BUNDLE.getString("tmm.metadata"));
        panelGeneral.add((Component)this.chckbxMetadata, "10, 2");
        this.chckbxDateAdded = new JCheckBox(BUNDLE.getString("metatag.dateadded"));
        panelGeneral.add((Component)this.chckbxDateAdded, "12, 2");
        this.chckbxImages = new JCheckBox(BUNDLE.getString("metatag.images"));
        panelGeneral.add((Component)this.chckbxImages, "4, 4");
        this.chckbxTrailer = new JCheckBox(BUNDLE.getString("metatag.trailer"));
        panelGeneral.add((Component)this.chckbxTrailer, "6, 4");
        this.chckbxSubtitles = new JCheckBox(BUNDLE.getString("metatag.subtitles"));
        panelGeneral.add((Component)this.chckbxSubtitles, "8, 4");
        this.chckbxWatched = new JCheckBox(BUNDLE.getString("metatag.watched"));
        panelGeneral.add((Component)this.chckbxWatched, "10, 4");
        JLabel lblSaveUiFilter = new JLabel(BUNDLE.getString("Settings.movie.persistuifilter"));
        panelGeneral.add((Component)lblSaveUiFilter, "2, 6, right, default");
        this.chckbxSaveUiFilter = new JCheckBox("");
        panelGeneral.add((Component)this.chckbxSaveUiFilter, "4, 6");
        JSeparator separator_4 = new JSeparator();
        panelGeneral.add((Component)separator_4, "2, 8, 11, 1");
        JLabel lblImageCache = new JLabel(BUNDLE.getString("Settings.imagecacheimport"));
        panelGeneral.add((Component)lblImageCache, "2, 10, right, default");
        this.chckbxImageCache = new JCheckBox(BUNDLE.getString("Settings.imagecacheimporthint"));
        TmmFontHelper.changeFont((JComponent)this.chckbxImageCache, 0.833);
        panelGeneral.add((Component)this.chckbxImageCache, "4, 10, 7, 1");
        JLabel lblRuntimeFromMedia = new JLabel(BUNDLE.getString("Settings.runtimefrommediafile"));
        panelGeneral.add((Component)lblRuntimeFromMedia, "2, 12, right, default");
        this.chckbxRuntimeFromMf = new JCheckBox("");
        panelGeneral.add((Component)this.chckbxRuntimeFromMf, "4, 12");
        JSeparator separator = new JSeparator();
        panelGeneral.add((Component)separator, "2, 14, 11, 1");
        JLabel lblAutomaticRename = new JLabel(BUNDLE.getString("Settings.movie.automaticrename"));
        panelGeneral.add((Component)lblAutomaticRename, "2, 16, right, default");
        this.chckbxRename = new JCheckBox(BUNDLE.getString("Settings.movie.automaticrename.desc"));
        panelGeneral.add((Component)this.chckbxRename, "4, 16, 7, 1");
        JLabel lblTraktTv = new JLabel(BUNDLE.getString("Settings.trakt"));
        panelGeneral.add((Component)lblTraktTv, "2, 18");
        this.chckbxTraktTv = new JCheckBox("");
        panelGeneral.add((Component)this.chckbxTraktTv, "4, 18");
        JButton btnClearTraktTvMovies = new JButton(BUNDLE.getString("Settings.trakt.clearmovies"));
        btnClearTraktTvMovies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirm = JOptionPane.showOptionDialog(null, BUNDLE.getString("Settings.trakt.clearmovies.hint"), BUNDLE.getString("Settings.trakt.clearmovies"), 0, 3, null, null, null);
                if (confirm == 0) {
                    ClearTraktTvTask task = new ClearTraktTvTask(true, false);
                    TmmTaskManager.getInstance().addUnnamedTask(task);
                }
            }
        });
        panelGeneral.add((Component)btnClearTraktTvMovies, "6, 18, 3, 1, left, default");
        JPanel panelMovieDataSources = new JPanel();
        panelMovieDataSources.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.movie.datasource"), 4, 2, null, null));
        this.add((Component)panelMovieDataSources, "2, 4, 3, 1, fill, fill");
        panelMovieDataSources.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"150dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"150dlu:grow(2)"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode((String)"100px:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblDataSource = new JLabel(BUNDLE.getString("Settings.source"));
        panelMovieDataSources.add((Component)lblDataSource, "2, 2, 5, 1");
        JLabel lblIngore = new JLabel(BUNDLE.getString("Settings.ignore"));
        panelMovieDataSources.add((Component)lblIngore, "12, 2");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelMovieDataSources.add((Component)scrollPaneDataSources, "2, 4, 5, 1, fill, fill");
        this.listDataSources = new JList();
        scrollPaneDataSources.setViewportView(this.listDataSources);
        JPanel panelMovieSourcesButtons = new JPanel();
        panelMovieDataSources.add((Component)panelMovieSourcesButtons, "8, 4, fill, top");
        panelMovieSourcesButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JButton btnAdd = new JButton(IconManager.LIST_ADD);
        btnAdd.setToolTipText(BUNDLE.getString("Button.add"));
        btnAdd.setMargin(new Insets(2, 2, 2, 2));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String path = TmmProperties.getInstance().getProperty("movie.datasource.path");
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.datasource.folderchooser"), path);
                if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                    MovieSettingsPanel.this.settings.addMovieDataSources(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("movie.datasource.path", file.toAbsolutePath().toString());
                }
            }
        });
        panelMovieSourcesButtons.add((Component)btnAdd, "1, 1, fill, top");
        JButton btnRemove = new JButton(IconManager.LIST_REMOVE);
        btnRemove.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemove.setMargin(new Insets(2, 2, 2, 2));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = MovieSettingsPanel.this.listDataSources.getSelectedIndex();
                if (row != -1) {
                    String path = MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource().get(row);
                    Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                    int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.movie.datasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                    if (decision == 0) {
                        MovieSettingsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        MovieModuleManager.MOVIE_SETTINGS.removeMovieDataSources(path);
                        MovieSettingsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        panelMovieSourcesButtons.add((Component)btnRemove, "1, 3, fill, top");
        JScrollPane scrollPaneIgnore = new JScrollPane();
        panelMovieDataSources.add((Component)scrollPaneIgnore, "12, 4, fill, fill");
        this.listIgnore = new JList();
        scrollPaneIgnore.setViewportView(this.listIgnore);
        JPanel panelIgnoreButtons = new JPanel();
        panelMovieDataSources.add((Component)panelIgnoreButtons, "14, 4, fill, fill");
        panelIgnoreButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JButton btnAddIgnore = new JButton(IconManager.LIST_ADD);
        btnAddIgnore.setToolTipText(BUNDLE.getString("Settings.addignore"));
        btnAddIgnore.setMargin(new Insets(2, 2, 2, 2));
        btnAddIgnore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = TmmProperties.getInstance().getProperty("movie.ignore.path");
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.ignore"), path);
                if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                    MovieSettingsPanel.this.settings.addMovieSkipFolder(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("movie.ignore.path", file.toAbsolutePath().toString());
                }
            }
        });
        panelIgnoreButtons.add((Component)btnAddIgnore, "1, 1");
        JButton btnRemoveIgnore = new JButton(IconManager.LIST_REMOVE);
        btnRemoveIgnore.setToolTipText(BUNDLE.getString("Settings.removeignore"));
        btnRemoveIgnore.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveIgnore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = MovieSettingsPanel.this.listIgnore.getSelectedIndex();
                if (row != -1) {
                    String ingore = MovieSettingsPanel.this.settings.getMovieSkipFolders().get(row);
                    MovieSettingsPanel.this.settings.removeMovieSkipFolder(ingore);
                }
            }
        });
        panelIgnoreButtons.add((Component)btnRemoveIgnore, "1, 3");
        JPanel panel = new JPanel();
        panelMovieDataSources.add((Component)panel, "2, 8, 13, 1, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"20dlu"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JLabel lblNfoFormat = new JLabel(BUNDLE.getString("Settings.nfoFormat"));
        panel.add((Component)lblNfoFormat, "1, 1, right, default");
        this.cbNfoFormat = new JComboBox<MovieConnectors>(MovieConnectors.values());
        panel.add(this.cbNfoFormat, "3, 1, fill, default");
        JLabel lblNfoFileNaming = new JLabel(BUNDLE.getString("Settings.nofFileNaming"));
        panel.add((Component)lblNfoFileNaming, "7, 1, right, default");
        this.cbMovieNfoFilename1 = new JCheckBox(BUNDLE.getString("Settings.moviefilename") + ".nfo");
        panel.add((Component)this.cbMovieNfoFilename1, "9, 1");
        this.cbMovieNfoFilename2 = new JCheckBox("movie.nfo");
        panel.add((Component)this.cbMovieNfoFilename2, "9, 2");
        this.cbMovieNfoFilename2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieSettingsPanel.this.checkChanges();
            }
        });
        this.cbMovieNfoFilename3 = new JCheckBox(BUNDLE.getString("Settings.nfo.discstyle"));
        panel.add((Component)this.cbMovieNfoFilename3, "9, 3");
        this.cbMovieNfoFilename3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieSettingsPanel.this.checkChanges();
            }
        });
        JLabel lblCertificationStyle = new JLabel(BUNDLE.getString("Settings.certificationformat"));
        panel.add((Component)lblCertificationStyle, "1, 5, right, default");
        this.cbCertificationStyle = new JComboBox();
        panel.add(this.cbCertificationStyle, "3, 5, 7, 1, fill, default");
        JPanel panelBadWords = new JPanel();
        panelBadWords.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.movie.badwords"), 4, 2, null, null));
        this.add((Component)panelBadWords, "4, 2, fill, fill");
        panelBadWords.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JTextPane txtpntBadWordsHint = new JTextPane();
        txtpntBadWordsHint.setBackground(UIManager.getColor("Panel.background"));
        txtpntBadWordsHint.setText(BUNDLE.getString("Settings.movie.badwords.hint"));
        TmmFontHelper.changeFont((JComponent)txtpntBadWordsHint, 0.833);
        panelBadWords.add((Component)txtpntBadWordsHint, "2, 2, 3, 1, fill, default");
        JScrollPane scpBadWords = new JScrollPane();
        panelBadWords.add((Component)scpBadWords, "2, 4, fill, fill");
        this.listBadWords = new JList();
        scpBadWords.setViewportView(this.listBadWords);
        JButton btnRemoveBadWord = new JButton(IconManager.LIST_REMOVE);
        btnRemoveBadWord.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemoveBadWord.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveBadWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = MovieSettingsPanel.this.listBadWords.getSelectedIndex();
                if (row != -1) {
                    String badWord = MovieModuleManager.MOVIE_SETTINGS.getBadWords().get(row);
                    MovieModuleManager.MOVIE_SETTINGS.removeBadWord(badWord);
                }
            }
        });
        panelBadWords.add((Component)btnRemoveBadWord, "4, 4, default, bottom");
        this.tfAddBadword = new JTextField();
        this.tfAddBadword.setColumns(10);
        panelBadWords.add((Component)this.tfAddBadword, "2, 6, fill, default");
        JButton btnAddBadWord = new JButton(IconManager.LIST_ADD);
        btnAddBadWord.setToolTipText(BUNDLE.getString("Button.add"));
        btnAddBadWord.setMargin(new Insets(2, 2, 2, 2));
        btnAddBadWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNotEmpty((CharSequence)MovieSettingsPanel.this.tfAddBadword.getText())) {
                    MovieModuleManager.MOVIE_SETTINGS.addBadWord(MovieSettingsPanel.this.tfAddBadword.getText());
                    MovieSettingsPanel.this.tfAddBadword.setText("");
                }
            }
        });
        panelBadWords.add((Component)btnAddBadWord, "4, 6");
        this.initDataBindings();
        List<MovieNfoNaming> movieNfoFilenames = this.settings.getMovieNfoFilenames();
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.FILENAME_NFO)) {
            this.cbMovieNfoFilename1.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.MOVIE_NFO)) {
            this.cbMovieNfoFilename2.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.DISC_NFO)) {
            this.cbMovieNfoFilename3.setSelected(true);
        }
        if (!Globals.isDonator()) {
            this.chckbxTraktTv.setSelected(false);
            this.chckbxTraktTv.setEnabled(false);
            btnClearTraktTvMovies.setEnabled(false);
        }
        this.cbNfoFormat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                block2: {
                    block3: {
                        if (MovieSettingsPanel.this.cbNfoFormat.getSelectedItem() != MovieConnectors.MP) break block3;
                        for (int i = 0; i < MovieSettingsPanel.this.cbCertificationStyle.getItemCount(); ++i) {
                            CertificationStyleWrapper wrapper = (CertificationStyleWrapper)MovieSettingsPanel.this.cbCertificationStyle.getItemAt(i);
                            if (wrapper.style != CertificationStyle.TECHNICAL) continue;
                            MovieSettingsPanel.this.cbCertificationStyle.setSelectedItem(wrapper);
                            break block2;
                        }
                        break block2;
                    }
                    if (MovieSettingsPanel.this.cbNfoFormat.getSelectedItem() != MovieConnectors.XBMC && MovieSettingsPanel.this.cbNfoFormat.getSelectedItem() != MovieConnectors.KODI) break block2;
                    for (int i = 0; i < MovieSettingsPanel.this.cbCertificationStyle.getItemCount(); ++i) {
                        CertificationStyleWrapper wrapper = (CertificationStyleWrapper)MovieSettingsPanel.this.cbCertificationStyle.getItemAt(i);
                        if (wrapper.style != CertificationStyle.LARGE) continue;
                        MovieSettingsPanel.this.cbCertificationStyle.setSelectedItem(wrapper);
                        break;
                    }
                }
            }
        });
        for (CertificationStyle style : CertificationStyle.values()) {
            CertificationStyleWrapper wrapper = new CertificationStyleWrapper();
            wrapper.style = style;
            this.cbCertificationStyle.addItem(wrapper);
            if (style != this.settings.getMovieCertificationStyle()) continue;
            this.cbCertificationStyle.setSelectedItem(wrapper);
        }
        this.cbCertificationStyle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieSettingsPanel.this.checkChanges();
            }
        });
        this.cbMovieNfoFilename1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MovieSettingsPanel.this.checkChanges();
            }
        });
    }

    private void checkChanges() {
        CertificationStyleWrapper wrapper;
        this.settings.clearMovieNfoFilenames();
        if (this.cbMovieNfoFilename1.isSelected()) {
            this.settings.addMovieNfoFilename(MovieNfoNaming.FILENAME_NFO);
        }
        if (this.cbMovieNfoFilename2.isSelected()) {
            this.settings.addMovieNfoFilename(MovieNfoNaming.MOVIE_NFO);
        }
        if (this.cbMovieNfoFilename3.isSelected()) {
            this.settings.addMovieNfoFilename(MovieNfoNaming.DISC_NFO);
        }
        if ((wrapper = (CertificationStyleWrapper)this.cbCertificationStyle.getSelectedItem()) != null && this.settings.getMovieCertificationStyle() != wrapper.style) {
            this.settings.setMovieCertificationStyle(wrapper.style);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"movieConnector");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, this.cbNfoFormat, (Property)jComboBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"buildImageCacheOnImport");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.chckbxImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"badWords");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, this.listBadWords);
        jListBinding.bind();
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"runtimeFromMediaInfo");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, (Object)this.chckbxRuntimeFromMf, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"yearColumnVisible");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, (Object)this.chckbxYear, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_13 = BeanProperty.create((String)"trailerColumnVisible");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_13, (Object)this.chckbxTrailer, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty_14 = BeanProperty.create((String)"subtitleColumnVisible");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_14, (Object)this.chckbxSubtitles, (Property)jCheckBoxBeanProperty);
        autoBinding_12.bind();
        BeanProperty settingsBeanProperty_15 = BeanProperty.create((String)"imageColumnVisible");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_15, (Object)this.chckbxImages, (Property)jCheckBoxBeanProperty);
        autoBinding_13.bind();
        BeanProperty settingsBeanProperty_16 = BeanProperty.create((String)"nfoColumnVisible");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_16, (Object)this.chckbxNfo, (Property)jCheckBoxBeanProperty);
        autoBinding_14.bind();
        BeanProperty settingsBeanProperty_17 = BeanProperty.create((String)"metadataColumnVisible");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_17, (Object)this.chckbxMetadata, (Property)jCheckBoxBeanProperty);
        autoBinding_15.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"syncTrakt");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"watchedColumnVisible");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxWatched, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"ratingColumnVisible");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.chckbxRating, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"dateAddedColumnVisible");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.chckbxDateAdded, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"storeUiFilters");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.chckbxSaveUiFilter, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"movieDataSource");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listDataSources);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"movieSkipFolders");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, this.listIgnore);
        jListBinding_2.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"movieRenameAfterScrape");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.chckbxRename, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
    }

    private class CertificationStyleWrapper {
        private CertificationStyle style;

        private CertificationStyleWrapper() {
        }

        public String toString() {
            String bundleTag = BUNDLE.getString("Settings.certification." + this.style.name().toLowerCase(Locale.ROOT));
            return bundleTag.replace("{}", CertificationStyle.formatCertification(Certification.DE_FSK16, this.style));
        }
    }
}

