/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRewriteNfoAction
extends AbstractAction {
    private static final long serialVersionUID = 2866581962767395824L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieRewriteNfoAction() {
        this.putValue("Name", BUNDLE.getString("movie.rewritenfo"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(BUNDLE.getString("movie.rewritenfo"), selectedMovies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (Movie movie : selectedMovies) {
                    movie.writeNFO();
                    movie.saveToDb();
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

