/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;

public class MediaIdTable
extends JTable {
    private static final long serialVersionUID = 8010722883277208728L;
    private Map<String, Object> idMap;
    private EventList<MediaId> idList;
    private boolean editable;

    public MediaIdTable(Map<String, Object> ids) {
        this.idMap = ids;
        this.editable = false;
        this.idList = MediaIdTable.convertIdMapToEventList(this.idMap);
        this.setModel((TableModel)new DefaultEventTableModel(this.idList, (TableFormat)new MediaIdTableFormat()));
        this.setTableHeader(null);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public MediaIdTable(EventList<MediaId> ids, ScraperType type) {
        this.idMap = null;
        this.editable = true;
        this.idList = ids;
        this.setModel((TableModel)new DefaultEventTableModel(this.idList, (TableFormat)new MediaIdTableFormat()));
        this.setTableHeader(null);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn column = this.getColumnModel().getColumn(0);
        HashSet<String> providerIds = new HashSet<String>();
        for (MediaId id : ids) {
            providerIds.add(id.key);
        }
        for (MediaScraper scraper : MediaScraper.getMediaScrapers(type)) {
            providerIds.add(scraper.getId());
        }
        JComboBox<String> comboBox = new JComboBox<String>(providerIds.toArray(new String[0]));
        column.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public static EventList<MediaId> convertIdMapToEventList(Map<String, Object> idMap) {
        BasicEventList idList = new BasicEventList();
        for (Map.Entry<String, Object> entry : idMap.entrySet()) {
            MediaId id = new MediaId();
            id.key = entry.getKey();
            try {
                id.value = entry.getValue().toString();
            }
            catch (Exception e) {
                id.value = "";
            }
            idList.add((Object)id);
        }
        return idList;
    }

    private class MediaIdTableFormat
    implements WritableTableFormat<MediaId> {
        private MediaIdTableFormat() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            return "";
        }

        public boolean isEditable(MediaId arg0, int arg1) {
            return MediaIdTable.this.editable;
        }

        public Object getColumnValue(MediaId arg0, int arg1) {
            if (arg0 == null) {
                return null;
            }
            switch (arg1) {
                case 0: {
                    return arg0.key;
                }
                case 1: {
                    return arg0.value;
                }
            }
            return null;
        }

        public MediaId setColumnValue(MediaId arg0, Object arg1, int arg2) {
            if (arg0 == null || arg1 == null) {
                return null;
            }
            switch (arg2) {
                case 0: {
                    arg0.key = arg1.toString();
                    break;
                }
                case 1: {
                    arg0.value = arg1.toString();
                }
            }
            return arg0;
        }
    }

    public static class MediaId {
        public String key;
        public String value;

        public MediaId() {
        }

        public MediaId(String key) {
            this.key = key;
        }

        public int hashCode() {
            return new HashCodeBuilder(19, 31).append((Object)this.key).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MediaId) || obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            MediaId other = (MediaId)obj;
            return StringUtils.equals((CharSequence)this.key, (CharSequence)other.key);
        }
    }
}

