/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseCheckBoxUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class SmallCheckBoxUI
extends BaseCheckBoxUI {
    private static SmallCheckBoxUI checkBoxUI = null;

    public static ComponentUI createUI(JComponent b) {
        if (checkBoxUI == null) {
            checkBoxUI = new SmallCheckBoxUI();
        }
        return checkBoxUI;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.icon = new CheckBoxIcon();
    }

    private static class CheckBoxIcon
    implements Icon {
        private static final Color MENU_ITEM_BACKGROUND = new Color(248, 248, 248);
        private static Icon checkIcon = new LazyImageIcon("icons/small/check_symbol_10x10.png");
        private static Icon checkIconDisabled = new LazyImageIcon("icons/small/check_symbol_disabled_10x10.png");
        private static final int WIDTH = 12;
        private static final int HEIGHT = 12;

        private CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!JTattooUtilities.isLeftToRight((Component)c)) {
                x += 3;
            }
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (c instanceof JCheckBoxMenuItem) {
                g.setColor(MENU_ITEM_BACKGROUND);
                g.fillRect(x, y, 12, 12);
                if (b.isEnabled()) {
                    g.setColor(AbstractLookAndFeel.getFrameColor());
                } else {
                    g.setColor(ColorHelper.brighter((Color)AbstractLookAndFeel.getFrameColor(), (double)40.0));
                }
                g.drawRect(x, y, 12, 12);
            } else if (b.isEnabled()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    JTattooUtilities.fillHorGradient((Graphics)g, (Color[])AbstractLookAndFeel.getTheme().getRolloverColors(), (int)x, (int)y, (int)12, (int)12);
                } else {
                    if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus()) {
                        JTattooUtilities.fillHorGradient((Graphics)g, (Color[])AbstractLookAndFeel.getTheme().getFocusColors(), (int)x, (int)y, (int)12, (int)12);
                    } else {
                        JTattooUtilities.fillHorGradient((Graphics)g, (Color[])AbstractLookAndFeel.getTheme().getCheckBoxColors(), (int)x, (int)y, (int)12, (int)12);
                    }
                    if (!model.isPressed()) {
                        g.setColor(Color.white);
                        g.drawLine(x + 1, y + 1, x + 1, y + 12 - 2);
                        g.drawLine(x + 12 - 1, y + 1, x + 12 - 1, y + 12 - 2);
                    }
                }
                if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus()) {
                    Color hiColor = ColorHelper.brighter((Color)AbstractLookAndFeel.getTheme().getFocusFrameColor(), (double)30.0);
                    Color loColor = ColorHelper.darker((Color)AbstractLookAndFeel.getTheme().getFocusFrameColor(), (double)20.0);
                    g.setColor(hiColor);
                    g.drawRect(x - 1, y - 1, 14, 14);
                    g.setColor(loColor);
                    g.drawRect(x, y, 12, 12);
                } else {
                    g.setColor(AbstractLookAndFeel.getFrameColor());
                    g.drawRect(x, y, 12, 12);
                }
            } else {
                JTattooUtilities.fillHorGradient((Graphics)g, (Color[])AbstractLookAndFeel.getTheme().getDisabledColors(), (int)x, (int)y, (int)12, (int)12);
                g.setColor(ColorHelper.brighter((Color)AbstractLookAndFeel.getFrameColor(), (double)40.0));
                g.drawRect(x, y, 12, 12);
            }
            int xi = x + (12 - checkIcon.getIconWidth()) / 2 + 1;
            int yi = y + (12 - checkIcon.getIconHeight()) / 2 + 1;
            if (model.isPressed() && model.isArmed()) {
                ColorUIResource bc = AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
                Color fc = ColorHelper.darker((Color)bc, (double)40.0);
                g.setColor(fc);
                g.drawRect(x + 2, y + 2, 8, 8);
                g.setColor(bc);
                g.fillRect(x + 3, y + 3, 6, 6);
            } else if (model.isSelected()) {
                if (b.isEnabled()) {
                    checkIcon.paintIcon(c, g, xi, yi);
                } else {
                    checkIconDisabled.paintIcon(c, g, xi, yi);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }
}

