/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieNfoNaming;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieActor;
import org.tinymediamanager.core.movie.entities.MovieProducer;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.util.ParserUtils;

@XmlRootElement(name="movie")
@XmlSeeAlso(value={Actor.class, Producer.class})
@XmlType(propOrder={"title", "originaltitle", "set", "sorttitle", "rating", "epbookmark", "year", "top250", "votes", "outline", "plot", "tagline", "runtime", "thumb", "fanart", "mpaa", "certification", "id", "ids", "tmdbId", "trailer", "country", "premiered", "status", "code", "aired", "fileinfo", "watched", "playcount", "genres", "studio", "credits", "director", "tags", "actors", "producers", "resume", "lastplayed", "dateadded", "keywords", "poster", "url", "languages", "source", "edition", "unsupportedElements"})
public class MovieToKodiNfoConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieToKodiNfoConnector.class);
    private static final Pattern PATTERN_NFO_MOVIE_TAG = Pattern.compile("<movie.*?>");
    private static JAXBContext context = MovieToKodiNfoConnector.initContext();
    public String title = "";
    public String originaltitle = "";
    @XmlJavaTypeAdapter(value=MovieSetAdapter.class)
    public Set set;
    public String sorttitle = "";
    public float rating = 0.0f;
    public String year = "";
    public String top250 = "";
    public int votes = 0;
    public String outline = "";
    public String plot = "";
    public String tagline = "";
    public String runtime = "";
    public String thumb = "";
    public String fanart = "";
    public String mpaa = "";
    public String certification = "";
    public String id = "";
    @XmlElementWrapper(name="ids")
    private Map<String, Object> ids;
    public int tmdbId = 0;
    public String trailer = "";
    public String country = "";
    public String premiered = "";
    public Fileinfo fileinfo;
    public boolean watched = false;
    public int playcount = 0;
    @XmlElement(name="genre")
    public List<String> genres;
    public List<String> studio;
    public List<String> credits;
    public List<String> director;
    @XmlElement(name="tag")
    private List<String> tags;
    @XmlAnyElement(lax=true)
    private List<Object> actors = new ArrayList<Object>();
    @XmlAnyElement(lax=true)
    private List<Object> producers;
    public String languages;
    public String source;
    public String edition;
    @XmlAnyElement(lax=true)
    private List<Object> unsupportedElements;
    public String epbookmark;
    public String lastplayed;
    public String status;
    public String code;
    public String aired;
    public Object resume;
    public String dateadded;
    public Object keywords;
    public Object poster;
    public Object url;

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{MovieToKodiNfoConnector.class, Actor.class, Set.class});
        }
        catch (JAXBException e) {
            LOGGER.error("Error instantiating JaxB", (Throwable)e);
            return null;
        }
    }

    public MovieToKodiNfoConnector() {
        this.genres = new ArrayList<String>();
        this.tags = new ArrayList<String>();
        this.director = new ArrayList<String>();
        this.credits = new ArrayList<String>();
        this.producers = new ArrayList<Object>();
        this.ids = new HashMap<String, Object>();
        this.unsupportedElements = new ArrayList<Object>();
        this.fileinfo = new Fileinfo();
        this.set = new Set();
    }

    public static void setData(Movie movie) {
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.nfo.writeerror", new String[]{":", "Context is null"}));
            return;
        }
        MovieToKodiNfoConnector kodi = MovieToKodiNfoConnector.createInstanceFromMovie(movie);
        ArrayList<MovieNfoNaming> nfonames = new ArrayList<MovieNfoNaming>();
        if (movie.isMultiMovieDir()) {
            nfonames.add(MovieNfoNaming.FILENAME_NFO);
        } else {
            nfonames = MovieModuleManager.MOVIE_SETTINGS.getMovieNfoFilenames();
        }
        MovieToKodiNfoConnector.writeNfoFiles(movie, kodi, nfonames);
    }

    static MovieToKodiNfoConnector createInstanceFromMovie(Movie movie) {
        Subtitle sub;
        MediaFile mediaFile2;
        MovieToKodiNfoConnector kodi = null;
        ArrayList<Object> unsupportedTags = new ArrayList<Object>();
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.NFO)) {
            Path file = mf.getFileAsPath();
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    kodi = MovieToKodiNfoConnector.parseNFO(file);
                }
                catch (Exception e) {
                    LOGGER.error("failed to parse " + mf.getFilename(), (Throwable)e);
                }
            }
            if (kodi == null) continue;
            break;
        }
        if (kodi == null) {
            kodi = new MovieToKodiNfoConnector();
        } else {
            for (Object obj : kodi.actors) {
                if (obj instanceof Producer || obj instanceof Actor) continue;
                unsupportedTags.add(obj);
            }
        }
        kodi.title = movie.getTitle();
        kodi.originaltitle = movie.getOriginalTitle();
        kodi.rating = movie.getRating();
        kodi.votes = movie.getVotes();
        kodi.top250 = movie.getTop250() == 0 ? "" : String.valueOf(movie.getTop250());
        kodi.year = movie.getYear();
        kodi.premiered = movie.getReleaseDateFormatted();
        kodi.plot = movie.getPlot();
        if (StringUtils.isNotBlank((CharSequence)kodi.plot) && kodi.plot.length() > 200) {
            int spaceIndex = kodi.plot.indexOf(" ", 200);
            kodi.outline = spaceIndex > 0 ? kodi.plot.substring(0, spaceIndex) + "..." : kodi.plot;
        } else if (StringUtils.isNotBlank((CharSequence)kodi.plot)) {
            kodi.outline = kodi.plot;
        }
        kodi.tagline = movie.getTagline();
        kodi.runtime = String.valueOf(movie.getRuntime());
        String artworkUrl = movie.getArtworkUrl(MediaFileType.POSTER);
        kodi.thumb = artworkUrl.matches("https?://.*") ? artworkUrl : "";
        artworkUrl = movie.getArtworkUrl(MediaFileType.FANART);
        kodi.fanart = artworkUrl.matches("https?://.*") ? artworkUrl : "";
        kodi.id = movie.getImdbId();
        if (movie.getTmdbId() != 0) {
            kodi.tmdbId = movie.getTmdbId();
        }
        kodi.ids.putAll(movie.getIds());
        if (StringUtils.isNotEmpty((CharSequence)movie.getProductionCompany())) {
            kodi.studio = Arrays.asList(movie.getProductionCompany().split("\\s*[,\\/]\\s*"));
        }
        kodi.country = movie.getCountry();
        kodi.watched = movie.isWatched();
        kodi.playcount = kodi.watched ? 1 : 0;
        kodi.languages = movie.getSpokenLanguages();
        if (movie.getCertification() != null) {
            kodi.certification = CertificationStyle.formatCertification(movie.getCertification(), MovieModuleManager.MOVIE_SETTINGS.getMovieCertificationStyle());
            kodi.mpaa = MovieModuleManager.MOVIE_SETTINGS.getCertificationCountry() == CountryCode.US ? Certification.getMPAAString((Certification)movie.getCertification()) : CertificationStyle.formatCertification(movie.getCertification(), MovieModuleManager.MOVIE_SETTINGS.getMovieCertificationStyle());
        }
        kodi.director.clear();
        if (StringUtils.isNotEmpty((CharSequence)movie.getDirector())) {
            String[] directors;
            for (String director : directors = movie.getDirector().split(", ")) {
                kodi.director.add(director);
            }
        }
        kodi.credits.clear();
        if (StringUtils.isNotEmpty((CharSequence)movie.getWriter())) {
            String[] writers;
            for (String writer : writers = movie.getWriter().split(", ")) {
                kodi.credits.add(writer);
            }
        }
        kodi.actors.clear();
        for (MovieActor cast : new ArrayList<MovieActor>(movie.getActors())) {
            kodi.addActor(cast.getName(), cast.getCharacter(), cast.getThumbUrl());
        }
        kodi.producers.clear();
        for (MovieProducer producer : new ArrayList<MovieProducer>(movie.getProducers())) {
            kodi.addProducer(producer.getName(), producer.getRole(), producer.getThumbUrl());
        }
        kodi.genres.clear();
        for (MediaGenres genre : new ArrayList<MediaGenres>(movie.getGenres())) {
            kodi.genres.add(genre.toString());
        }
        kodi.trailer = "";
        for (MovieTrailer trailer : new ArrayList<MovieTrailer>(movie.getTrailer())) {
            if (!trailer.getInNfo().booleanValue() || trailer.getUrl().startsWith("file")) continue;
            kodi.trailer = MovieToKodiNfoConnector.prepareTrailerForKodi(trailer);
            break;
        }
        if (kodi.trailer.isEmpty()) {
            kodi.trailer = null;
        }
        kodi.tags.clear();
        Iterator<Object> i$ = new ArrayList<String>(movie.getTags()).iterator();
        while (i$.hasNext()) {
            String tag = (String)i$.next();
            kodi.tags.add(tag);
        }
        if (movie.getMovieSet() != null) {
            MovieSet movieSet = movie.getMovieSet();
            kodi.set.name = movieSet.getTitle();
            kodi.set.overview = movieSet.getPlot();
        } else {
            kodi.set.name = "";
            kodi.set.overview = "";
        }
        kodi.sorttitle = movie.getSortTitle();
        if (movie.getMediaSource() != MediaSource.UNKNOWN) {
            kodi.source = movie.getMediaSource().name();
        }
        if (movie.getEdition() != MovieEdition.NONE) {
            kodi.edition = movie.getEdition().getTitle();
        }
        if ((i$ = movie.getMediaFiles(MediaFileType.VIDEO).iterator()).hasNext() && !StringUtils.isEmpty((CharSequence)(mediaFile2 = (MediaFile)i$.next()).getVideoCodec())) {
            kodi.fileinfo.streamdetails.video.codec = mediaFile2.getVideoCodec();
            kodi.fileinfo.streamdetails.video.aspect = String.valueOf(mediaFile2.getAspectRatio());
            kodi.fileinfo.streamdetails.video.width = mediaFile2.getVideoWidth();
            kodi.fileinfo.streamdetails.video.height = mediaFile2.getVideoHeight();
            kodi.fileinfo.streamdetails.video.durationinseconds = movie.getRuntimeFromMediaFiles();
            if (mediaFile2.getVideo3DFormat().equals("3D SBS") || mediaFile2.getVideo3DFormat().equals("3D HSBS")) {
                kodi.fileinfo.streamdetails.video.stereomode = "left_right";
            } else if (mediaFile2.getVideo3DFormat().equals("3D TAB") || mediaFile2.getVideo3DFormat().equals("3D HTAB")) {
                kodi.fileinfo.streamdetails.video.stereomode = "top_bottom";
            }
            kodi.fileinfo.streamdetails.audio.clear();
            for (MediaFileAudioStream as : mediaFile2.getAudioStreams()) {
                Audio audio = new Audio();
                audio.codec = StringUtils.isNotBlank((CharSequence)as.getCodec()) ? as.getCodec().replaceAll("-", "_") : as.getCodec();
                audio.language = as.getLanguage();
                audio.channels = String.valueOf(as.getChannelsAsInt());
                kodi.fileinfo.streamdetails.audio.add(audio);
            }
            kodi.fileinfo.streamdetails.subtitle.clear();
            for (MediaFileSubtitle ss : mediaFile2.getSubtitles()) {
                sub = new Subtitle();
                sub.language = ss.getLanguage();
                kodi.fileinfo.streamdetails.subtitle.add(sub);
            }
        }
        for (MediaFile mediaFile2 : movie.getMediaFiles(MediaFileType.SUBTITLE)) {
            for (MediaFileSubtitle ss : mediaFile2.getSubtitles()) {
                sub = new Subtitle();
                sub.language = ss.getLanguage();
                kodi.fileinfo.streamdetails.subtitle.add(sub);
            }
        }
        kodi.unsupportedElements.addAll(unsupportedTags);
        return kodi;
    }

    static void writeNfoFiles(Movie movie, MovieToKodiNfoConnector kodi, List<MovieNfoNaming> nfoNames) {
        String nfoFilename = "";
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (MovieNfoNaming name : nfoNames) {
            try {
                nfoFilename = movie.getNfoFilename(name);
                if (nfoFilename.isEmpty()) continue;
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.encoding", (Object)"UTF-8");
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                String comment = "<!-- created on " + dat + " - tinyMediaManager " + Globals.settings.getVersion() + " -->\n";
                m.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)comment);
                StringWriter w = new StringWriter();
                m.marshal((Object)kodi, (Writer)w);
                StringBuilder sb = new StringBuilder(((Object)w).toString());
                ((Writer)w).close();
                if (SystemUtils.IS_OS_WINDOWS) {
                    sb = new StringBuilder(sb.toString().replaceAll("(?<!\r)\n", "\r\n"));
                }
                Path f = movie.getPathNIO().resolve(nfoFilename);
                Utils.writeStringToFile(f, sb.toString());
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("setData " + movie.getPathNIO().resolve(nfoFilename), (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (newNfos.size() > 0) {
            movie.removeAllMediaFiles(MediaFileType.NFO);
            movie.addToMediaFiles(newNfos);
        }
    }

    public static Movie getData(Path nfoFile) {
        if (context == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, nfoFile, "message.nfo.readerror"));
            return null;
        }
        Movie movie = null;
        try {
            String urlFromNfo;
            Person cast;
            MovieList movieList;
            MovieSet movieSet;
            MovieToKodiNfoConnector kodi = MovieToKodiNfoConnector.parseNFO(nfoFile);
            movie = new Movie();
            movie.setTitle(kodi.title);
            movie.setOriginalTitle(kodi.originaltitle);
            movie.setRating(kodi.rating);
            movie.setVotes(kodi.votes);
            movie.setYear(kodi.year);
            if (StringUtils.isNotBlank((CharSequence)kodi.top250)) {
                try {
                    movie.setTop250(Integer.parseInt(kodi.top250));
                }
                catch (NumberFormatException e) {
                    movie.setTop250(0);
                }
            } else {
                movie.setTop250(0);
            }
            movie.setReleaseDate(kodi.premiered);
            movie.setPlot(kodi.plot);
            movie.setTagline(kodi.tagline);
            try {
                String rt = kodi.runtime.replaceAll("[^0-9]", "");
                movie.setRuntime(Integer.parseInt(rt));
            }
            catch (Exception e) {
                LOGGER.warn("could not parse runtime: " + kodi.runtime + "; Movie: " + movie.getPathNIO());
            }
            if (StringUtils.isNotBlank((CharSequence)kodi.thumb) && kodi.thumb.matches("https?://.*")) {
                movie.setArtworkUrl(kodi.thumb, MediaFileType.POSTER);
            }
            if (StringUtils.isNotBlank((CharSequence)kodi.fanart) && kodi.fanart.matches("https?://.*")) {
                movie.setArtworkUrl(kodi.fanart, MediaFileType.FANART);
            }
            for (Map.Entry<String, Object> entry : kodi.ids.entrySet()) {
                try {
                    if ("imdbId".equals(entry.getKey())) {
                        movie.setId("imdb", entry.getValue());
                        continue;
                    }
                    if ("tmdbId".equals(entry.getKey())) {
                        movie.setId("tmdb", entry.getValue());
                        continue;
                    }
                    movie.setId(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    LOGGER.warn("could not set ID: " + entry.getKey() + " ; " + entry.getValue());
                }
            }
            if (StringUtils.isBlank((CharSequence)movie.getImdbId())) {
                movie.setImdbId(kodi.id);
            }
            if (movie.getTmdbId() == 0 && kodi.tmdbId != 0) {
                movie.setTmdbId(kodi.tmdbId);
            }
            String director = "";
            for (String dir : kodi.director) {
                if (!StringUtils.isEmpty((CharSequence)director)) {
                    director = director + ", ";
                }
                director = director + dir;
            }
            movie.setDirector(director);
            String writer = "";
            for (String wri : kodi.credits) {
                if (StringUtils.isNotEmpty((CharSequence)writer)) {
                    writer = writer + ", ";
                }
                writer = writer + wri;
            }
            movie.setWriter(writer);
            String studio = StringUtils.join(kodi.studio, (String)" / ");
            if (studio == null) {
                movie.setProductionCompany("");
            } else {
                movie.setProductionCompany(studio);
            }
            movie.setProductionCompany(movie.getProductionCompany().replaceAll("\\s*,\\s*", " / "));
            movie.setCountry(kodi.country);
            if (!StringUtils.isEmpty((CharSequence)kodi.certification)) {
                movie.setCertification(MovieHelpers.parseCertificationStringForMovieSetupCountry(kodi.certification));
            }
            if (!StringUtils.isEmpty((CharSequence)kodi.mpaa) && movie.getCertification() == Certification.NOT_RATED) {
                movie.setCertification(MovieHelpers.parseCertificationStringForMovieSetupCountry(kodi.mpaa));
            }
            movie.setWatched(kodi.watched);
            if (kodi.playcount > 0) {
                movie.setWatched(true);
            }
            movie.setSpokenLanguages(kodi.languages);
            if (StringUtils.isNotBlank((CharSequence)kodi.source)) {
                try {
                    MediaSource source = MediaSource.valueOf(kodi.source);
                    if (source != null) {
                        movie.setMediaSource(source);
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)kodi.edition)) {
                MovieEdition edition = MovieEdition.getMovieEditionFromString(kodi.edition);
                movie.setEdition(edition);
            }
            if (StringUtils.isNotEmpty((CharSequence)kodi.set.name) && (movieSet = (movieList = MovieList.getInstance()).getMovieSet(kodi.set.name, 0)) != null) {
                if (StringUtils.isBlank((CharSequence)movieSet.getPlot())) {
                    movieSet.setPlot(kodi.set.overview);
                }
                movie.setMovieSet(movieSet);
            }
            movie.setSortTitle(kodi.sorttitle);
            for (Actor actor : kodi.getActors()) {
                cast = new MovieActor(actor.name, actor.role);
                cast.setThumbUrl(actor.thumb);
                movie.addActor((MovieActor)cast);
            }
            for (Producer producer : kodi.getProducers()) {
                cast = new MovieProducer(producer.name, producer.role);
                cast.setThumbUrl(producer.thumb);
                movie.addProducer((MovieProducer)cast);
            }
            for (String genre : kodi.genres) {
                String[] genres;
                for (String g : genres = genre.split("/")) {
                    MediaGenres genreFound = MediaGenres.getGenre((String)g.trim());
                    if (genreFound == null) continue;
                    movie.addGenre(genreFound);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)kodi.trailer) && !(urlFromNfo = MovieToKodiNfoConnector.parseTrailerUrl(kodi.trailer)).startsWith("file")) {
                MovieTrailer trailer = new MovieTrailer();
                trailer.setName("fromNFO");
                trailer.setProvider("from NFO");
                trailer.setQuality("unknown");
                trailer.setUrl(urlFromNfo);
                trailer.setInNfo(true);
                movie.addTrailer(trailer);
            }
            for (String tag : kodi.tags) {
                movie.addToTags(tag);
            }
        }
        catch (UnmarshalException e) {
            LOGGER.error("getData " + nfoFile, (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("getData " + nfoFile, (Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)movie.getTitle())) {
            return null;
        }
        return movie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MovieToKodiNfoConnector parseNFO(Path nfoFile) throws Exception {
        Unmarshaller um = context.createUnmarshaller();
        if (um == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, nfoFile, "message.nfo.readerror"));
            throw new Exception("could not create unmarshaller");
        }
        MovieToKodiNfoConnector kodi = null;
        try (Reader in = null;){
            in = new InputStreamReader((InputStream)new FileInputStream(nfoFile.toFile()), "UTF-8");
            kodi = (MovieToKodiNfoConnector)um.unmarshal(in);
        }
        if (kodi == null) {
            String completeNFO = Utils.readFileToString(nfoFile).trim().replaceFirst("^([\\W]+)<", "<");
            Matcher matcher = PATTERN_NFO_MOVIE_TAG.matcher(completeNFO);
            if (matcher.find()) {
                completeNFO = matcher.replaceFirst("<movie xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            }
            try {
                in = new StringReader(ParserUtils.cleanNfo(completeNFO));
                kodi = (MovieToKodiNfoConnector)um.unmarshal(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return kodi;
    }

    private void addActor(String name, String role, String thumb) {
        Actor actor = new Actor(name, role, thumb);
        this.actors.add(actor);
    }

    public List<Actor> getActors() {
        ArrayList<Actor> pureActors = new ArrayList<Actor>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Actor)) continue;
            Actor actor = (Actor)obj;
            pureActors.add(actor);
        }
        return pureActors;
    }

    private void addProducer(String name, String role, String thumb) {
        Producer producer = new Producer(name, role, thumb);
        this.producers.add(producer);
    }

    public List<Producer> getProducers() {
        ArrayList<Producer> pureProducers = new ArrayList<Producer>();
        for (Object obj : this.actors) {
            if (!(obj instanceof Producer)) continue;
            Producer producer = (Producer)obj;
            pureProducers.add(producer);
        }
        return pureProducers;
    }

    private static String prepareTrailerForKodi(MovieTrailer trailer) {
        Pattern pattern = Pattern.compile("https{0,1}://.*youtube..*/watch\\?v=(.*)$");
        Matcher matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            return "plugin://plugin.video.youtube/?action=play_video&videoid=" + matcher.group(1);
        }
        pattern = Pattern.compile("https{0,1}://.*(apple.com|yahoo-redir|yahoo.com|youtube.com|moviefone.com|ign.com|hd-trailers.net|aol.com).*");
        matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            try {
                return "plugin://plugin.video.hdtrailers_net/video/" + matcher.group(1) + "/" + URLEncoder.encode(trailer.getUrl(), "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error("failed to escape " + trailer.getUrl());
            }
        }
        return trailer.getUrl();
    }

    private static String parseTrailerUrl(String nfoTrailerUrl) {
        Pattern pattern = Pattern.compile("plugin://plugin.video.youtube/\\?action=play_video&videoid=(.*)$");
        Matcher matcher = pattern.matcher(nfoTrailerUrl);
        if (matcher.matches()) {
            return "http://www.youtube.com/watch?v=" + matcher.group(1);
        }
        pattern = Pattern.compile("plugin://plugin.video.hdtrailers_net/video/.*\\?/(.*)$");
        matcher = pattern.matcher(nfoTrailerUrl);
        if (matcher.matches()) {
            try {
                return URLDecoder.decode(matcher.group(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("failed to unescape " + nfoTrailerUrl);
            }
        }
        return nfoTrailerUrl;
    }

    static class MovieSetAdapter
    extends XmlAdapter<Set, Set> {
        MovieSetAdapter() {
        }

        public Set marshal(Set set) throws Exception {
            if (StringUtils.isBlank((CharSequence)set.name)) {
                return null;
            }
            return set;
        }

        public Set unmarshal(Set v) throws Exception {
            Set movieSet = new Set();
            if (StringUtils.isBlank((CharSequence)v.name) && !v.mixed.isEmpty()) {
                try {
                    movieSet.name = v.mixed.get(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank((CharSequence)movieSet.name)) {
                movieSet.name = v.name;
                movieSet.overview = v.overview;
            }
            return movieSet;
        }
    }

    static class Set {
        public String name = "";
        public String overview = "";
        List<String> mixed;

        Set() {
        }

        @XmlMixed
        public List<String> getMixed() {
            return this.mixed;
        }

        public void setMixed(List<String> mixed) {
            this.mixed = mixed;
        }
    }

    static class Subtitle {
        public String language;

        Subtitle() {
        }
    }

    static class Audio {
        public String codec;
        public String language;
        public String channels;

        Audio() {
        }
    }

    static class Video {
        public String codec;
        public String aspect;
        public int width;
        public int height;
        public int durationinseconds;
        public String stereomode;

        Video() {
        }
    }

    static class Streamdetails {
        public Video video = new Video();
        public List<Audio> audio = new ArrayList<Audio>();
        public List<Subtitle> subtitle = new ArrayList<Subtitle>();
    }

    static class Fileinfo {
        public Streamdetails streamdetails = new Streamdetails();
    }

    @XmlRootElement(name="producer")
    public static class Producer {
        public String name;
        public String role;
        public String thumb;

        public Producer() {
        }

        public Producer(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }
    }

    @XmlRootElement(name="actor")
    public static class Actor {
        public String name;
        public String role;
        public String thumb;

        public Actor() {
        }

        public Actor(String name, String role, String thumb) {
            this.name = name;
            this.role = role;
            this.thumb = thumb;
        }
    }
}

