/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractModelObject {
    private final PropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this, true);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        try {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        try {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
        catch (AssertionError e) {
            // empty catch block
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }
}

